/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_3222;
import net.minecraft.class_5903;
import net.minecraft.class_5904;
import net.minecraft.class_5905;
import org.texboobcat.questory.quest.Reward;

public class TitleReward
extends Reward {
    private String title;
    private String subtitle;
    private int fadeIn;
    private int stay;
    private int fadeOut;

    public TitleReward(String title, String subtitle) {
        super("title");
        this.title = title;
        this.subtitle = subtitle;
        this.fadeIn = 10;
        this.stay = 70;
        this.fadeOut = 20;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public void setTimings(int fadeIn, int stay, int fadeOut) {
        this.fadeIn = fadeIn;
        this.stay = stay;
        this.fadeOut = fadeOut;
    }

    @Override
    public void grant(class_3222 player) {
        player.field_13987.method_14364((class_2596)new class_5905(this.fadeIn, this.stay, this.fadeOut));
        if (this.subtitle != null && !this.subtitle.isEmpty()) {
            player.field_13987.method_14364((class_2596)new class_5903((class_2561)class_2561.method_43470((String)this.subtitle)));
        }
        if (this.title != null && !this.title.isEmpty()) {
            player.field_13987.method_14364((class_2596)new class_5904((class_2561)class_2561.method_43470((String)this.title)));
        }
    }

    @Override
    public String getDisplayString() {
        return "Show title: " + this.title;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.type);
        json.addProperty("title", this.title);
        if (this.subtitle != null) {
            json.addProperty("subtitle", this.subtitle);
        }
        json.addProperty("fadeIn", (Number)this.fadeIn);
        json.addProperty("stay", (Number)this.stay);
        json.addProperty("fadeOut", (Number)this.fadeOut);
        return json;
    }

    public static TitleReward fromJson(JsonObject json) {
        String title = json.get("title").getAsString();
        String subtitle = json.has("subtitle") ? json.get("subtitle").getAsString() : null;
        TitleReward reward = new TitleReward(title, subtitle);
        if (json.has("fadeIn") && json.has("stay") && json.has("fadeOut")) {
            reward.setTimings(json.get("fadeIn").getAsInt(), json.get("stay").getAsInt(), json.get("fadeOut").getAsInt());
        }
        return reward;
    }
}

