/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.texboobcat.questory.Questory;
import org.texboobcat.questory.client.hooks.ClientHooks;
import org.texboobcat.questory.client.hooks.HudOverlay;

@Mod.EventBusSubscriber(modid="questory", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public final class QuestoryForgeClient {
    private QuestoryForgeClient() {
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        Questory.LOGGER.info("QuestifyForgeClient initialized");
        MinecraftForge.EVENT_BUS.addListener(QuestoryForgeClient::onRenderGuiPost);
    }

    private static void onRenderGuiPost(RenderGuiEvent.Post event) {
        try {
            GuiGraphics gfx = event.getGuiGraphics();
            PoseStack pose = gfx.m_280168_();
            Minecraft mc = Minecraft.m_91087_();
            int w = mc.m_91268_().m_85445_();
            int h = mc.m_91268_().m_85446_();
            float pt = mc.m_91296_();
            for (HudOverlay overlay : ClientHooks.getOverlays()) {
                try {
                    overlay.render(pose, w, h, pt);
                }
                catch (Throwable t) {
                    Questory.LOGGER.error("HUD overlay render error: {}", (Object)t.getMessage());
                }
            }
        }
        catch (Throwable t) {
            Questory.LOGGER.error("Forge GUI render hook failed: {}", (Object)t.getMessage());
        }
    }
}

