/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.texboobcat.questory.client.gui.QuestIconRenderer;

public class IconPickerScreen
extends Screen {
    private final Screen parent;
    private final String initialValue;
    private final Consumer<String> callback;
    private Tab currentTab = Tab.ITEMS;
    private final List<ResourceLocation> allItems = new ArrayList<ResourceLocation>();
    private List<ResourceLocation> filteredItems = new ArrayList<ResourceLocation>();
    private final List<ResourceLocation> allTextures = new ArrayList<ResourceLocation>();
    private List<ResourceLocation> filteredTextures = new ArrayList<ResourceLocation>();
    private boolean texturesLoaded = false;
    private ResourceLocation selectedId = null;
    private String manualValue = "";
    private EditBox searchBox;
    private EditBox manualInputBox;
    private Button itemsTabBtn;
    private Button texturesTabBtn;
    private float scrollOffset = 0.0f;
    private boolean isDraggingScroll = false;
    private static final int PAD = 10;
    private static final int ITEM_SIZE = 18;
    private static final int COLS = 9;
    private static final int TEXTURE_ROW_H = 14;
    private int listX;
    private int listY;
    private int listW;
    private int listH;
    private int previewX;
    private int previewY;
    private int previewW;
    private int previewH;

    public IconPickerScreen(Screen parent, String currentValue, Consumer<String> callback) {
        super((Component)Component.m_237113_((String)"Icon Picker"));
        this.parent = parent;
        this.manualValue = this.initialValue = currentValue == null ? "" : currentValue;
        this.callback = callback;
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.allItems.isEmpty()) {
            for (ResourceLocation id : BuiltInRegistries.f_257033_.m_6566_()) {
                if (id.equals((Object)BuiltInRegistries.f_257033_.m_7981_((Object)Items.f_41852_))) continue;
                this.allItems.add(id);
            }
            this.allItems.sort(Comparator.comparing(ResourceLocation::toString));
            this.updateFilter("");
        }
        int totalW = Math.min(420, this.f_96543_ - 20);
        int totalH = this.f_96544_ - 40;
        int startX = (this.f_96543_ - totalW) / 2;
        int startY = 20;
        this.itemsTabBtn = Button.m_253074_((Component)Component.m_237113_((String)"Items"), b -> this.setTab(Tab.ITEMS)).m_252987_(startX, startY, 60, 20).m_253136_();
        this.texturesTabBtn = Button.m_253074_((Component)Component.m_237113_((String)"Textures"), b -> this.setTab(Tab.TEXTURES)).m_252987_(startX + 65, startY, 70, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.itemsTabBtn);
        this.m_142416_((GuiEventListener)this.texturesTabBtn);
        this.updateTabButtons();
        this.searchBox = new EditBox(this.f_96547_, startX + 140, startY + 1, totalW - 140, 18, (Component)Component.m_237113_((String)"Search..."));
        this.searchBox.m_94151_(this::updateFilter);
        this.m_142416_((GuiEventListener)this.searchBox);
        this.listX = startX;
        this.listY = startY + 25;
        this.listW = (int)((double)totalW * 0.65);
        this.listH = totalH - 60;
        this.previewX = this.listX + this.listW + 10;
        this.previewY = this.listY;
        this.previewW = totalW - this.listW - 10;
        this.previewH = this.listH;
        this.manualInputBox = new EditBox(this.f_96547_, startX, this.listY + this.listH + 5, totalW - 130, 18, (Component)Component.m_237113_((String)"Icon path"));
        this.manualInputBox.m_94199_(256);
        this.manualInputBox.m_94144_(this.manualValue);
        this.manualInputBox.m_94151_(val -> {
            this.manualValue = val;
            if (this.currentTab == Tab.ITEMS && BuiltInRegistries.f_257033_.m_7804_(new ResourceLocation(val))) {
                this.selectedId = new ResourceLocation(val);
            } else if (this.currentTab == Tab.TEXTURES && val.startsWith("texture:")) {
                try {
                    String path = val.substring("texture:".length());
                    if (path.contains(":")) {
                        String[] p = path.split(":", 2);
                        this.selectedId = new ResourceLocation(p[0], p[1]);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.m_142416_((GuiEventListener)this.manualInputBox);
        int btnY = this.listY + this.listH + 5;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Select"), b -> this.confirm()).m_252987_(startX + totalW - 125, btnY, 60, 18).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), b -> this.m_7379_()).m_252987_(startX + totalW - 60, btnY, 60, 18).m_253136_());
        if (this.initialValue.startsWith("texture:")) {
            this.setTab(Tab.TEXTURES);
        }
    }

    private void setTab(Tab tab) {
        this.currentTab = tab;
        this.updateTabButtons();
        this.scrollOffset = 0.0f;
        if (tab == Tab.TEXTURES && !this.texturesLoaded) {
            this.loadTextures();
        }
        this.updateFilter(this.searchBox.m_94155_());
    }

    private void updateTabButtons() {
        this.itemsTabBtn.f_93623_ = this.currentTab != Tab.ITEMS;
        this.texturesTabBtn.f_93623_ = this.currentTab != Tab.TEXTURES;
    }

    private void loadTextures() {
        this.texturesLoaded = true;
        this.allTextures.clear();
        try {
            ResourceManager rm = Minecraft.m_91087_().m_91098_();
            Map resources = rm.m_214159_("textures", path -> path.m_135815_().endsWith(".png"));
            this.allTextures.addAll(resources.keySet());
            this.allTextures.sort(Comparator.comparing(ResourceLocation::toString));
        }
        catch (Exception e) {
            System.err.println("Failed to list textures: " + e.getMessage());
        }
    }

    private void updateFilter(String query) {
        String q = query.toLowerCase(Locale.ROOT).trim();
        if (this.currentTab == Tab.ITEMS) {
            this.filteredItems.clear();
            if (q.isEmpty()) {
                this.filteredItems.addAll(this.allItems);
            } else {
                for (ResourceLocation id : this.allItems) {
                    if (!id.toString().contains(q)) continue;
                    this.filteredItems.add(id);
                }
            }
        } else {
            this.filteredTextures.clear();
            if (q.isEmpty()) {
                this.filteredTextures.addAll(this.allTextures);
            } else {
                for (ResourceLocation id : this.allTextures) {
                    if (!id.toString().contains(q)) continue;
                    this.filteredTextures.add(id);
                }
            }
        }
        this.scrollOffset = 0.0f;
    }

    private void confirm() {
        if (this.callback != null) {
            this.callback.accept(this.manualInputBox.m_94155_());
        }
        this.m_7379_();
    }

    public void m_7379_() {
        if (this.parent != null) {
            this.f_96541_.m_91152_(this.parent);
        } else {
            super.m_7379_();
        }
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(g);
        super.m_88315_(g, mouseX, mouseY, partialTick);
        g.m_280509_(this.listX, this.listY, this.listX + this.listW, this.listY + this.listH, Integer.MIN_VALUE);
        g.m_280637_(this.listX - 1, this.listY - 1, this.listW + 2, this.listH + 2, -1);
        if (this.currentTab == Tab.ITEMS) {
            this.renderItems(g, mouseX, mouseY);
        } else {
            this.renderTextures(g, mouseX, mouseY);
        }
        g.m_280488_(this.f_96547_, "Preview", this.previewX, this.previewY, -1);
        int pvSize = Math.min(128, this.previewW);
        int px = this.previewX + (this.previewW - pvSize) / 2;
        int py = this.previewY + 20;
        g.m_280509_(px - 2, py - 2, px + pvSize + 2, py + pvSize + 2, -16777216);
        g.m_280637_(px - 2, py - 2, pvSize + 4, pvSize + 4, -7829368);
        String val = this.manualInputBox.m_94155_();
        if (!val.isEmpty()) {
            try {
                QuestIconRenderer.render(g, val, px, py, pvSize);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.currentTab == Tab.TEXTURES) {
            g.m_280554_(this.f_96547_, (FormattedText)Component.m_237113_((String)"Showing all loaded textures. Use search to filter by mod ID (e.g. 'create') or name."), this.previewX, py + pvSize + 10, this.previewW, -5592406);
        }
    }

    private void renderItems(GuiGraphics g, int mouseX, int mouseY) {
        int visibleRows = this.listH / 18;
        int totalRows = (int)Math.ceil((double)this.filteredItems.size() / 9.0);
        int startIndex = (int)(this.scrollOffset * (float)Math.max(0, totalRows - visibleRows)) * 9;
        g.m_280588_(this.listX, this.listY, this.listX + this.listW - 8, this.listY + this.listH);
        int x = this.listX + 2;
        int y = this.listY + 2;
        for (int i = startIndex; i < this.filteredItems.size(); ++i) {
            boolean hovered;
            ResourceLocation id = this.filteredItems.get(i);
            int row = (i - startIndex) / 9;
            int col = (i - startIndex) % 9;
            if (row >= visibleRows) break;
            int itemX = x + col * 18;
            int itemY = y + row * 18;
            boolean bl = hovered = mouseX >= itemX && mouseX < itemX + 18 && mouseY >= itemY && mouseY < itemY + 18;
            if (id.equals((Object)this.selectedId)) {
                g.m_280509_(itemX, itemY, itemX + 18, itemY + 18, -11513696);
                g.m_280637_(itemX, itemY, 18, 18, -1);
            } else if (hovered) {
                g.m_280509_(itemX, itemY, itemX + 18, itemY + 18, -12566464);
            }
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(id);
            g.m_280480_(new ItemStack((ItemLike)item), itemX + 1, itemY + 1);
            if (!hovered) continue;
            g.m_280557_(this.f_96547_, (Component)Component.m_237113_((String)id.toString()), mouseX, mouseY);
        }
        g.m_280618_();
        this.renderScrollbar(g, totalRows, visibleRows);
    }

    private void renderTextures(GuiGraphics g, int mouseX, int mouseY) {
        int visibleCount = this.listH / 14;
        int totalCount = this.filteredTextures.size();
        int startIndex = (int)(this.scrollOffset * (float)Math.max(0, totalCount - visibleCount));
        g.m_280588_(this.listX, this.listY, this.listX + this.listW - 8, this.listY + this.listH);
        for (int i = 0; i < visibleCount && startIndex + i < totalCount; ++i) {
            ResourceLocation id = this.filteredTextures.get(startIndex + i);
            int y = this.listY + 2 + i * 14;
            boolean hovered = mouseX >= this.listX && mouseX < this.listX + this.listW - 10 && mouseY >= y && mouseY < y + 14;
            boolean selected = id.equals((Object)this.selectedId);
            if (selected) {
                g.m_280509_(this.listX + 1, y, this.listX + this.listW - 9, y + 14, -12952966);
            } else if (hovered) {
                g.m_280509_(this.listX + 1, y, this.listX + this.listW - 9, y + 14, -14013910);
            }
            Object name = id.toString();
            if (this.f_96547_.m_92895_((String)name) > this.listW - 12) {
                name = this.f_96547_.m_92854_((FormattedText)Component.m_237113_((String)name), this.listW - 20).getString() + "...";
            }
            g.m_280488_(this.f_96547_, (String)name, this.listX + 4, y + 3, -2236963);
        }
        g.m_280618_();
        this.renderScrollbar(g, totalCount, visibleCount);
    }

    private void renderScrollbar(GuiGraphics g, int total, int visible) {
        int scrollBarH = this.listH;
        int scrollBarW = 6;
        int scrollBarX = this.listX + this.listW - 8;
        int scrollBarY = this.listY;
        g.m_280509_(scrollBarX, scrollBarY, scrollBarX + scrollBarW, scrollBarY + scrollBarH, -14671840);
        if (total > visible) {
            int thumbH = Math.max(20, (int)((float)visible / (float)total * (float)scrollBarH));
            int thumbY = scrollBarY + (int)(this.scrollOffset * (float)(scrollBarH - thumbH));
            g.m_280509_(scrollBarX, thumbY, scrollBarX + scrollBarW, thumbY + thumbH, -8355712);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (super.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (mouseX >= (double)this.listX && mouseX < (double)(this.listX + this.listW - 10) && mouseY >= (double)this.listY && mouseY < (double)(this.listY + this.listH)) {
            if (this.currentTab == Tab.ITEMS) {
                int index;
                int visibleRows = this.listH / 18;
                int totalRows = (int)Math.ceil((double)this.filteredItems.size() / 9.0);
                int startRow = (int)(this.scrollOffset * (float)Math.max(0, totalRows - visibleRows));
                int col = (int)((mouseX - (double)this.listX - 2.0) / 18.0);
                int row = (int)((mouseY - (double)this.listY - 2.0) / 18.0);
                if (col >= 0 && col < 9 && row >= 0 && row < visibleRows && (index = (startRow + row) * 9 + col) >= 0 && index < this.filteredItems.size()) {
                    this.selectedId = this.filteredItems.get(index);
                    this.manualInputBox.m_94144_(this.selectedId.toString());
                    this.manualValue = this.selectedId.toString();
                    return true;
                }
            } else {
                int index;
                int visibleCount = this.listH / 14;
                int totalCount = this.filteredTextures.size();
                int startIndex = (int)(this.scrollOffset * (float)Math.max(0, totalCount - visibleCount));
                int row = (int)((mouseY - (double)this.listY - 2.0) / 14.0);
                if (row >= 0 && row < visibleCount && (index = startIndex + row) >= 0 && index < this.filteredTextures.size()) {
                    this.selectedId = this.filteredTextures.get(index);
                    String val = "texture:" + this.selectedId.m_135827_() + ":" + this.selectedId.m_135815_();
                    this.manualInputBox.m_94144_(val);
                    this.manualValue = val;
                    return true;
                }
            }
        }
        if (mouseX >= (double)(this.listX + this.listW - 10) && mouseX < (double)(this.listX + this.listW) && mouseY >= (double)this.listY && mouseY < (double)(this.listY + this.listH)) {
            this.isDraggingScroll = true;
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.isDraggingScroll = false;
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (mouseX >= (double)this.listX && mouseX < (double)(this.listX + this.listW) && mouseY >= (double)this.listY && mouseY < (double)(this.listY + this.listH)) {
            int total;
            int visible;
            if (this.currentTab == Tab.ITEMS) {
                visible = this.listH / 18;
                total = (int)Math.ceil((double)this.filteredItems.size() / 9.0);
            } else {
                visible = this.listH / 14;
                total = this.filteredTextures.size();
            }
            if (total > visible) {
                float scrollStep = 1.0f / (float)(total - visible);
                this.scrollOffset = Math.max(0.0f, Math.min(1.0f, this.scrollOffset - (float)delta * scrollStep));
            }
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDraggingScroll) {
            int total;
            int visible;
            if (this.currentTab == Tab.ITEMS) {
                visible = this.listH / 18;
                total = (int)Math.ceil((double)this.filteredItems.size() / 9.0);
            } else {
                visible = this.listH / 14;
                total = this.filteredTextures.size();
            }
            if (total > visible) {
                int scrollBarH = this.listH;
                int thumbH = Math.max(20, (int)((float)visible / (float)total * (float)scrollBarH));
                float trackH = scrollBarH - thumbH;
                this.scrollOffset = Math.max(0.0f, Math.min(1.0f, this.scrollOffset + (float)dragY / trackH));
            }
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_7043_() {
        return false;
    }

    private static enum Tab {
        ITEMS,
        TEXTURES;

    }
}

