/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.questory.client.gui.IconPickerScreen;

public class ImagePickerScreen
extends Screen {
    private final Screen parent;
    private final Consumer<String> callback;
    private EditBox widthField;
    private EditBox heightField;
    private String selectedPath = "";

    public ImagePickerScreen(Screen parent, Consumer<String> callback) {
        super((Component)Component.m_237113_((String)"Insert Image"));
        this.parent = parent;
        this.callback = callback;
    }

    protected void m_7856_() {
        super.m_7856_();
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        this.widthField = new EditBox(this.f_96547_, centerX - 100, centerY - 20, 80, 18, (Component)Component.m_237113_((String)"Width"));
        this.widthField.m_94144_("200");
        this.widthField.m_94199_(5);
        this.widthField.m_257771_((Component)Component.m_237113_((String)"Width"));
        this.m_142416_((GuiEventListener)this.widthField);
        this.heightField = new EditBox(this.f_96547_, centerX + 20, centerY - 20, 80, 18, (Component)Component.m_237113_((String)"Height"));
        this.heightField.m_94144_("15");
        this.heightField.m_94199_(5);
        this.heightField.m_257771_((Component)Component.m_237113_((String)"Height"));
        this.m_142416_((GuiEventListener)this.heightField);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Browse Texture..."), b -> this.openTextureBrowser()).m_252987_(centerX - 100, centerY + 10, 200, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Insert"), b -> this.insertImage()).m_252987_(centerX - 60, centerY + 40, 56, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), b -> this.f_96541_.m_91152_(this.parent)).m_252987_(centerX + 4, centerY + 40, 56, 20).m_253136_());
    }

    private void openTextureBrowser() {
        this.f_96541_.m_91152_((Screen)new IconPickerScreen(this, this.selectedPath, result -> {
            this.selectedPath = result;
            this.f_96541_.m_91152_((Screen)this);
        }));
    }

    private void insertImage() {
        if (this.selectedPath.isEmpty()) {
            if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7cPlease select a texture first!"));
            }
            return;
        }
        int width = 200;
        int height = 15;
        try {
            width = Integer.parseInt(this.widthField.m_94155_());
        }
        catch (NumberFormatException e) {
            width = 200;
        }
        try {
            height = Integer.parseInt(this.heightField.m_94155_());
        }
        catch (NumberFormatException e) {
            height = 15;
        }
        String imageTag = String.format("<img src=\"%s\" width=\"%d\" height=\"%d\"/>", this.selectedPath, width, height);
        this.callback.accept(imageTag);
        this.f_96541_.m_91152_(this.parent);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        graphics.m_280137_(this.f_96547_, "Insert Image", centerX, centerY - 60, -1);
        graphics.m_280488_(this.f_96547_, "Width:", centerX - 140, centerY - 16, -1);
        graphics.m_280488_(this.f_96547_, "Height:", centerX - 20, centerY - 16, -1);
        if (!this.selectedPath.isEmpty()) {
            String display = this.selectedPath.length() > 40 ? "..." + this.selectedPath.substring(this.selectedPath.length() - 37) : this.selectedPath;
            graphics.m_280137_(this.f_96547_, "\u00a77Selected: \u00a7f" + display, centerX, centerY - 40, -3355444);
        } else {
            graphics.m_280137_(this.f_96547_, "\u00a77No texture selected", centerX, centerY - 40, -7829368);
        }
    }

    public boolean m_7043_() {
        return false;
    }
}

