/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.texboobcat.questory.client.ClientQuestManager;
import org.texboobcat.questory.client.UiScaleUtil;
import org.texboobcat.questory.client.gui.AdvancedTabPanel;
import org.texboobcat.questory.client.gui.ClientInputHelper;
import org.texboobcat.questory.client.gui.DependenciesTabPanel;
import org.texboobcat.questory.client.gui.GeneralTabPanel;
import org.texboobcat.questory.client.gui.PreviewTabPanel;
import org.texboobcat.questory.client.gui.RequirementsTabPanel;
import org.texboobcat.questory.client.gui.RewardsTabPanel;
import org.texboobcat.questory.client.gui.TeamTabPanel;
import org.texboobcat.questory.client.gui.TextFormatter;
import org.texboobcat.questory.client.gui.editor.AutoSaveManager;
import org.texboobcat.questory.client.gui.editor.CloseConfirmationDialog;
import org.texboobcat.questory.client.gui.editor.EditorNotification;
import org.texboobcat.questory.client.gui.editor.EditorSettingsScreen;
import org.texboobcat.questory.client.gui.editor.EditorStateManager;
import org.texboobcat.questory.client.gui.editor.EditorStatusBar;
import org.texboobcat.questory.client.gui.editor.FieldValidation;
import org.texboobcat.questory.client.gui.editor.ManagedEditor;
import org.texboobcat.questory.client.gui.editor.UnsavedChangesCache;
import org.texboobcat.questory.client.gui.search.AdvancedSearchFilter;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.network.QuestCreateRequestPacket;
import org.texboobcat.questory.network.QuestDeleteRequestPacket;
import org.texboobcat.questory.network.QuestUpdateRequestPacket;
import org.texboobcat.questory.quest.ChapterData;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.validation.QuestValidator;

public class QuestEditorScreen
extends Screen
implements ManagedEditor<Quest> {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final int SIDEBAR_W = 240;
    private static final int TAB_H = 24;
    private static final int HEADER_H = 32;
    private static final int FOOTER_H = 36;
    private static final int PAD = 8;
    private final Screen parent;
    private Quest workingQuest;
    private String originalId;
    private final EditorStateManager<Quest> stateManager;
    private final UnsavedChangesCache<Quest> unsavedCache;
    private final AutoSaveManager autoSaveManager;
    private Tab activeTab = Tab.GENERAL;
    private EditBox searchBox;
    private List<Quest> filtered = new ArrayList<Quest>();
    private int listScroll = 0;
    private String lastSearchQueryCache = null;
    private AdvancedSearchFilter cachedSearchFilter = null;
    private GeneralTabPanel generalTab;
    private DependenciesTabPanel dependenciesTab;
    private RequirementsTabPanel requirementsTab;
    private RewardsTabPanel rewardsTab;
    private TeamTabPanel teamTab;
    private AdvancedTabPanel advancedTab;
    private PreviewTabPanel previewTab;
    private Button tabGeneralBtn;
    private Button tabDepsBtn;
    private Button tabReqsBtn;
    private Button tabRwdsBtn;
    private Button tabTeamBtn;
    private Button tabAdvBtn;
    private Button tabPreviewBtn;
    private Button newBtn;
    private Button saveBtn;
    private Button deleteBtn;
    private Button closeBtn;
    private Button settingsBtn;
    private Button saveAllBtn;
    private boolean deleteConfirmPending = false;
    private long deleteConfirmTime = 0L;
    private EditorStatusBar statusBar;
    private FieldValidation fieldValidation;

    public QuestEditorScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"Quest Editor"));
        this.parent = parent;
        this.stateManager = new EditorStateManager<Quest>(this::cloneQuest, Quest::getId);
        this.unsavedCache = new UnsavedChangesCache(50);
        this.autoSaveManager = AutoSaveManager.getInstance();
    }

    public Font getFont() {
        return this.f_96547_;
    }

    public Minecraft getMinecraft() {
        return this.f_96541_;
    }

    public Quest getWorkingQuest() {
        return this.workingQuest;
    }

    @Override
    public EditorStateManager<Quest> getStateManager() {
        return this.stateManager;
    }

    public FieldValidation getFieldValidation() {
        return this.fieldValidation;
    }

    private void setupValidationRules() {
        this.fieldValidation.addRule("questId", FieldValidation.Rules.combine(FieldValidation.Rules.notEmpty(), FieldValidation.Rules.pattern("[a-zA-Z0-9_]+", "ID must contain only letters, numbers, and underscores")));
        this.fieldValidation.addRule("title", FieldValidation.Rules.maxLength(200));
        this.fieldValidation.addRule("xPos", FieldValidation.Rules.numeric());
        this.fieldValidation.addRule("yPos", FieldValidation.Rules.numeric());
        this.fieldValidation.addRule("size", FieldValidation.Rules.custom(value -> {
            if (value == null || value.trim().isEmpty()) {
                return true;
            }
            try {
                double d = Double.parseDouble(value.trim());
                return d > 0.0 && d <= 10.0;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }, "Size must be a number between 0 and 10"));
        this.fieldValidation.addRule("iconScale", FieldValidation.Rules.custom(value -> {
            if (value == null || value.trim().isEmpty()) {
                return true;
            }
            try {
                double d = Double.parseDouble(value.trim());
                return d > 0.0 && d <= 5.0;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }, "Icon scale must be a number between 0 and 5"));
    }

    @Override
    public void saveEntity(Quest quest) {
        if (quest == null) {
            return;
        }
        boolean idChanged = this.originalId != null && !this.originalId.isEmpty() && !this.originalId.equals(quest.getId());
        String oldId = this.originalId;
        String newId = quest.getId();
        if (idChanged) {
            ArrayList<Quest> updatedQuests = new ArrayList<Quest>();
            for (Quest q : ClientQuestManager.getInstance().getAllQuests()) {
                if (q.getId().equals(oldId)) continue;
                boolean questModified = false;
                if (q.getDependencies().contains(oldId)) {
                    q.getDependencies().remove(oldId);
                    q.getDependencies().add(newId);
                    questModified = true;
                }
                if (!questModified) continue;
                updatedQuests.add(q);
            }
            if (!updatedQuests.isEmpty()) {
                EditorNotification.warning("Quest ID changed: " + updatedQuests.size() + " quest(s) updated");
                this.statusBar.setWarning("Updating " + updatedQuests.size() + " dependent quest(s)", null);
                for (Quest updatedQuest : updatedQuests) {
                    try {
                        JsonObject json = updatedQuest.toJson();
                        String payload = GSON.toJson((JsonElement)json);
                        NetworkManager.sendToServer(new QuestUpdateRequestPacket(updatedQuest.getId(), payload));
                    }
                    catch (Exception e) {
                        this.statusBar.setError("Failed to update dependent quest: " + updatedQuest.getId(), null);
                    }
                }
            }
        }
        HashMap<String, Quest> allQuests = new HashMap<String, Quest>();
        for (Quest q : ClientQuestManager.getInstance().getAllQuests()) {
            allQuests.put(q.getId(), q);
        }
        allQuests.put(quest.getId(), quest);
        if (this.fieldValidation != null && this.fieldValidation.hasAnyErrors()) {
            Map<String, String> fieldErrors = this.fieldValidation.getAllErrors();
            ArrayList<String> errorMessages = new ArrayList<String>();
            for (Map.Entry<String, String> entry : fieldErrors.entrySet()) {
                errorMessages.add(entry.getKey() + ": " + entry.getValue());
            }
            this.statusBar.setError("Field validation failed: " + fieldErrors.size() + " error(s)", errorMessages);
            EditorNotification.error("Cannot save: invalid field values");
            return;
        }
        QuestValidator.ValidationResult validation = QuestValidator.validate(quest, allQuests);
        if (!validation.isValid()) {
            this.statusBar.setError("Validation failed: " + validation.getErrors().size() + " error(s)", validation.getErrors());
            EditorNotification.error("Cannot save quest: validation errors found");
            return;
        }
        try {
            JsonObject json = quest.toJson();
            String payload = GSON.toJson((JsonElement)json);
            if (oldId == null || oldId.isEmpty()) {
                NetworkManager.sendToServer(new QuestCreateRequestPacket(payload));
            } else if (idChanged) {
                NetworkManager.sendToServer(new QuestUpdateRequestPacket(oldId, payload));
                EditorNotification.success("Quest ID renamed: " + oldId + " \u2192 " + newId);
            } else {
                NetworkManager.sendToServer(new QuestUpdateRequestPacket(oldId, payload));
            }
            this.statusBar.setSuccess("Quest saved successfully: " + quest.getId());
            if (!idChanged) {
                EditorNotification.success("Quest saved: " + (quest.getTitle() != null ? quest.getTitle() : quest.getId()));
            }
            this.originalId = quest.getId();
            this.stateManager.markClean();
            this.unsavedCache.remove(quest.getId());
        }
        catch (Exception e) {
            ArrayList<String> errorDetails = new ArrayList<String>();
            errorDetails.add(e.getMessage());
            if (e.getCause() != null) {
                errorDetails.add("Cause: " + e.getCause().getMessage());
            }
            this.statusBar.setError("Save failed: " + e.getMessage(), errorDetails);
            EditorNotification.error("Save failed: " + e.getMessage());
        }
    }

    @Override
    public void autoSaveEntity(Quest quest) {
        if (quest == null || !this.stateManager.hasUnsavedChanges()) {
            return;
        }
        this.unsavedCache.put(quest.getId(), quest, this.getEntityDisplayName(quest));
    }

    @Override
    public String getEntityDisplayName(Quest quest) {
        if (quest == null) {
            return "Unknown Quest";
        }
        String title = quest.getTitle();
        return title == null || title.isEmpty() ? quest.getId() : title;
    }

    @Override
    public void onAutoSaveSuccess() {
    }

    @Override
    public void onAutoSaveFailure(Exception e) {
        System.err.println("[QuestEditor] Auto-save failed: " + e.getMessage());
    }

    private Quest cloneQuest(Quest quest) {
        if (quest == null) {
            return null;
        }
        try {
            JsonObject json = quest.toJson();
            String jsonStr = GSON.toJson((JsonElement)json);
            JsonObject clonedJson = (JsonObject)GSON.fromJson(jsonStr, JsonObject.class);
            return Quest.fromJson(clonedJson);
        }
        catch (Exception e) {
            System.err.println("[QuestEditor] Failed to clone quest: " + e.getMessage());
            return quest;
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        UiScaleUtil.warnIfEditorScaleNotOne(this, "quest_editor");
        this.autoSaveManager.register(this.getEditorId(), () -> {
            if (this.stateManager.isLoaded() && this.stateManager.hasUnsavedChanges()) {
                this.autoSaveEntity(this.stateManager.getWorkingCopy());
            }
        });
        this.searchBox = new EditBox(this.f_96547_, 8, 8, 224, 18, (Component)Component.m_237113_((String)"Search"));
        this.searchBox.m_257771_((Component)Component.m_237113_((String)"Search: !not, term1|term2, wild*, /regex/,  field:value, #tag"));
        this.searchBox.m_94151_(s -> {
            this.listScroll = 0;
            this.lastSearchQueryCache = null;
        });
        this.m_142416_((GuiEventListener)this.searchBox);
        int tabX = 248;
        int tabY = 8;
        int tabW = 90;
        this.tabGeneralBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"General"), b -> this.switchTab(Tab.GENERAL)).m_252987_(tabX, tabY, tabW, 22).m_253136_());
        this.tabDepsBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Dependencies"), b -> this.switchTab(Tab.DEPENDENCIES)).m_252987_(tabX += tabW + 2, tabY, tabW + 20, 22).m_253136_());
        this.tabReqsBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Requirements"), b -> this.switchTab(Tab.REQUIREMENTS)).m_252987_(tabX += tabW + 22, tabY, tabW + 20, 22).m_253136_());
        this.tabRwdsBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Rewards"), b -> this.switchTab(Tab.REWARDS)).m_252987_(tabX += tabW + 22, tabY, tabW, 22).m_253136_());
        this.tabTeamBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Team"), b -> this.switchTab(Tab.TEAM)).m_252987_(tabX += tabW + 2, tabY, 60, 22).m_253136_());
        this.tabAdvBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Advanced"), b -> this.switchTab(Tab.ADVANCED)).m_252987_(tabX += 62, tabY, tabW, 22).m_253136_());
        this.tabPreviewBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Preview"), b -> this.switchTab(Tab.PREVIEW)).m_252987_(tabX += tabW + 2, tabY, tabW - 10, 22).m_253136_());
        int footerY = this.f_96544_ - 36 + 8;
        int btnX = 248;
        this.newBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"New"), b -> this.createNew()).m_252987_(btnX, footerY, 60, 20).m_253136_());
        this.saveBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Save"), b -> this.save()).m_252987_(btnX += 64, footerY, 60, 20).m_253136_());
        this.saveAllBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Save All"), b -> this.saveAll()).m_252987_(btnX += 64, footerY, 70, 20).m_253136_());
        this.deleteBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Delete"), b -> this.onDeleteClick()).m_252987_(btnX += 74, footerY, 60, 20).m_253136_());
        this.settingsBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u2699"), b -> this.openSettings()).m_252987_(btnX += 64, footerY, 20, 20).m_253136_());
        int closeX = this.f_96543_ - 8 - 60;
        this.closeBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Close"), b -> this.m_7379_()).m_252987_(closeX, footerY, 60, 20).m_253136_());
        int statusY = this.f_96544_ - 36 - 30;
        int statusX = 248;
        int statusW = this.f_96543_ - statusX - 8;
        this.statusBar = new EditorStatusBar(statusX, statusY, statusW);
        this.fieldValidation = new FieldValidation();
        this.setupValidationRules();
        this.m_7522_(null);
        this.updateSaveAllButton();
        System.out.println("[QuestEditor] About to initialize tab panels. Current workingQuest rewards: " + String.valueOf(this.workingQuest != null ? Integer.valueOf(this.workingQuest.getRewards().size()) : "null"));
        this.initTabPanels();
        this.reloadQuestList();
        if (this.workingQuest != null && this.stateManager.isLoaded()) {
            this.loadTabFromQuest();
        } else if (this.workingQuest != null) {
            this.stateManager.load(this.workingQuest);
            this.originalId = this.workingQuest.getId();
            this.loadTabFromQuest();
        } else if (!this.filtered.isEmpty()) {
            this.selectQuest(this.filtered.get(0));
        } else {
            this.createNew();
        }
    }

    private void initTabPanels() {
        int contentX = 248;
        int contentY = 40;
        int contentW = this.f_96543_ - contentX - 8;
        int contentH = this.f_96544_ - contentY - 36 - 8;
        System.out.println("[QuestEditor] initTabPanels() - Creating NEW tab panel instances!");
        this.generalTab = new GeneralTabPanel(this, contentX, contentY, contentW, contentH);
        this.dependenciesTab = new DependenciesTabPanel(this, contentX, contentY, contentW, contentH);
        this.requirementsTab = new RequirementsTabPanel(this, contentX, contentY, contentW, contentH);
        this.rewardsTab = new RewardsTabPanel(this, contentX, contentY, contentW, contentH);
        this.teamTab = new TeamTabPanel(this, contentX, contentY, contentW, contentH);
        this.advancedTab = new AdvancedTabPanel(this, contentX, contentY, contentW, contentH);
        this.previewTab = new PreviewTabPanel(this, contentX, contentY, contentW, contentH);
    }

    private void switchTab(Tab tab) {
        if (this.activeTab == tab) {
            return;
        }
        System.out.println("[QuestEditor] switchTab() from " + String.valueOf((Object)this.activeTab) + " to " + String.valueOf((Object)tab));
        this.saveCurrentTabToQuest();
        this.activeTab = tab;
        this.loadTabFromQuest();
    }

    public void saveCurrentTabToQuest() {
        if (this.workingQuest == null || !this.stateManager.isLoaded()) {
            return;
        }
        this.updateQuest(q -> {
            switch (this.activeTab.ordinal()) {
                case 0: {
                    this.generalTab.saveToQuest((Quest)q);
                    break;
                }
                case 1: {
                    this.dependenciesTab.saveToQuest((Quest)q);
                    break;
                }
                case 2: {
                    this.requirementsTab.saveToQuest((Quest)q);
                    break;
                }
                case 3: {
                    this.rewardsTab.saveToQuest((Quest)q);
                    break;
                }
                case 4: {
                    this.teamTab.saveToQuest((Quest)q);
                    break;
                }
                case 5: {
                    this.advancedTab.saveToQuest((Quest)q);
                }
            }
        });
    }

    private void copyQuestData(Quest from, Quest to) {
        to.setTitle(from.getTitle());
        to.setDescription(from.getDescription());
        to.setIcon(from.getIcon());
        to.setHidden(from.isHidden());
        to.setGroup(from.getGroup());
        to.setChapterId(from.getChapterId());
        to.setX(from.getX());
        to.setY(from.getY());
        to.setHideDependencyLines(from.isHideDependencyLines());
        to.setHideDependentLines(from.isHideDependentLines());
        to.setIconScale(from.getIconScale());
        to.setLineStyle(from.getLineStyle());
        to.getDependencies().clear();
        to.getDependencies().addAll(from.getDependencies());
        to.getRequirements().clear();
        to.getRequirements().addAll(from.getRequirements());
        to.getRewards().clear();
        to.getRewards().addAll(from.getRewards());
        to.getTags().clear();
        to.getTags().addAll(from.getTags());
        to.setShape(from.getShape());
        to.setSize(from.getSize());
        to.setOptional(from.isOptional());
        to.setMinWidth(from.getMinWidth());
        to.setCanRepeat(from.getCanRepeat());
        to.setDependencyRequirement(from.getDependencyRequirement());
        to.setMinRequiredDependencies(from.getMinRequiredDependencies());
        to.setMaxCompletableDeps(from.getMaxCompletableDeps());
        to.setProgressionMode(from.getProgressionMode());
        to.setRequireSequentialTasks(from.getRequireSequentialTasks());
        to.setInvisibleUntilCompleted(from.isInvisibleUntilCompleted());
        to.setInvisibleUntilTasks(from.getInvisibleUntilTasks());
        to.setHideTextUntilComplete(from.getHideTextUntilComplete());
        to.setHideDetailsUntilStartable(from.getHideDetailsUntilStartable());
        to.setHideUntilDepsVisible(from.getHideUntilDepsVisible());
        to.setHideUntilDepsComplete(from.getHideUntilDepsComplete());
        to.setDisableJEI(from.getDisableJEI());
        to.setHideLockIcon(from.isHideLockIcon());
        to.setGuidePage(from.getGuidePage());
        to.setIgnoreRewardBlocking(from.isIgnoreRewardBlocking());
    }

    private void loadTabFromQuest() {
        if (this.workingQuest == null) {
            System.out.println("[QuestEditor] loadTabFromQuest() - workingQuest is NULL!");
            return;
        }
        System.out.println("[QuestEditor] loadTabFromQuest() called for tab: " + String.valueOf((Object)this.activeTab) + ", Quest: " + this.workingQuest.getId() + " / " + this.workingQuest.getTitle() + ", Rewards: " + this.workingQuest.getRewards().size());
        switch (this.activeTab.ordinal()) {
            case 0: {
                this.generalTab.loadFromQuest(this.workingQuest);
                break;
            }
            case 1: {
                this.dependenciesTab.loadFromQuest(this.workingQuest);
                break;
            }
            case 2: {
                this.requirementsTab.loadFromQuest(this.workingQuest);
                break;
            }
            case 3: {
                this.rewardsTab.loadFromQuest(this.workingQuest);
                break;
            }
            case 4: {
                this.teamTab.loadFromQuest(this.workingQuest);
                break;
            }
            case 5: {
                this.advancedTab.loadFromQuest(this.workingQuest);
                break;
            }
            case 6: {
                this.previewTab.loadFromQuest(this.workingQuest);
            }
        }
    }

    private void reloadQuestList() {
        boolean showHidden;
        String raw = this.searchBox.m_94155_();
        String query = raw == null ? "" : raw.trim().toLowerCase();
        List<Quest> all = new ArrayList<Quest>(ClientQuestManager.getInstance().getAllQuests());
        boolean bl = showHidden = query.contains("is:hidden") || query.contains("is:invisible");
        if (!showHidden) {
            all = all.stream().filter(q -> !q.isHidden()).collect(Collectors.toList());
        }
        all.sort((a, b) -> a.getTitle().compareToIgnoreCase(b.getTitle()));
        if (query.isEmpty()) {
            this.filtered = all;
            return;
        }
        HashMap<String, String> chapterIdToTitle = new HashMap<String, String>();
        for (ChapterData cd : ClientQuestManager.getInstance().getAllChapters()) {
            if (cd == null || cd.getId() == null) continue;
            chapterIdToTitle.put(cd.getId().toLowerCase(), cd.getTitle() == null ? "" : cd.getTitle());
        }
        if (!query.equals(this.lastSearchQueryCache)) {
            this.cachedSearchFilter = AdvancedSearchFilter.parse(query);
            this.lastSearchQueryCache = query;
        }
        QuestProgress progress = ClientQuestManager.getInstance().getProgress();
        this.filtered = all.stream().filter(q -> this.cachedSearchFilter.matchesQuest((Quest)q, (Map<String, String>)chapterIdToTitle, progress)).collect(Collectors.toList());
    }

    private void selectQuest(Quest quest) {
        Optional<UnsavedChangesCache.CacheEntry<Quest>> cachedEntry;
        this.deleteConfirmPending = false;
        if (this.deleteBtn != null) {
            this.deleteBtn.m_93666_((Component)Component.m_237113_((String)"Delete"));
        }
        if (this.stateManager.isLoaded() && this.stateManager.hasUnsavedChanges()) {
            this.saveCurrentTabToQuest();
            this.unsavedCache.put(this.stateManager.getEntityId(), this.stateManager.getWorkingCopy(), this.stateManager.getChangedFields(), this.getEntityDisplayName(this.stateManager.getWorkingCopy()));
        }
        if ((cachedEntry = this.unsavedCache.get(quest.getId())).isPresent()) {
            this.workingQuest = cachedEntry.get().getEntity();
            this.stateManager.load(this.workingQuest);
            this.stateManager.markDirty();
        } else {
            this.workingQuest = this.cloneQuest(quest);
            this.stateManager.load(this.workingQuest);
        }
        this.originalId = quest.getId();
        this.loadTabFromQuest();
        this.updateSaveAllButton();
    }

    private void createNew() {
        Quest newQuest;
        this.deleteConfirmPending = false;
        if (this.deleteBtn != null) {
            this.deleteBtn.m_93666_((Component)Component.m_237113_((String)"Delete"));
        }
        if (this.stateManager.isLoaded() && this.stateManager.hasUnsavedChanges()) {
            this.saveCurrentTabToQuest();
            this.unsavedCache.put(this.stateManager.getEntityId(), this.stateManager.getWorkingCopy(), this.stateManager.getChangedFields(), this.getEntityDisplayName(this.stateManager.getWorkingCopy()));
        }
        this.workingQuest = newQuest = new Quest("new_quest_" + System.currentTimeMillis(), "New Quest", "");
        this.stateManager.load(newQuest);
        this.stateManager.markDirty();
        this.originalId = null;
        this.activeTab = Tab.GENERAL;
        this.loadTabFromQuest();
        this.updateSaveAllButton();
        this.m_7522_(null);
    }

    private void updateSaveAllButton() {
        if (this.saveAllBtn != null) {
            int unsavedCount = this.unsavedCache.size();
            if (this.stateManager.isLoaded() && this.stateManager.hasUnsavedChanges() && !this.unsavedCache.contains(this.stateManager.getEntityId())) {
                ++unsavedCount;
            }
            boolean bl = this.saveAllBtn.f_93623_ = unsavedCount > 0;
            if (unsavedCount > 0) {
                this.saveAllBtn.m_93666_((Component)Component.m_237113_((String)("Save All (" + unsavedCount + ")")));
            } else {
                this.saveAllBtn.m_93666_((Component)Component.m_237113_((String)"Save All"));
            }
        }
    }

    private void saveAll() {
        if (this.unsavedCache.isEmpty() && !this.stateManager.hasUnsavedChanges()) {
            return;
        }
        if (this.stateManager.isLoaded() && this.stateManager.hasUnsavedChanges()) {
            this.saveCurrentTabToQuest();
            this.unsavedCache.put(this.stateManager.getEntityId(), this.stateManager.getWorkingCopy(), this.stateManager.getChangedFields(), this.getEntityDisplayName(this.stateManager.getWorkingCopy()));
        }
        int successCount = 0;
        int failCount = 0;
        for (Map.Entry<String, UnsavedChangesCache.CacheEntry<Quest>> entry : this.unsavedCache.getAllEntries()) {
            String questId = entry.getKey();
            Quest quest = entry.getValue().getEntity();
            try {
                this.saveEntity(quest);
                this.unsavedCache.remove(questId);
                ++successCount;
            }
            catch (Exception e) {
                ++failCount;
                System.err.println("[QuestEditor] Failed to save quest " + questId + ": " + e.getMessage());
            }
        }
        if (failCount == 0) {
            this.statusBar.setSuccess("Successfully saved " + successCount + " quest(s)");
            EditorNotification.success("Saved " + successCount + " quest(s)");
        } else {
            this.statusBar.setWarning("Saved " + successCount + " quest(s), " + failCount + " failed", null);
            EditorNotification.warning("Saved " + successCount + " quest(s), " + failCount + " failed");
        }
        this.updateSaveAllButton();
        this.m_7522_(null);
    }

    private void save() {
        if (this.workingQuest == null || !this.stateManager.isLoaded()) {
            return;
        }
        this.saveCurrentTabToQuest();
        this.saveEntity(this.stateManager.getWorkingCopy());
        this.updateSaveAllButton();
        this.m_7522_(null);
    }

    public void m_7379_() {
        if (this.stateManager.hasUnsavedChanges() || !this.unsavedCache.isEmpty()) {
            this.showCloseConfirmationDialog();
        } else {
            this.autoSaveManager.unregister(this.getEditorId());
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_(this.parent);
            }
        }
    }

    private void showCloseConfirmationDialog() {
        ArrayList<CloseConfirmationDialog.UnsavedEntity> unsavedEntities = new ArrayList<CloseConfirmationDialog.UnsavedEntity>();
        for (Map.Entry<String, UnsavedChangesCache.CacheEntry<Quest>> entry : this.unsavedCache.getAllEntries()) {
            unsavedEntities.add(new CloseConfirmationDialog.UnsavedEntity(entry.getValue().getDisplayName(), "Quest", entry.getValue().getTimestamp()));
        }
        if (this.stateManager.isLoaded() && this.stateManager.hasUnsavedChanges() && !this.unsavedCache.contains(this.stateManager.getEntityId())) {
            unsavedEntities.add(new CloseConfirmationDialog.UnsavedEntity(this.getEntityDisplayName(this.stateManager.getWorkingCopy()), "Quest", this.stateManager.getLastModifiedTime()));
        }
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_((Screen)new CloseConfirmationDialog(this, this.parent, unsavedEntities, this::saveAll, () -> {
                this.unsavedCache.clear();
                this.stateManager.clear();
            }, () -> {}));
        }
    }

    private void onDeleteClick() {
        if (this.originalId == null || this.originalId.isEmpty()) {
            return;
        }
        if (Screen.m_96639_()) {
            this.delete();
            this.statusBar.setSuccess("Quest deleted (Alt+Click quick delete)");
            return;
        }
        if (!this.deleteConfirmPending) {
            this.deleteConfirmPending = true;
            this.deleteConfirmTime = System.currentTimeMillis();
            this.deleteBtn.m_93666_((Component)Component.m_237113_((String)"\u00a7cConfirm?"));
            this.statusBar.setWarning("Click Delete again to confirm deletion (or Alt+Click for quick delete)", null);
            EditorNotification.warning("Click Delete again to confirm");
        } else {
            this.delete();
        }
        this.m_7522_(null);
    }

    private void delete() {
        NetworkManager.sendToServer(new QuestDeleteRequestPacket(this.originalId));
        this.statusBar.setSuccess("Quest deletion requested");
        EditorNotification.info("Quest deletion requested");
        this.deleteConfirmPending = false;
        this.deleteBtn.m_93666_((Component)Component.m_237113_((String)"Delete"));
        if (!this.filtered.isEmpty()) {
            this.selectQuest(this.filtered.get(0));
        } else {
            this.clearEditor();
        }
    }

    private void clearEditor() {
        this.originalId = null;
        this.workingQuest = null;
        this.stateManager.clear();
        this.unsavedCache.clear();
        this.deleteConfirmPending = false;
        if (this.deleteBtn != null) {
            this.deleteBtn.m_93666_((Component)Component.m_237113_((String)"Delete"));
        }
        this.loadTabFromQuest();
        this.updateSaveAllButton();
    }

    private void openSettings() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_((Screen)new EditorSettingsScreen(this));
        }
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(g);
        if (this.deleteConfirmPending && System.currentTimeMillis() - this.deleteConfirmTime > 3000L) {
            this.deleteConfirmPending = false;
            this.deleteBtn.m_93666_((Component)Component.m_237113_((String)"Delete"));
        }
        g.m_280509_(0, 0, 240, this.f_96544_, -804253680);
        int unsavedCount = this.unsavedCache.size();
        if (this.stateManager.isLoaded() && this.stateManager.hasUnsavedChanges() && !this.unsavedCache.contains(this.stateManager.getEntityId())) {
            ++unsavedCount;
        }
        if (unsavedCount > 0) {
            String unsavedText = "(" + unsavedCount + " unsaved)";
            int textX = 10;
            int textY = 36;
            g.m_280488_(this.f_96547_, unsavedText, textX, textY, -22016);
        }
        if (this.autoSaveManager.isEnabled()) {
            String status = this.autoSaveManager.getStatusString();
            int statusW = this.f_96547_.m_92895_(status);
            int statusX = 232 - statusW;
            int statusY = 50;
            g.m_280488_(this.f_96547_, status, statusX, statusY, -7829368);
        }
        int listTop = 32;
        int listBottom = this.f_96544_ - 8;
        g.m_280509_(8, listTop, 232, listBottom, -534765536);
        this.renderQuestList(g, mouseX, mouseY);
        this.updateSaveAllButton();
        int contentX = 248;
        int contentY = 40;
        int contentW = this.f_96543_ - contentX - 8;
        int contentH = this.f_96544_ - contentY - 36 - 8;
        g.m_280509_(contentX, contentY, contentX + contentW, contentY + contentH, -535291880);
        this.renderActiveTab(g, mouseX, mouseY, partialTick);
        super.m_88315_(g, mouseX, mouseY, partialTick);
        if (this.statusBar != null) {
            this.statusBar.render(g, this.f_96547_, mouseX, mouseY);
        }
        EditorNotification.render(g, this.f_96543_, this.f_96544_);
        g.m_280430_(this.f_96547_, this.f_96539_, 248, -4, -1);
        int sbX = 8;
        int sbY = 8;
        int sbW = 224;
        int sbH = 18;
        if (mouseX >= sbX && mouseX <= sbX + sbW && mouseY >= sbY && mouseY <= sbY + sbH) {
            String[] lines = new String[]{"Search tips:", "id:, title:, group:, chapter:", "tag:<t> or #<t>", "is:completed|incomplete|visible|hidden|optional|required", "use \"phrases\""};
            int tw = 0;
            for (String s : lines) {
                tw = Math.max(tw, this.f_96547_.m_92895_(s));
            }
            int th = 6 + lines.length * 10 + 4;
            int tx = sbX + sbW + 8;
            int ty = sbY;
            if (tx + tw + 10 > this.f_96543_) {
                tx = Math.max(8, this.f_96543_ - tw - 12);
            }
            if (ty + th > this.f_96544_) {
                ty = Math.max(8, this.f_96544_ - th - 4);
            }
            g.m_280168_().m_85836_();
            g.m_280168_().m_252880_(0.0f, 0.0f, 400.0f);
            g.m_280509_(tx - 2, ty - 2, tx + tw + 8, ty + th, -268435456);
            g.m_280509_(tx - 2, ty - 2, tx + tw + 8, ty - 1, -11890462);
            int yy = ty + 2;
            for (String s : lines) {
                g.m_280488_(this.f_96547_, s, tx + 2, yy, -1);
                yy += 10;
            }
            g.m_280168_().m_85849_();
        }
    }

    private void renderQuestList(GuiGraphics g, int mouseX, int mouseY) {
        this.reloadQuestList();
        int listX = 8;
        int listTop = 32;
        int listW = 224;
        int listBottom = this.f_96544_ - 8;
        int lineH = 16;
        g.m_280588_(listX, listTop, listX + listW, listBottom);
        int maxLines = Math.max(1, (listBottom - listTop) / lineH);
        this.listScroll = Math.max(0, Math.min(this.listScroll, Math.max(0, this.filtered.size() - maxLines)));
        for (int i = 0; i < Math.min(maxLines, this.filtered.size() - this.listScroll); ++i) {
            boolean hasUnsavedChanges;
            Quest q = this.filtered.get(this.listScroll + i);
            int y = listTop + 2 + i * lineH;
            boolean selected = this.workingQuest != null && this.workingQuest.getId().equals(q.getId());
            boolean hover = mouseX >= listX && mouseX <= listX + listW && mouseY >= y && mouseY < y + lineH;
            boolean bl = hasUnsavedChanges = this.unsavedCache.contains(q.getId()) || selected && this.stateManager.hasUnsavedChanges();
            if (selected) {
                g.m_280509_(listX, y - 1, listX + listW, y + lineH - 1, -12952966);
            } else if (hover) {
                g.m_280509_(listX, y - 1, listX + listW, y + lineH - 1, -14013910);
            }
            String title = q.getTitle();
            Component formattedTitle = TextFormatter.parse(title);
            Object label = hasUnsavedChanges ? Component.m_237113_((String)"* ").m_130938_(style -> style.m_178520_(-22016)).m_7220_(formattedTitle) : formattedTitle;
            int maxWidth = listW - 4;
            if (this.f_96547_.m_92852_((FormattedText)label) > maxWidth) {
                String plainText = label.getString();
                String truncated = this.f_96547_.m_92834_(plainText, listW - 16) + "...";
                label = Component.m_237113_((String)truncated);
                if (hasUnsavedChanges) {
                    label = label.m_6881_().m_130938_(style -> style.m_178520_(-22016));
                }
            }
            g.m_280430_(this.f_96547_, label, listX + 2, y, -1);
        }
        g.m_280618_();
    }

    private void renderActiveTab(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        switch (this.activeTab.ordinal()) {
            case 0: {
                this.generalTab.render(g, mouseX, mouseY, partialTick);
                break;
            }
            case 1: {
                this.dependenciesTab.render(g, mouseX, mouseY, partialTick);
                break;
            }
            case 2: {
                this.requirementsTab.render(g, mouseX, mouseY, partialTick);
                break;
            }
            case 3: {
                this.rewardsTab.render(g, mouseX, mouseY, partialTick);
                break;
            }
            case 4: {
                this.teamTab.render(g, mouseX, mouseY, partialTick);
                break;
            }
            case 5: {
                this.advancedTab.render(g, mouseX, mouseY, partialTick);
                break;
            }
            case 6: {
                this.previewTab.render(g, mouseX, mouseY, partialTick);
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int relY;
        int index;
        boolean tabHandled;
        if (super.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        switch (this.activeTab.ordinal()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 0: {
                boolean bl = this.generalTab.mouseClicked(mouseX, mouseY, button);
                break;
            }
            case 1: {
                boolean bl = this.dependenciesTab.mouseClicked(mouseX, mouseY, button);
                break;
            }
            case 2: {
                boolean bl = this.requirementsTab.mouseClicked(mouseX, mouseY, button);
                break;
            }
            case 3: {
                boolean bl = this.rewardsTab.mouseClicked(mouseX, mouseY, button);
                break;
            }
            case 4: {
                boolean bl = this.teamTab.mouseClicked(mouseX, mouseY, button);
                break;
            }
            case 5: {
                boolean bl = this.advancedTab.mouseClicked(mouseX, mouseY, button);
                break;
            }
            case 6: {
                boolean bl = tabHandled = this.previewTab.mouseClicked(mouseX, mouseY, button);
            }
        }
        if (tabHandled) {
            this.searchBox.m_93692_(false);
            this.m_7522_(null);
            return true;
        }
        if (this.statusBar != null && this.statusBar.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        int listX = 8;
        int listTop = 32;
        int listW = 224;
        int listBottom = this.f_96544_ - 8;
        int lineH = 16;
        if (mouseX >= (double)listX && mouseX <= (double)(listX + listW) && mouseY >= (double)listTop && mouseY < (double)listBottom && (index = this.listScroll + (relY = (int)mouseY - listTop - 2) / lineH) >= 0 && index < this.filtered.size()) {
            this.selectQuest(this.filtered.get(index));
            return true;
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        boolean tabHandled;
        int listX = 8;
        int listTop = 32;
        int listW = 224;
        int listBottom = this.f_96544_ - 8;
        if (mouseX >= (double)listX && mouseX <= (double)(listX + listW) && mouseY >= (double)listTop && mouseY < (double)listBottom) {
            this.listScroll = (int)Math.max(0.0, (double)this.listScroll - Math.signum(delta) * 3.0);
            return true;
        }
        switch (this.activeTab.ordinal()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 0: {
                boolean bl = this.generalTab.mouseScrolled(mouseX, mouseY, delta);
                break;
            }
            case 1: {
                boolean bl = this.dependenciesTab.mouseScrolled(mouseX, mouseY, delta);
                break;
            }
            case 2: {
                boolean bl = this.requirementsTab.mouseScrolled(mouseX, mouseY, delta);
                break;
            }
            case 3: {
                boolean bl = this.rewardsTab.mouseScrolled(mouseX, mouseY, delta);
                break;
            }
            case 4: {
                boolean bl = this.teamTab.mouseScrolled(mouseX, mouseY, delta);
                break;
            }
            case 5: {
                boolean bl = this.advancedTab.mouseScrolled(mouseX, mouseY, delta);
                break;
            }
            case 6: {
                boolean bl = tabHandled = this.previewTab.mouseScrolled(mouseX, mouseY, delta);
            }
        }
        if (tabHandled) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean tabHandled;
        if (keyCode == 256) {
            EditorNotification.clear();
            if (this.statusBar != null) {
                this.statusBar.clear();
            }
        }
        if (keyCode == 257) {
            boolean anyFieldFocused;
            if (this.searchBox != null && this.searchBox.m_93696_()) {
                return this.searchBox.m_7933_(keyCode, scanCode, modifiers);
            }
            switch (this.activeTab.ordinal()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case 0: {
                    boolean bl = this.generalTab.getFields().stream().anyMatch(f -> f.m_93696_());
                    break;
                }
                case 1: {
                    boolean bl = this.dependenciesTab.getFields().stream().anyMatch(f -> f.m_93696_());
                    break;
                }
                case 2: {
                    boolean bl = this.requirementsTab.getFields().stream().anyMatch(f -> f.m_93696_());
                    break;
                }
                case 3: {
                    boolean bl = this.rewardsTab.getFields().stream().anyMatch(f -> f.m_93696_());
                    break;
                }
                case 4: {
                    boolean bl = this.teamTab.getFields().stream().anyMatch(f -> f.m_93696_());
                    break;
                }
                case 5: {
                    boolean bl = this.advancedTab.getFields().stream().anyMatch(f -> f.m_93696_());
                    break;
                }
                case 6: {
                    boolean bl = anyFieldFocused = false;
                }
            }
            if (anyFieldFocused) {
                return true;
            }
            this.m_7522_(null);
            return true;
        }
        if (ClientInputHelper.isSave(keyCode, scanCode)) {
            this.save();
            return true;
        }
        if (ClientInputHelper.isNew(keyCode, scanCode)) {
            this.createNew();
            return true;
        }
        if (ClientInputHelper.isDelete(keyCode, scanCode)) {
            this.delete();
            return true;
        }
        if (ClientInputHelper.isSearch(keyCode, scanCode)) {
            this.searchBox.m_93692_(true);
            return true;
        }
        if (ClientInputHelper.isUndo(keyCode, scanCode)) {
            this.saveCurrentTabToQuest();
            if (this.stateManager.undo()) {
                this.workingQuest = this.stateManager.getWorkingCopy();
                this.loadTabFromQuest();
                EditorNotification.success("Undo");
            }
            return true;
        }
        if (ClientInputHelper.isRedo(keyCode, scanCode)) {
            if (this.stateManager.redo()) {
                this.workingQuest = this.stateManager.getWorkingCopy();
                this.loadTabFromQuest();
                EditorNotification.success("Redo");
            }
            return true;
        }
        if (keyCode == 32) {
            boolean anyFieldFocused;
            if (this.searchBox != null && this.searchBox.m_93696_()) {
                return this.searchBox.m_7933_(keyCode, scanCode, modifiers);
            }
            switch (this.activeTab.ordinal()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case 0: {
                    boolean bl = this.generalTab.getFields().stream().anyMatch(f -> f.m_93696_());
                    break;
                }
                case 1: {
                    boolean bl = this.dependenciesTab.getFields().stream().anyMatch(f -> f.m_93696_());
                    break;
                }
                case 2: {
                    boolean bl = this.requirementsTab.getFields().stream().anyMatch(f -> f.m_93696_());
                    break;
                }
                case 3: {
                    boolean bl = this.rewardsTab.getFields().stream().anyMatch(f -> f.m_93696_());
                    break;
                }
                case 4: {
                    boolean bl = this.teamTab.getFields().stream().anyMatch(f -> f.m_93696_());
                    break;
                }
                case 5: {
                    boolean bl = this.advancedTab.getFields().stream().anyMatch(f -> f.m_93696_());
                    break;
                }
                case 6: {
                    boolean bl = anyFieldFocused = false;
                }
            }
            if (anyFieldFocused) {
                for (EditBox editBox : switch (this.activeTab.ordinal()) {
                    default -> throw new IncompatibleClassChangeError();
                    case 0 -> this.generalTab.getFields();
                    case 1 -> this.dependenciesTab.getFields();
                    case 2 -> this.requirementsTab.getFields();
                    case 3 -> this.rewardsTab.getFields();
                    case 4 -> this.teamTab.getFields();
                    case 5 -> this.advancedTab.getFields();
                    case 6 -> new ArrayList();
                }) {
                    if (!editBox.m_93696_()) continue;
                    return editBox.m_7933_(keyCode, scanCode, modifiers);
                }
            }
            this.m_7522_((GuiEventListener)this.searchBox);
            return super.m_7933_(keyCode, scanCode, modifiers);
        }
        block27 : switch (this.activeTab.ordinal()) {
            case 0: {
                boolean bl;
                for (EditBox editBox : this.generalTab.getFields()) {
                    if (!editBox.m_7933_(keyCode, scanCode, modifiers)) continue;
                    bl = true;
                    break block27;
                }
                bl = false;
                break;
            }
            case 1: {
                boolean bl;
                for (EditBox editBox : this.dependenciesTab.getFields()) {
                    if (!editBox.m_7933_(keyCode, scanCode, modifiers)) continue;
                    bl = true;
                    break block27;
                }
                bl = false;
                break;
            }
            case 2: {
                boolean bl;
                for (EditBox editBox : this.requirementsTab.getFields()) {
                    if (!editBox.m_7933_(keyCode, scanCode, modifiers)) continue;
                    bl = true;
                    break block27;
                }
                bl = false;
                break;
            }
            case 3: {
                boolean bl;
                for (EditBox editBox : this.rewardsTab.getFields()) {
                    if (!editBox.m_7933_(keyCode, scanCode, modifiers)) continue;
                    bl = true;
                    break block27;
                }
                bl = false;
                break;
            }
            case 5: {
                boolean bl;
                for (EditBox editBox : this.advancedTab.getFields()) {
                    if (!editBox.m_7933_(keyCode, scanCode, modifiers)) continue;
                    bl = true;
                    break block27;
                }
                bl = false;
                break;
            }
            default: {
                boolean bl = tabHandled = false;
            }
        }
        if (tabHandled) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char chr, int modifiers) {
        boolean tabHandled;
        block0 : switch (this.activeTab.ordinal()) {
            case 0: {
                boolean bl;
                for (EditBox field : this.generalTab.getFields()) {
                    if (!field.m_5534_(chr, modifiers)) continue;
                    bl = true;
                    break block0;
                }
                bl = false;
                break;
            }
            case 1: {
                boolean bl;
                for (EditBox field : this.dependenciesTab.getFields()) {
                    if (!field.m_5534_(chr, modifiers)) continue;
                    bl = true;
                    break block0;
                }
                bl = false;
                break;
            }
            case 2: {
                boolean bl;
                for (EditBox field : this.requirementsTab.getFields()) {
                    if (!field.m_5534_(chr, modifiers)) continue;
                    bl = true;
                    break block0;
                }
                bl = false;
                break;
            }
            case 3: {
                boolean bl;
                for (EditBox field : this.rewardsTab.getFields()) {
                    if (!field.m_5534_(chr, modifiers)) continue;
                    bl = true;
                    break block0;
                }
                bl = false;
                break;
            }
            case 5: {
                boolean bl;
                for (EditBox field : this.advancedTab.getFields()) {
                    if (!field.m_5534_(chr, modifiers)) continue;
                    bl = true;
                    break block0;
                }
                bl = false;
                break;
            }
            default: {
                boolean bl = tabHandled = false;
            }
        }
        if (tabHandled) {
            return true;
        }
        return super.m_5534_(chr, modifiers);
    }

    public void updateQuest(Consumer<Quest> action) {
        if (this.workingQuest != null) {
            Quest temp = this.cloneQuest(this.workingQuest);
            if (temp == null) {
                return;
            }
            action.accept(temp);
            JsonObject oldState = this.workingQuest.toJson();
            JsonObject newState = temp.toJson();
            if (!oldState.equals((Object)newState)) {
                this.stateManager.setWorkingCopy(temp);
                this.workingQuest = this.stateManager.getWorkingCopy();
            }
        }
    }

    public boolean m_7043_() {
        return false;
    }

    private static enum Tab {
        GENERAL,
        DEPENDENCIES,
        REQUIREMENTS,
        REWARDS,
        TEAM,
        ADVANCED,
        PREVIEW;

    }
}

