/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.questory.client.ClientTeamManager;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.network.TeamActionPacket;
import org.texboobcat.questory.team.TeamInviteInfo;

public class TeamJoinScreen
extends Screen {
    private static final int WINDOW_WIDTH = 260;
    private static final int WINDOW_HEIGHT = 220;
    private final Screen parent;
    private int leftPos;
    private int topPos;
    private List<InviteEntry> inviteEntries = new ArrayList<InviteEntry>();
    private int scrollOffset = 0;
    private static final int MAX_VISIBLE_INVITES = 6;
    private Button closeButton;

    public TeamJoinScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"Join Team"));
        this.parent = parent;
    }

    protected void m_7856_() {
        this.leftPos = (this.f_96543_ - 260) / 2;
        this.topPos = (this.f_96544_ - 220) / 2;
        this.closeButton = Button.m_253074_((Component)Component.m_237113_((String)"Close"), btn -> this.m_7379_()).m_252987_(this.leftPos + 260 - 70, this.topPos + 5, 65, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.closeButton);
        this.buildInviteEntries();
    }

    private void buildInviteEntries() {
        this.inviteEntries.clear();
        ClientTeamManager clientMgr = ClientTeamManager.getInstance();
        List<TeamInviteInfo> pendingInvites = clientMgr.getPendingInvites();
        if (pendingInvites.isEmpty()) {
            return;
        }
        for (TeamInviteInfo inviteInfo : pendingInvites) {
            InviteEntry entry = new InviteEntry(inviteInfo);
            int entryY = this.topPos + 35 + this.inviteEntries.size() * 40 - this.scrollOffset * 40;
            entry.acceptButton = Button.m_253074_((Component)Component.m_237113_((String)"Accept"), btn -> this.acceptInvite(inviteInfo.getTeamId())).m_252987_(this.leftPos + 10, entryY + 20, 55, 18).m_253136_();
            entry.declineButton = Button.m_253074_((Component)Component.m_237113_((String)"Decline"), btn -> this.declineInvite(inviteInfo.getTeamId())).m_252987_(this.leftPos + 70, entryY + 20, 55, 18).m_253136_();
            this.inviteEntries.add(entry);
        }
        for (InviteEntry entry : this.inviteEntries) {
            this.m_142416_((GuiEventListener)entry.acceptButton);
            this.m_142416_((GuiEventListener)entry.declineButton);
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        graphics.m_280509_(this.leftPos, this.topPos, this.leftPos + 260, this.topPos + 220, -872415232);
        graphics.m_280509_(this.leftPos, this.topPos, this.leftPos + 260, this.topPos + 28, -14540254);
        graphics.m_280488_(this.f_96547_, "Join Team - Pending Invites", this.leftPos + 5, this.topPos + 10, 0xFFFFFF);
        if (this.inviteEntries.isEmpty()) {
            graphics.m_280488_(this.f_96547_, "\u00a77No pending team invites", this.leftPos + 10, this.topPos + 50, 0x888888);
            graphics.m_280488_(this.f_96547_, "\u00a77Teams can invite you to join", this.leftPos + 10, this.topPos + 65, 0x888888);
            graphics.m_280488_(this.f_96547_, "\u00a77them. Check back later!", this.leftPos + 10, this.topPos + 80, 0x888888);
        } else {
            int i;
            int entryY = this.topPos + 35;
            int visibleCount = 0;
            for (i = this.scrollOffset; i < this.inviteEntries.size() && visibleCount < 6; ++visibleCount, ++i) {
                InviteEntry entry = this.inviteEntries.get(i);
                if (visibleCount > 0) {
                    graphics.m_280509_(this.leftPos + 10, entryY - 2, this.leftPos + 260 - 10, entryY - 1, 0x44FFFFFF);
                }
                graphics.m_280488_(this.f_96547_, "\u00a7e" + entry.inviteInfo.getTeamName(), this.leftPos + 10, entryY + 3, 0xFFFFFF);
                graphics.m_280488_(this.f_96547_, "\u00a77Owner: \u00a7f" + entry.inviteInfo.getOwnerName(), this.leftPos + 10, entryY + 13, 0x888888);
                graphics.m_280488_(this.f_96547_, "\u00a77Members: \u00a7f" + entry.inviteInfo.getMemberCount(), this.leftPos + 140, entryY + 13, 0x888888);
                entry.acceptButton.m_253211_(entryY + 20);
                entry.declineButton.m_253211_(entryY + 20);
                entry.acceptButton.f_93624_ = true;
                entry.declineButton.f_93624_ = true;
                entryY += 43;
            }
            for (i = 0; i < this.inviteEntries.size(); ++i) {
                if (i >= this.scrollOffset && i < this.scrollOffset + 6) continue;
                this.inviteEntries.get((int)i).acceptButton.f_93624_ = false;
                this.inviteEntries.get((int)i).declineButton.f_93624_ = false;
            }
            if (this.inviteEntries.size() > 6) {
                String scrollHint = "(" + (this.scrollOffset + 1) + "-" + Math.min(this.scrollOffset + 6, this.inviteEntries.size()) + " of " + this.inviteEntries.size() + ")";
                graphics.m_280488_(this.f_96547_, "\u00a77" + scrollHint, this.leftPos + 10, this.topPos + 220 - 15, 0x888888);
            }
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollDelta) {
        if (this.inviteEntries.size() > 6) {
            if (scrollDelta > 0.0 && this.scrollOffset > 0) {
                --this.scrollOffset;
                this.m_169413_();
                this.m_7856_();
                return true;
            }
            if (scrollDelta < 0.0 && this.scrollOffset < this.inviteEntries.size() - 6) {
                ++this.scrollOffset;
                this.m_169413_();
                this.m_7856_();
                return true;
            }
        }
        return super.m_6050_(mouseX, mouseY, scrollDelta);
    }

    private void acceptInvite(UUID teamId) {
        TeamActionPacket packet = TeamActionPacket.accept(teamId);
        NetworkManager.sendToServer(packet);
        this.m_7379_();
    }

    private void declineInvite(UUID teamId) {
        TeamActionPacket packet = TeamActionPacket.decline(teamId);
        NetworkManager.sendToServer(packet);
        this.m_169413_();
        this.m_7856_();
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_7043_() {
        return false;
    }

    static class InviteEntry {
        TeamInviteInfo inviteInfo;
        Button acceptButton;
        Button declineButton;

        InviteEntry(TeamInviteInfo inviteInfo) {
            this.inviteInfo = inviteInfo;
        }
    }
}

