/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import org.texboobcat.questory.client.gui.QuestEditorScreen;
import org.texboobcat.questory.client.gui.TabPanel;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.team.TeamProgressMode;
import org.texboobcat.questory.team.TeamQuestSettings;
import org.texboobcat.questory.team.TeamRewardMode;

public class TeamTabPanel
extends TabPanel {
    private boolean teamEnabled = false;
    private TeamProgressMode progressMode = TeamProgressMode.SHARED;
    private TeamRewardMode rewardMode = TeamRewardMode.SHARED;
    private int minTeamSize = 1;
    private int maxTeamSize = 10;
    private boolean requireAllOnline = false;
    private boolean allowSoloCompletion = true;
    private Button teamEnabledBtn;
    private Button progressModeBtn;
    private Button rewardModeBtn;
    private EditBox minSizeField;
    private EditBox maxSizeField;
    private Button requireOnlineBtn;
    private Button allowSoloBtn;

    public TeamTabPanel(QuestEditorScreen editor, int x, int y, int w, int h) {
        super(editor, x, y, w, h);
        this.initWidgets();
    }

    private void initWidgets() {
        int fieldX = this.x + 12;
        int fieldY = this.y + 12;
        int labelW = 180;
        int btnW = 120;
        this.teamEnabledBtn = Button.m_253074_((Component)Component.m_237113_((String)"Team Enabled: No"), b -> {
            this.teamEnabled = !this.teamEnabled;
            this.updateButtonLabels();
            this.editor.saveCurrentTabToQuest();
        }).m_252987_(fieldX + labelW, fieldY, btnW, 20).m_253136_();
        this.progressModeBtn = Button.m_253074_((Component)Component.m_237113_((String)"Progress: SHARED"), b -> {
            this.progressMode = switch (this.progressMode) {
                default -> throw new IncompatibleClassChangeError();
                case TeamProgressMode.SHARED -> TeamProgressMode.INDIVIDUAL;
                case TeamProgressMode.INDIVIDUAL -> TeamProgressMode.COMBINED;
                case TeamProgressMode.COMBINED -> TeamProgressMode.PARALLEL;
                case TeamProgressMode.PARALLEL -> TeamProgressMode.SHARED;
            };
            this.updateButtonLabels();
            this.editor.saveCurrentTabToQuest();
        }).m_252987_(fieldX + labelW, fieldY += 30, btnW + 30, 20).m_253136_();
        this.rewardModeBtn = Button.m_253074_((Component)Component.m_237113_((String)"Reward: SHARED"), b -> {
            this.rewardMode = switch (this.rewardMode) {
                default -> throw new IncompatibleClassChangeError();
                case TeamRewardMode.SHARED -> TeamRewardMode.COMPLETER_ONLY;
                case TeamRewardMode.COMPLETER_ONLY -> TeamRewardMode.DISTRIBUTED;
                case TeamRewardMode.DISTRIBUTED -> TeamRewardMode.ALL_MEMBERS;
                case TeamRewardMode.ALL_MEMBERS -> TeamRewardMode.SHARED;
            };
            this.updateButtonLabels();
            this.editor.saveCurrentTabToQuest();
        }).m_252987_(fieldX + labelW, fieldY += 30, btnW + 30, 20).m_253136_();
        this.minSizeField = this.createField(fieldX + labelW, fieldY += 30, 60, "1");
        this.minSizeField.m_94199_(2);
        this.maxSizeField = this.createField(fieldX + labelW, fieldY += 30, 60, "10");
        this.maxSizeField.m_94199_(2);
        this.requireOnlineBtn = Button.m_253074_((Component)Component.m_237113_((String)"Require All Online: No"), b -> {
            this.requireAllOnline = !this.requireAllOnline;
            this.updateButtonLabels();
            this.editor.saveCurrentTabToQuest();
        }).m_252987_(fieldX + labelW, fieldY += 30, btnW + 30, 20).m_253136_();
        this.allowSoloBtn = Button.m_253074_((Component)Component.m_237113_((String)"Allow Solo: Yes"), b -> {
            this.allowSoloCompletion = !this.allowSoloCompletion;
            this.updateButtonLabels();
            this.editor.saveCurrentTabToQuest();
        }).m_252987_(fieldX + labelW, fieldY += 30, btnW + 30, 20).m_253136_();
    }

    private void updateButtonLabels() {
        this.teamEnabledBtn.m_93666_((Component)Component.m_237113_((String)("Team Enabled: " + (this.teamEnabled ? "Yes" : "No"))));
        this.progressModeBtn.m_93666_((Component)Component.m_237113_((String)("Progress: " + this.progressMode.name())));
        this.rewardModeBtn.m_93666_((Component)Component.m_237113_((String)("Reward: " + this.rewardMode.name())));
        this.requireOnlineBtn.m_93666_((Component)Component.m_237113_((String)("Require All Online: " + (this.requireAllOnline ? "Yes" : "No"))));
        this.allowSoloBtn.m_93666_((Component)Component.m_237113_((String)("Allow Solo: " + (this.allowSoloCompletion ? "Yes" : "No"))));
        this.progressModeBtn.f_93623_ = this.teamEnabled;
        this.rewardModeBtn.f_93623_ = this.teamEnabled;
        this.minSizeField.m_94186_(this.teamEnabled);
        this.maxSizeField.m_94186_(this.teamEnabled);
        this.requireOnlineBtn.f_93623_ = this.teamEnabled;
        this.allowSoloBtn.f_93623_ = this.teamEnabled;
    }

    @Override
    public void loadFromQuest(Quest quest) {
        TeamQuestSettings settings = quest.getTeamSettings();
        if (settings != null) {
            this.teamEnabled = settings.isTeamEnabled();
            this.progressMode = settings.getProgressMode();
            this.rewardMode = settings.getRewardMode();
            this.minTeamSize = settings.getMinTeamSize();
            this.maxTeamSize = settings.getMaxTeamSize();
            this.requireAllOnline = settings.isRequireAllOnline();
            this.allowSoloCompletion = settings.isAllowSoloCompletion();
            this.minSizeField.m_94144_(String.valueOf(this.minTeamSize));
            this.maxSizeField.m_94144_(String.valueOf(this.maxTeamSize));
        } else {
            this.teamEnabled = false;
            this.progressMode = TeamProgressMode.SHARED;
            this.rewardMode = TeamRewardMode.SHARED;
            this.minTeamSize = 1;
            this.maxTeamSize = 10;
            this.requireAllOnline = false;
            this.allowSoloCompletion = true;
            this.minSizeField.m_94144_("1");
            this.maxSizeField.m_94144_("10");
        }
        this.updateButtonLabels();
    }

    @Override
    public void saveToQuest(Quest quest) {
        try {
            this.minTeamSize = Integer.parseInt(this.minSizeField.m_94155_());
        }
        catch (NumberFormatException e) {
            this.minTeamSize = 1;
        }
        try {
            this.maxTeamSize = Integer.parseInt(this.maxSizeField.m_94155_());
        }
        catch (NumberFormatException e) {
            this.maxTeamSize = 10;
        }
        TeamQuestSettings settings = new TeamQuestSettings();
        settings.setTeamEnabled(this.teamEnabled);
        settings.setProgressMode(this.progressMode);
        settings.setRewardMode(this.rewardMode);
        settings.setMinTeamSize(this.minTeamSize);
        settings.setMaxTeamSize(this.maxTeamSize);
        settings.setRequireAllOnline(this.requireAllOnline);
        settings.setAllowSoloCompletion(this.allowSoloCompletion);
        quest.setTeamSettings(settings);
    }

    @Override
    public void render(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        int fieldX = this.x + 12;
        int fieldY = this.y + 12;
        int labelW = 180;
        g.m_280488_(this.getFont(), "\u00a7e\u00a7lTeam Quest Settings", fieldX, fieldY - 10, 0xFFFFFF);
        g.m_280488_(this.getFont(), "Enable Team Quest:", fieldX, fieldY, 0xFFFFFF);
        this.teamEnabledBtn.m_88315_(g, mouseX, mouseY, partialTick);
        fieldY += 30;
        if (this.teamEnabled) {
            g.m_280488_(this.getFont(), "Progress Mode:", fieldX, fieldY, 0xFFFFFF);
            this.progressModeBtn.m_88315_(g, mouseX, mouseY, partialTick);
            g.m_280488_(this.getFont(), "  \u00a77" + this.getProgressModeHelp(), fieldX + 4, fieldY += 25, 0x888888);
            g.m_280488_(this.getFont(), "Reward Mode:", fieldX, fieldY += 15, 0xFFFFFF);
            this.rewardModeBtn.m_88315_(g, mouseX, mouseY, partialTick);
            g.m_280488_(this.getFont(), "  \u00a77" + this.getRewardModeHelp(), fieldX + 4, fieldY += 25, 0x888888);
            g.m_280488_(this.getFont(), "Min Team Size:", fieldX, fieldY += 15, 0xFFFFFF);
            this.minSizeField.m_88315_(g, mouseX, mouseY, partialTick);
            g.m_280488_(this.getFont(), "Max Team Size:", fieldX, fieldY += 30, 0xFFFFFF);
            this.maxSizeField.m_88315_(g, mouseX, mouseY, partialTick);
            g.m_280488_(this.getFont(), "Require All Members Online:", fieldX, fieldY += 30, 0xFFFFFF);
            this.requireOnlineBtn.m_88315_(g, mouseX, mouseY, partialTick);
            g.m_280488_(this.getFont(), "Allow Solo Completion:", fieldX, fieldY += 30, 0xFFFFFF);
            this.allowSoloBtn.m_88315_(g, mouseX, mouseY, partialTick);
        } else {
            g.m_280488_(this.getFont(), "\u00a77Enable team settings to configure", fieldX, fieldY + 10, 0x888888);
            g.m_280488_(this.getFont(), "\u00a77team-specific quest behavior.", fieldX, fieldY + 22, 0x888888);
        }
    }

    private String getProgressModeHelp() {
        return switch (this.progressMode) {
            default -> throw new IncompatibleClassChangeError();
            case TeamProgressMode.SHARED -> "All members share progress";
            case TeamProgressMode.INDIVIDUAL -> "Each tracks own progress";
            case TeamProgressMode.COMBINED -> "Sum of all contributions";
            case TeamProgressMode.PARALLEL -> "All must complete individually";
        };
    }

    private String getRewardModeHelp() {
        return switch (this.rewardMode) {
            default -> throw new IncompatibleClassChangeError();
            case TeamRewardMode.SHARED -> "All online members get rewards";
            case TeamRewardMode.COMPLETER_ONLY -> "Only completer gets rewards";
            case TeamRewardMode.DISTRIBUTED -> "Rewards split among all";
            case TeamRewardMode.ALL_MEMBERS -> "All members (including offline)";
        };
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.teamEnabledBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.progressModeBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.rewardModeBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.requireOnlineBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.allowSoloBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }
}

