/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui.editor;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.questory.client.gui.editor.AutoSaveManager;

public class AutoSaveConfigScreen
extends Screen {
    private final Screen parent;
    private final AutoSaveManager autoSaveManager;
    private EditBox intervalField;
    private EditBox maxAutoSavesField;
    private EditBox purgeDaysField;
    private Button enabledToggleBtn;
    private Button focusLossToggleBtn;
    private Button entitySwitchToggleBtn;
    private Button saveBtn;
    private Button cancelBtn;
    private Button resetBtn;
    private AutoSaveManager.AutoSaveConfig workingConfig;

    public AutoSaveConfigScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"Auto-Save Configuration"));
        this.parent = parent;
        this.autoSaveManager = AutoSaveManager.getInstance();
        this.workingConfig = this.autoSaveManager.getConfig().copy();
    }

    protected void m_7856_() {
        super.m_7856_();
        int centerX = this.f_96543_ / 2;
        int startY = 60;
        int fieldWidth = 200;
        int spacing = 35;
        int y = startY;
        this.enabledToggleBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Auto-Save: " + (this.workingConfig.enabled ? "\u00a7aEnabled" : "\u00a7cDisabled"))), b -> {
            this.workingConfig.enabled = !this.workingConfig.enabled;
            b.m_93666_((Component)Component.m_237113_((String)("Auto-Save: " + (this.workingConfig.enabled ? "\u00a7aEnabled" : "\u00a7cDisabled"))));
        }).m_252987_(centerX - fieldWidth / 2, y, fieldWidth, 20).m_253136_());
        this.intervalField = new EditBox(this.f_96547_, centerX - fieldWidth / 2, y += spacing, fieldWidth, 20, (Component)Component.m_237113_((String)"Interval"));
        this.intervalField.m_94144_(String.valueOf(this.workingConfig.intervalSeconds));
        this.intervalField.m_257771_((Component)Component.m_237113_((String)"Seconds between auto-saves (min: 5)"));
        this.intervalField.m_94153_(s -> s.matches("\\d*"));
        this.m_142416_((GuiEventListener)this.intervalField);
        this.maxAutoSavesField = new EditBox(this.f_96547_, centerX - fieldWidth / 2, y += spacing, fieldWidth, 20, (Component)Component.m_237113_((String)"Max Auto-Saves"));
        this.maxAutoSavesField.m_94144_(String.valueOf(this.workingConfig.maxAutoSaves));
        this.maxAutoSavesField.m_257771_((Component)Component.m_237113_((String)"Max auto-save entries per entity"));
        this.maxAutoSavesField.m_94153_(s -> s.matches("\\d*"));
        this.m_142416_((GuiEventListener)this.maxAutoSavesField);
        this.purgeDaysField = new EditBox(this.f_96547_, centerX - fieldWidth / 2, y += spacing, fieldWidth, 20, (Component)Component.m_237113_((String)"Purge Days"));
        this.purgeDaysField.m_94144_(String.valueOf(this.workingConfig.purgeAfterDays));
        this.purgeDaysField.m_257771_((Component)Component.m_237113_((String)"Delete auto-saves older than (days)"));
        this.purgeDaysField.m_94153_(s -> s.matches("\\d*"));
        this.m_142416_((GuiEventListener)this.purgeDaysField);
        this.focusLossToggleBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Save on Focus Loss: " + (this.workingConfig.saveOnFocusLoss ? "\u00a7aYes" : "\u00a77No"))), b -> {
            this.workingConfig.saveOnFocusLoss = !this.workingConfig.saveOnFocusLoss;
            b.m_93666_((Component)Component.m_237113_((String)("Save on Focus Loss: " + (this.workingConfig.saveOnFocusLoss ? "\u00a7aYes" : "\u00a77No"))));
        }).m_252987_(centerX - fieldWidth / 2, y += spacing, fieldWidth, 20).m_253136_());
        this.entitySwitchToggleBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Save on Entity Switch: " + (this.workingConfig.saveOnEntitySwitch ? "\u00a7aYes" : "\u00a77No"))), b -> {
            this.workingConfig.saveOnEntitySwitch = !this.workingConfig.saveOnEntitySwitch;
            b.m_93666_((Component)Component.m_237113_((String)("Save on Entity Switch: " + (this.workingConfig.saveOnEntitySwitch ? "\u00a7aYes" : "\u00a77No"))));
        }).m_252987_(centerX - fieldWidth / 2, y += 25, fieldWidth, 20).m_253136_());
        int btnWidth = 90;
        int btnSpacing = 10;
        int totalBtnWidth = btnWidth * 3 + btnSpacing * 2;
        int btnStartX = centerX - totalBtnWidth / 2;
        this.saveBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Save"), b -> this.save()).m_252987_(btnStartX, y += spacing + 20, btnWidth, 20).m_253136_());
        this.resetBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Reset Defaults"), b -> this.resetDefaults()).m_252987_(btnStartX + btnWidth + btnSpacing, y, btnWidth, 20).m_253136_());
        this.cancelBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), b -> this.m_7379_()).m_252987_(btnStartX + (btnWidth + btnSpacing) * 2, y, btnWidth, 20).m_253136_());
        y += spacing + 10;
    }

    private void save() {
        block9: {
            try {
                int newInterval = Integer.parseInt(this.intervalField.m_94155_());
                int newMaxAutoSaves = Integer.parseInt(this.maxAutoSavesField.m_94155_());
                int newPurgeDays = Integer.parseInt(this.purgeDaysField.m_94155_());
                if (newInterval < 5) {
                    if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                        this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7cInterval must be at least 5 seconds"));
                    }
                    return;
                }
                if (newMaxAutoSaves < 1) {
                    if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                        this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7cMax auto-saves must be at least 1"));
                    }
                    return;
                }
                if (newPurgeDays < 1) {
                    if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                        this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7cPurge days must be at least 1"));
                    }
                    return;
                }
                this.workingConfig.intervalSeconds = newInterval;
                this.workingConfig.maxAutoSaves = newMaxAutoSaves;
                this.workingConfig.purgeAfterDays = newPurgeDays;
                this.autoSaveManager.updateConfig(this.workingConfig);
                if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                    this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7aAuto-save configuration saved"));
                }
                this.m_7379_();
            }
            catch (NumberFormatException e) {
                if (this.f_96541_ == null || this.f_96541_.f_91074_ == null) break block9;
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7cInvalid number format"));
            }
        }
    }

    private void resetDefaults() {
        this.workingConfig.enabled = true;
        this.workingConfig.intervalSeconds = 30;
        this.workingConfig.maxAutoSaves = 5;
        this.workingConfig.purgeAfterDays = 7;
        this.workingConfig.saveOnFocusLoss = false;
        this.workingConfig.saveOnEntitySwitch = true;
        this.enabledToggleBtn.m_93666_((Component)Component.m_237113_((String)"Auto-Save: \u00a7aEnabled"));
        this.intervalField.m_94144_("30");
        this.maxAutoSavesField.m_94144_("5");
        this.purgeDaysField.m_94144_("7");
        this.focusLossToggleBtn.m_93666_((Component)Component.m_237113_((String)"Save on Focus Loss: \u00a77No"));
        this.entitySwitchToggleBtn.m_93666_((Component)Component.m_237113_((String)"Save on Entity Switch: \u00a7aYes"));
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(g);
        g.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 20, -1);
        int centerX = this.f_96543_ / 2;
        int fieldWidth = 200;
        int labelX = centerX - fieldWidth / 2;
        g.m_280488_(this.f_96547_, "Enable/Disable:", labelX, 53, -5592406);
        g.m_280488_(this.f_96547_, "Interval (seconds):", labelX, 88, -5592406);
        g.m_280488_(this.f_96547_, "Max Auto-Saves:", labelX, 123, -5592406);
        g.m_280488_(this.f_96547_, "Purge After (days):", labelX, 158, -5592406);
        int infoY = 310;
        int infoWidth = 450;
        int infoX = this.f_96543_ / 2 - infoWidth / 2;
        g.m_280509_(infoX, infoY, infoX + infoWidth, infoY + 90, -1442840576);
        String[] infoLines = new String[]{"\u00a77Auto-Save Configuration", "\u00a7fInterval: How often editors auto-save (min: 5s)", "\u00a7fMax Auto-Saves: Number of auto-save entries per entity", "\u00a7fPurge Days: Delete auto-saves older than this many days", "\u00a7fFocus Loss: Save when editor loses focus (experimental)", "\u00a7fEntity Switch: Save when switching between entities (recommended)", "\u00a7fChanges apply immediately to all open editors"};
        int lineY = infoY + 8;
        for (String line : infoLines) {
            g.m_280488_(this.f_96547_, line, infoX + 8, lineY, -1);
            lineY += 11;
        }
        String status = this.autoSaveManager.getStatusString();
        g.m_280137_(this.f_96547_, "\u00a77Current Status: \u00a7f" + status, this.f_96543_ / 2, this.f_96544_ - 30, -1);
        super.m_88315_(g, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parent);
        }
    }

    public boolean m_7043_() {
        return true;
    }
}

