/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.rendering;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiGraphics;

public class IconModifier {
    private int colorTint = -1;
    private float alpha = 1.0f;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private boolean tiled = false;
    private int tileWidth = 16;
    private int tileHeight = 16;

    public IconModifier withColor(int color) {
        this.colorTint = color;
        return this;
    }

    public IconModifier withAlpha(float alpha) {
        this.alpha = Math.max(0.0f, Math.min(1.0f, alpha));
        int alphaInt = (int)(this.alpha * 255.0f);
        this.colorTint = this.colorTint & 0xFFFFFF | alphaInt << 24;
        return this;
    }

    public IconModifier withScale(float scaleX, float scaleY) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        return this;
    }

    public IconModifier withScale(float scale) {
        return this.withScale(scale, scale);
    }

    public IconModifier withTiling(int tileWidth, int tileHeight) {
        this.tiled = true;
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
        return this;
    }

    public void applyToGraphics(GuiGraphics graphics, int x, int y, int width, int height) {
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        if (this.scaleX != 1.0f || this.scaleY != 1.0f) {
            float centerX = (float)x + (float)width / 2.0f;
            float centerY = (float)y + (float)height / 2.0f;
            poseStack.m_252880_(centerX, centerY, 0.0f);
            poseStack.m_85841_(this.scaleX, this.scaleY, 1.0f);
            poseStack.m_252880_(-centerX, -centerY, 0.0f);
        }
    }

    public void restore(GuiGraphics graphics) {
        graphics.m_280168_().m_85849_();
    }

    public void renderTiled(GuiGraphics graphics, int x, int y, int width, int height, RenderCallback callback) {
        if (!this.tiled) {
            callback.render(graphics, x, y, width, height, this.colorTint);
            return;
        }
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        int tilesX = (width + this.tileWidth - 1) / this.tileWidth;
        int tilesY = (height + this.tileHeight - 1) / this.tileHeight;
        for (int ty = 0; ty < tilesY; ++ty) {
            for (int tx = 0; tx < tilesX; ++tx) {
                int tileX = x + tx * this.tileWidth;
                int tileY = y + ty * this.tileHeight;
                int tileW = Math.min(this.tileWidth, width - tx * this.tileWidth);
                int tileH = Math.min(this.tileHeight, height - ty * this.tileHeight);
                callback.render(graphics, tileX, tileY, tileW, tileH, this.colorTint);
            }
        }
        poseStack.m_85849_();
    }

    public int getColor() {
        return this.colorTint;
    }

    public int getAlphaInt() {
        return this.colorTint >> 24 & 0xFF;
    }

    public int getRed() {
        return this.colorTint >> 16 & 0xFF;
    }

    public int getGreen() {
        return this.colorTint >> 8 & 0xFF;
    }

    public int getBlue() {
        return this.colorTint & 0xFF;
    }

    public IconModifier copy() {
        IconModifier copy = new IconModifier();
        copy.colorTint = this.colorTint;
        copy.alpha = this.alpha;
        copy.scaleX = this.scaleX;
        copy.scaleY = this.scaleY;
        copy.tiled = this.tiled;
        copy.tileWidth = this.tileWidth;
        copy.tileHeight = this.tileHeight;
        return copy;
    }

    public static IconModifier white() {
        return new IconModifier().withColor(-1);
    }

    public static IconModifier withAlpha(int alpha) {
        return new IconModifier().withAlpha((float)alpha / 255.0f);
    }

    public static IconModifier withColorAndAlpha(int rgb, int alpha) {
        return new IconModifier().withColor(rgb | alpha << 24);
    }

    public static IconModifier gray() {
        return new IconModifier().withColor(-8355712);
    }

    public static IconModifier darkGray() {
        return new IconModifier().withColor(-12566464);
    }

    @FunctionalInterface
    public static interface RenderCallback {
        public void render(GuiGraphics var1, int var2, int var3, int var4, int var5, int var6);
    }
}

