/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.forge.client;

import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.texboobcat.questory.Questory;
import org.texboobcat.questory.client.QuestoryKeybindings;
import org.texboobcat.questory.client.gui.QuestHudOverlay;
import org.texboobcat.questory.forge.client.ClientThemeReloadListener;

public class QuestoryForgeClient {
    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new QuestoryForgeClient());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(QuestoryForgeClient::onClientSetup);
    }

    private static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            QuestoryKeybindings.register();
            Questory.LOGGER.info("[Questory Forge Client] Keybindings registered");
            Minecraft mc = Minecraft.m_91087_();
            ResourceManager patt0$temp = mc.m_91098_();
            if (patt0$temp instanceof ReloadableResourceManager) {
                ReloadableResourceManager resourceManager = (ReloadableResourceManager)patt0$temp;
                ClientThemeReloadListener themeListener = new ClientThemeReloadListener();
                resourceManager.m_7217_((PreparableReloadListener)themeListener);
                Questory.LOGGER.info("[Questory Forge Client] Theme reload listener registered");
            }
        });
        Questory.LOGGER.info("[Questory Forge Client] Initialized");
    }

    @SubscribeEvent
    public void onRenderHud(RenderGuiOverlayEvent.Post event) {
        QuestHudOverlay.render(event.getGuiGraphics(), event.getPartialTick());
    }
}

