/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.integration;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.texboobcat.questory.Questory;
import org.texboobcat.questory.integration.OPACClaimHelper;

public class OPACProtectionHelper {
    public static boolean isAvailable() {
        return OPACClaimHelper.isAvailable();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean canBreakBlock(ServerPlayer player, ServerLevel level, BlockPos pos) {
        if (!OPACProtectionHelper.isAvailable() || player == null || level == null || pos == null) {
            return true;
        }
        try {
            Object api = OPACProtectionHelper.getOPACAPI(level.m_7654_());
            if (api == null) {
                return true;
            }
            Object chunkProtection = api.getClass().getMethod("getChunkProtection", new Class[0]).invoke(api, new Object[0]);
            if (chunkProtection == null) {
                return true;
            }
            Object result = chunkProtection.getClass().getMethod("hasChunkAccess", Class.forName("net.minecraft.server.level.ServerPlayer"), Class.forName("net.minecraft.core.BlockPos")).invoke(chunkProtection, player, pos);
            if (!(result instanceof Boolean)) return true;
            return (Boolean)result;
        }
        catch (NoSuchMethodException e) {}
        finally {
            return OPACProtectionHelper.checkAccessViaClaimOwnership(player, level, pos);
        }
    }

    public static boolean canPlaceBlock(ServerPlayer player, ServerLevel level, BlockPos pos) {
        return OPACProtectionHelper.canBreakBlock(player, level, pos);
    }

    public static boolean canInteractWithEntity(ServerPlayer player, Entity entity) {
        if (!OPACProtectionHelper.isAvailable() || player == null || entity == null) {
            return true;
        }
        try {
            ServerLevel level = player.m_284548_();
            BlockPos entityPos = entity.m_20183_();
            return OPACProtectionHelper.checkAccessViaClaimOwnership(player, level, entityPos);
        }
        catch (Throwable t) {
            return true;
        }
    }

    public static boolean canDamageEntityAt(ServerPlayer player, ServerLevel level, BlockPos entityPos) {
        if (!OPACProtectionHelper.isAvailable() || player == null || level == null || entityPos == null) {
            return true;
        }
        try {
            Object api = OPACProtectionHelper.getOPACAPI(level.m_7654_());
            if (api == null) {
                return true;
            }
            Object chunkProtection = api.getClass().getMethod("getChunkProtection", new Class[0]).invoke(api, new Object[0]);
            if (chunkProtection == null) {
                return true;
            }
            return OPACProtectionHelper.checkAccessViaClaimOwnership(player, level, entityPos);
        }
        catch (Throwable t) {
            return true;
        }
    }

    public static boolean canAccessContainer(ServerPlayer player, ServerLevel level, BlockPos pos) {
        if (!OPACProtectionHelper.isAvailable() || player == null || level == null || pos == null) {
            return true;
        }
        try {
            return OPACProtectionHelper.checkAccessViaClaimOwnership(player, level, pos);
        }
        catch (Throwable t) {
            return true;
        }
    }

    private static boolean checkAccessViaClaimOwnership(ServerPlayer player, ServerLevel level, BlockPos pos) {
        if (!OPACClaimHelper.isClaimed(level, pos)) {
            return true;
        }
        if (OPACClaimHelper.isClaimedBy(level, pos, player.m_20148_())) {
            return true;
        }
        return OPACClaimHelper.isInPartyClaim(player);
    }

    public static boolean isProtected(ServerLevel level, BlockPos pos) {
        return OPACClaimHelper.isClaimed(level, pos);
    }

    public static String getProtectionStatus(ServerLevel level, BlockPos pos) {
        if (!OPACProtectionHelper.isAvailable()) {
            return "No protection (OPAC not installed)";
        }
        if (!OPACClaimHelper.isClaimed(level, pos)) {
            return "Unprotected (wilderness)";
        }
        String ownerName = OPACClaimHelper.getClaimOwnerName(level, pos);
        boolean isForceloaded = OPACClaimHelper.isForceloaded(level, pos);
        StringBuilder sb = new StringBuilder("Protected by ");
        sb.append(ownerName != null ? ownerName : "unknown");
        if (isForceloaded) {
            sb.append(" [Forceloaded]");
        }
        return sb.toString();
    }

    public static boolean isInteractionAllowed(ServerPlayer player, ServerLevel level, BlockPos pos, InteractionType interactionType) {
        if (!OPACProtectionHelper.isAvailable() || player == null || level == null || pos == null) {
            return true;
        }
        return switch (interactionType.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> OPACProtectionHelper.canBreakBlock(player, level, pos);
            case 1, 4 -> OPACProtectionHelper.canDamageEntityAt(player, level, pos);
            case 3 -> OPACProtectionHelper.canAccessContainer(player, level, pos);
            case 2 -> OPACProtectionHelper.checkAccessViaClaimOwnership(player, level, pos);
        };
    }

    public static void registerQuestStructure(ServerLevel level, BlockPos pos, String questId) {
        try {
            Questory.LOGGER.debug("Registered quest structure at {} for quest {}", (Object)pos, (Object)questId);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static Object getOPACAPI(MinecraftServer server) {
        if (server == null) {
            return null;
        }
        try {
            Class<?> apiClass = Class.forName("xaero.pac.common.server.api.OpenPACServerAPI");
            return apiClass.getMethod("get", MinecraftServer.class).invoke(null, server);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static boolean hasClaimException(ServerPlayer player, ServerLevel level, BlockPos pos, String exceptionType) {
        if (!OPACProtectionHelper.isAvailable() || player == null || level == null || pos == null) {
            return false;
        }
        try {
            Object api = OPACProtectionHelper.getOPACAPI(level.m_7654_());
            if (api == null) {
                return false;
            }
            Object claimsManager = api.getClass().getMethod("getServerClaimsManager", new Class[0]).invoke(api, new Object[0]);
            if (claimsManager == null) {
                return false;
            }
            int chunkX = pos.m_123341_() >> 4;
            int chunkZ = pos.m_123343_() >> 4;
            ResourceLocation dimension = level.m_46472_().m_135782_();
            Object claim = claimsManager.getClass().getMethod("get", ResourceLocation.class, Integer.TYPE, Integer.TYPE).invoke(claimsManager, dimension, chunkX, chunkZ);
            if (claim == null) {
                return false;
            }
            Object playerId = claim.getClass().getMethod("getPlayerId", new Class[0]).invoke(claim, new Object[0]);
            return player.m_20148_().equals(playerId);
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static Map<String, Object> getClaimInfo(ServerLevel level, BlockPos pos) {
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("protected", false);
        info.put("owner", null);
        info.put("ownerName", null);
        info.put("forceloaded", false);
        info.put("partyOwned", false);
        if (!OPACProtectionHelper.isAvailable() || level == null || pos == null) {
            return info;
        }
        try {
            boolean isClaimed = OPACClaimHelper.isClaimed(level, pos);
            info.put("protected", isClaimed);
            if (isClaimed) {
                UUID owner = OPACClaimHelper.getClaimOwner(level, pos);
                info.put("owner", owner);
                info.put("ownerName", OPACClaimHelper.getClaimOwnerName(level, pos));
                info.put("forceloaded", OPACClaimHelper.isForceloaded(level, pos));
                UUID partyId = OPACClaimHelper.getClaimPartyId(level, pos);
                info.put("partyOwned", partyId != null);
                info.put("partyId", partyId);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return info;
    }

    public static enum InteractionType {
        BLOCK_INTERACTION,
        ENTITY_INTERACTION,
        ITEM_USE,
        CONTAINER_ACCESS,
        ENTITY_DAMAGE;

    }
}

