/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.manager;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;
import org.texboobcat.questory.Questory;
import org.texboobcat.questory.manager.QuestManager;
import org.texboobcat.questory.quest.GenericTriggerRequirement;

public class TriggerListenerManager {
    private static final TriggerListenerManager INSTANCE = new TriggerListenerManager();
    private final Map<UUID, Map<GenericTriggerRequirement, Object>> activeListeners = new ConcurrentHashMap<UUID, Map<GenericTriggerRequirement, Object>>();

    public static TriggerListenerManager getInstance() {
        return INSTANCE;
    }

    public void registerListener(ServerPlayer player, String questId, GenericTriggerRequirement requirement) {
        try {
            ResourceLocation triggerId = new ResourceLocation(requirement.getTriggerId());
            CriterionTrigger<?> trigger = this.getTriggerByName(triggerId);
            if (trigger == null) {
                Questory.LOGGER.warn("Unknown trigger type: {}", (Object)triggerId);
                return;
            }
            this.registerListenerTyped(trigger, player, questId, requirement);
        }
        catch (Exception e) {
            Questory.LOGGER.error("Failed to register trigger listener for {}", (Object)requirement.getTriggerId(), (Object)e);
        }
    }

    public List<ResourceLocation> getKnownTriggerIds() {
        ArrayList<ResourceLocation> ids = new ArrayList<ResourceLocation>();
        try {
            for (Field field : CriteriaTriggers.class.getDeclaredFields()) {
                if (!Modifier.isStatic(field.getModifiers()) || !Map.class.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                Map map = (Map)field.get(null);
                if (map.isEmpty() || !(map.values().iterator().next() instanceof CriterionTrigger)) continue;
                for (Object key : map.keySet()) {
                    if (key instanceof ResourceLocation) {
                        ResourceLocation rl = (ResourceLocation)key;
                        ids.add(rl);
                        continue;
                    }
                    if (!(key instanceof String)) continue;
                    String s = (String)key;
                    ids.add(new ResourceLocation(s));
                }
                return ids;
            }
            for (Field field : CriteriaTriggers.class.getDeclaredFields()) {
                if (!Modifier.isStatic(field.getModifiers()) || !CriterionTrigger.class.isAssignableFrom(field.getType())) continue;
                ids.add(new ResourceLocation("minecraft", field.getName().toLowerCase(Locale.ROOT)));
            }
        }
        catch (Exception e) {
            Questory.LOGGER.error("Error getting known triggers: {}", (Object)e.getMessage());
        }
        return ids;
    }

    private CriterionTrigger<?> getTriggerByName(ResourceLocation triggerId) {
        try {
            for (Field field : CriteriaTriggers.class.getDeclaredFields()) {
                if (!Modifier.isStatic(field.getModifiers()) || !Map.class.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                Map map = (Map)field.get(null);
                if (map.isEmpty() || !(map.values().iterator().next() instanceof CriterionTrigger)) continue;
                Object trigger = map.get(triggerId);
                if (trigger == null) {
                    trigger = map.get(triggerId.toString());
                }
                if (!(trigger instanceof CriterionTrigger)) continue;
                return (CriterionTrigger)trigger;
            }
            String path = triggerId.m_135815_().toUpperCase(Locale.ROOT);
            for (Field field : CriteriaTriggers.class.getDeclaredFields()) {
                if (!Modifier.isStatic(field.getModifiers()) || !CriterionTrigger.class.isAssignableFrom(field.getType()) || !field.getName().equals(path)) continue;
                field.setAccessible(true);
                return (CriterionTrigger)field.get(null);
            }
        }
        catch (Exception e) {
            Questory.LOGGER.error("Error accessing CriteriaTriggers: {}", (Object)e.getMessage());
        }
        return null;
    }

    private <T extends CriterionTriggerInstance> void registerListenerTyped(CriterionTrigger<T> trigger, ServerPlayer player, String questId, GenericTriggerRequirement requirement) {
        try {
            DeserializationContext context = new DeserializationContext(new ResourceLocation("questory", "generic_trigger"), player.f_8924_.m_278653_());
            CriterionTriggerInstance instance = trigger.m_5868_(requirement.getConditions(), context);
            Listener<CriterionTriggerInstance> listener = new Listener<CriterionTriggerInstance>(trigger, instance, requirement, player, questId);
            trigger.m_6467_(player.m_8960_(), listener);
            this.activeListeners.computeIfAbsent(player.m_20148_(), k -> new ConcurrentHashMap()).put(requirement, listener);
        }
        catch (Exception e) {
            Questory.LOGGER.error("Error creating listener for {}: {}", (Object)requirement.getTriggerId(), (Object)e.getMessage());
        }
    }

    public void unregisterListener(ServerPlayer player, GenericTriggerRequirement requirement) {
        Object listenerObj;
        Map<GenericTriggerRequirement, Object> playerListeners = this.activeListeners.get(player.m_20148_());
        if (playerListeners != null && (listenerObj = playerListeners.remove(requirement)) instanceof Listener) {
            Listener listener = (Listener)((Object)listenerObj);
            this.unregisterListenerTyped(listener, player);
        }
    }

    private <T extends CriterionTriggerInstance> void unregisterListenerTyped(Listener<T> listener, ServerPlayer player) {
        listener.trigger.m_6468_(player.m_8960_(), listener);
    }

    public void onPlayerDisconnect(UUID playerId) {
        this.activeListeners.remove(playerId);
    }

    public static class Listener<T extends CriterionTriggerInstance>
    extends CriterionTrigger.Listener<T> {
        public final CriterionTrigger<T> trigger;
        private final GenericTriggerRequirement requirement;
        private final ServerPlayer player;
        private final String questId;

        public Listener(CriterionTrigger<T> trigger, T triggerInstance, GenericTriggerRequirement requirement, ServerPlayer player, String questId) {
            super(triggerInstance, null, "questory_generic");
            this.trigger = trigger;
            this.requirement = requirement;
            this.player = player;
            this.questId = questId;
        }

        public void m_13686_(PlayerAdvancements playerAdvancements) {
            if (this.player.m_8960_() == playerAdvancements) {
                QuestManager.getInstance().trackRequirementProgress(this.player.m_20148_(), this.questId, this.requirement, 1, this.player);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Listener other = (Listener)((Object)obj);
            return Objects.equals(this.requirement, other.requirement) && Objects.equals(this.player.m_20148_(), other.player.m_20148_());
        }

        public int hashCode() {
            return Objects.hash(this.requirement, this.player.m_20148_());
        }
    }
}

