/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import org.texboobcat.questory.integration.OPACClaimHelper;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;

public class ClaimRequirement
extends Requirement {
    private ClaimMode mode;
    private String specificOwner;
    private String dimension;
    private boolean requireForceloaded;
    private String displayText;

    public ClaimRequirement(ClaimMode mode) {
        super("claim");
        this.mode = mode;
        this.specificOwner = null;
        this.dimension = null;
        this.requireForceloaded = false;
        this.displayText = null;
    }

    public ClaimRequirement(ClaimMode mode, String specificOwner, String dimension, boolean requireForceloaded, String displayText) {
        super("claim");
        this.mode = mode;
        this.specificOwner = specificOwner;
        this.dimension = dimension;
        this.requireForceloaded = requireForceloaded;
        this.displayText = displayText;
    }

    public ClaimMode getMode() {
        return this.mode;
    }

    public void setMode(ClaimMode mode) {
        this.mode = mode;
    }

    public String getSpecificOwner() {
        return this.specificOwner;
    }

    public void setSpecificOwner(String specificOwner) {
        this.specificOwner = specificOwner;
    }

    public String getDimension() {
        return this.dimension;
    }

    public void setDimension(String dimension) {
        this.dimension = dimension;
    }

    public boolean isRequireForceloaded() {
        return this.requireForceloaded;
    }

    public void setRequireForceloaded(boolean requireForceloaded) {
        this.requireForceloaded = requireForceloaded;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public void setDisplayText(String displayText) {
        this.displayText = displayText;
    }

    @Override
    public boolean isMet(QuestProgress progress, String questId) {
        return progress.getRequirementProgress(questId, this) > 0;
    }

    @Override
    public String getProgressDisplay(QuestProgress progress, String questId) {
        Object desc;
        boolean met;
        boolean bl = met = progress.getRequirementProgress(questId, this) > 0;
        if (this.displayText != null && !this.displayText.isEmpty()) {
            return (met ? "\u2713" : "\u2717") + " " + this.displayText;
        }
        switch (this.mode.ordinal()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 0: {
                Object object = "Be in any claimed chunk";
                break;
            }
            case 1: {
                Object object = "Be in your own claimed chunk";
                break;
            }
            case 2: {
                Object object = "Be in your party's claimed territory";
                break;
            }
            case 3: {
                String ownerName = this.specificOwner != null && this.specificOwner.length() > 8 ? this.specificOwner.substring(0, 8) + "..." : (this.specificOwner != null ? this.specificOwner : "???");
                Object object = "Be in " + ownerName + "'s claimed chunk";
                break;
            }
            case 4: {
                Object object = desc = "Be in unclaimed territory";
            }
        }
        if (this.dimension != null && !this.dimension.isEmpty()) {
            String dimName = this.dimension.contains(":") ? this.dimension.substring(this.dimension.indexOf(58) + 1) : this.dimension;
            desc = (String)desc + " in " + dimName;
        }
        if (this.requireForceloaded) {
            desc = (String)desc + " (forceloaded)";
        }
        if (!OPACClaimHelper.isAvailable()) {
            desc = (String)desc + " \u00a77(requires OPAC mod)";
        }
        return (met ? "\u2713" : "\u2717") + " " + (String)desc;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        json.addProperty("claim_mode", this.mode.name());
        if (this.specificOwner != null && !this.specificOwner.isEmpty()) {
            json.addProperty("specific_owner", this.specificOwner);
        }
        if (this.dimension != null && !this.dimension.isEmpty()) {
            json.addProperty("dimension", this.dimension);
        }
        if (this.requireForceloaded) {
            json.addProperty("require_forceloaded", Boolean.valueOf(true));
        }
        if (this.displayText != null && !this.displayText.isEmpty()) {
            json.addProperty("display_text", this.displayText);
        }
        return json;
    }

    public static ClaimRequirement fromJson(JsonObject json) {
        ClaimMode mode = ClaimMode.ANY_CLAIM;
        if (json.has("claim_mode")) {
            try {
                mode = ClaimMode.valueOf(json.get("claim_mode").getAsString());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        ClaimRequirement req = new ClaimRequirement(mode);
        if (json.has("specific_owner")) {
            req.setSpecificOwner(json.get("specific_owner").getAsString());
        }
        if (json.has("dimension")) {
            req.setDimension(json.get("dimension").getAsString());
        }
        if (json.has("require_forceloaded")) {
            req.setRequireForceloaded(json.get("require_forceloaded").getAsBoolean());
        }
        if (json.has("display_text")) {
            req.setDisplayText(json.get("display_text").getAsString());
        }
        return req;
    }

    public boolean checkForPlayer(ServerPlayer player) {
        String currentDim;
        if (player == null) {
            return false;
        }
        ServerLevel level = player.m_284548_();
        BlockPos pos = player.m_20183_();
        if (this.dimension != null && !this.dimension.isEmpty() && !(currentDim = level.m_46472_().m_135782_().toString()).equals(this.dimension)) {
            return false;
        }
        if (this.requireForceloaded && !OPACClaimHelper.isForceloaded(level, pos)) {
            return false;
        }
        return switch (this.mode.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> {
                boolean var4_5;
                yield var4_5 = OPACClaimHelper.isClaimed(level, pos);
            }
            case 1 -> {
                boolean var4_6;
                yield var4_6 = OPACClaimHelper.isClaimedBy(level, pos, player.m_20148_());
            }
            case 2 -> {
                boolean var4_7;
                yield var4_7 = OPACClaimHelper.isInPartyClaim(player);
            }
            case 3 -> {
                if (this.specificOwner == null || this.specificOwner.isEmpty()) {
                    boolean var4_8;
                    yield var4_8 = false;
                }
                try {
                    boolean var4_9;
                    UUID ownerId = UUID.fromString(this.specificOwner);
                    yield var4_9 = OPACClaimHelper.isClaimedBy(level, pos, ownerId);
                }
                catch (IllegalArgumentException e) {
                    boolean var4_10;
                    yield var4_10 = false;
                }
            }
            case 4 -> {
                boolean var4_11;
                yield var4_11 = !OPACClaimHelper.isClaimed(level, pos);
            }
        };
    }

    public static ClaimRequirement anyClaim() {
        return new ClaimRequirement(ClaimMode.ANY_CLAIM);
    }

    public static ClaimRequirement ownClaim() {
        return new ClaimRequirement(ClaimMode.OWN_CLAIM);
    }

    public static ClaimRequirement partyClaim() {
        return new ClaimRequirement(ClaimMode.PARTY_CLAIM);
    }

    public static ClaimRequirement unclaimed() {
        return new ClaimRequirement(ClaimMode.UNCLAIMED);
    }

    public static ClaimRequirement specificOwner(String ownerUuid) {
        ClaimRequirement req = new ClaimRequirement(ClaimMode.SPECIFIC_OWNER);
        req.setSpecificOwner(ownerUuid);
        return req;
    }

    public static enum ClaimMode {
        ANY_CLAIM,
        OWN_CLAIM,
        PARTY_CLAIM,
        SPECIFIC_OWNER,
        UNCLAIMED;

    }
}

