/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;

public class EquipItemRequirement
extends Requirement {
    private List<EquipmentEntry> entries;

    public EquipItemRequirement() {
        super("equip_item");
        this.entries = new ArrayList<EquipmentEntry>();
    }

    public EquipItemRequirement(List<EquipmentEntry> entries) {
        super("equip_item");
        this.entries = entries;
    }

    public List<EquipmentEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<EquipmentEntry> entries) {
        this.entries = entries;
    }

    public void addEntry(EquipmentEntry entry) {
        this.entries.add(entry);
    }

    public void removeEntry(int index) {
        if (index >= 0 && index < this.entries.size()) {
            this.entries.remove(index);
        }
    }

    public boolean isEquipped(Player player) {
        if (this.entries.isEmpty()) {
            return false;
        }
        for (EquipmentEntry entry : this.entries) {
            EquipmentSlot slot;
            ItemStack equipped;
            if (entry.matches(equipped = player.m_6844_(slot = entry.getSlot()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isMet(QuestProgress progress, String questId) {
        return progress.getRequirementProgress(questId, this) >= this.entries.size();
    }

    @Override
    public String getProgressDisplay(QuestProgress progress, String questId) {
        int current = progress.getRequirementProgress(questId, this);
        if (this.entries.size() == 1) {
            EquipmentEntry entry = this.entries.get(0);
            String slotLabel = this.formatSlotName(entry.getSlotName());
            return (current > 0 ? "\u2713" : "\u2717") + " Equip " + entry.getItemId() + " in " + slotLabel;
        }
        return current + "/" + this.entries.size() + " pieces equipped";
    }

    private String formatSlotName(String slot) {
        return switch (slot.toUpperCase()) {
            case "HEAD" -> "Helmet";
            case "CHEST" -> "Chestplate";
            case "LEGS" -> "Leggings";
            case "FEET" -> "Boots";
            case "MAINHAND" -> "Main Hand";
            case "OFFHAND" -> "Off Hand";
            default -> slot;
        };
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        JsonArray entriesArray = new JsonArray();
        for (EquipmentEntry entry : this.entries) {
            entriesArray.add((JsonElement)entry.toJson());
        }
        json.add("entries", (JsonElement)entriesArray);
        return json;
    }

    public static EquipItemRequirement fromJson(JsonObject json) {
        EquipItemRequirement req = new EquipItemRequirement();
        if (json.has("entries")) {
            JsonArray entriesArray = json.getAsJsonArray("entries");
            for (int i = 0; i < entriesArray.size(); ++i) {
                JsonObject entryJson = entriesArray.get(i).getAsJsonObject();
                req.addEntry(EquipmentEntry.fromJson(entryJson));
            }
        }
        return req;
    }

    public static class EquipmentEntry {
        private String slotName;
        private String itemId;
        private CompoundTag nbt;

        public EquipmentEntry(String slotName, String itemId) {
            this.slotName = slotName;
            this.itemId = itemId;
            this.nbt = null;
        }

        public String getSlotName() {
            return this.slotName;
        }

        public void setSlotName(String slotName) {
            this.slotName = slotName;
        }

        public String getItemId() {
            return this.itemId;
        }

        public void setItemId(String itemId) {
            this.itemId = itemId;
        }

        public CompoundTag getNbt() {
            return this.nbt;
        }

        public void setNbt(CompoundTag nbt) {
            this.nbt = nbt;
        }

        public boolean matches(ItemStack stack) {
            if (stack.m_41619_()) {
                return false;
            }
            ResourceLocation stackId = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_());
            if (!stackId.toString().equals(this.itemId)) {
                return false;
            }
            if (this.nbt != null) {
                CompoundTag stackNbt = stack.m_41783_();
                if (stackNbt == null) {
                    return false;
                }
                return this.nbtMatches(stackNbt, this.nbt);
            }
            return true;
        }

        private boolean nbtMatches(CompoundTag stackNbt, CompoundTag requiredNbt) {
            for (String key : requiredNbt.m_128431_()) {
                if (!stackNbt.m_128441_(key)) {
                    return false;
                }
                if (stackNbt.m_128423_(key).equals((Object)requiredNbt.m_128423_(key))) continue;
                return false;
            }
            return true;
        }

        public EquipmentSlot getSlot() {
            try {
                return EquipmentSlot.valueOf((String)this.slotName.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return EquipmentSlot.MAINHAND;
            }
        }

        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("slot", this.slotName);
            json.addProperty("item", this.itemId);
            if (this.nbt != null) {
                json.addProperty("nbt", this.nbt.toString());
            }
            return json;
        }

        public static EquipmentEntry fromJson(JsonObject json) {
            String slot = json.get("slot").getAsString();
            String item = json.get("item").getAsString();
            EquipmentEntry entry = new EquipmentEntry(slot, item);
            if (json.has("nbt")) {
                try {
                    CompoundTag nbt = TagParser.m_129359_((String)json.get("nbt").getAsString());
                    entry.setNbt(nbt);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return entry;
        }
    }
}

