/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.telemetry;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.texboobcat.questory.Questory;
import org.texboobcat.questory.client.ClientConfig;
import org.texboobcat.questory.telemetry.HeatmapData;
import org.texboobcat.questory.telemetry.SupabaseClient;

public class HeatmapDataCache {
    private static final HeatmapDataCache instance = new HeatmapDataCache();
    private static final int MAX_CACHE_SIZE = 100;
    private final Map<String, HeatmapData> cache = new ConcurrentHashMap<String, HeatmapData>();
    private final Map<String, CompletableFuture<HeatmapData>> loadingCache = new ConcurrentHashMap<String, CompletableFuture<HeatmapData>>();
    private final Map<String, Long> accessTimes = new ConcurrentHashMap<String, Long>();

    private HeatmapDataCache() {
    }

    public static HeatmapDataCache getInstance() {
        return instance;
    }

    public HeatmapData getHeatmapData(String modpackId, String modpackVersion) {
        String key = this.getCacheKey(modpackId, modpackVersion);
        int ttl = this.getHeatmapCacheTtl();
        this.accessTimes.put(key, System.currentTimeMillis());
        HeatmapData data = this.cache.get(key);
        if (data != null && !data.isStale(ttl)) {
            Questory.LOGGER.debug("Using cached heatmap data for {}", (Object)key);
            return data;
        }
        CompletableFuture future = this.loadingCache.computeIfAbsent(key, k -> CompletableFuture.supplyAsync(() -> {
            try {
                Questory.LOGGER.debug("Fetching fresh heatmap data for {}", k);
                HeatmapData freshData = SupabaseClient.getInstance().fetchHeatmapData(modpackId, modpackVersion);
                this.cache.put((String)k, freshData);
                this.evictOldestIfNeeded();
                HeatmapData heatmapData = freshData;
                return heatmapData;
            }
            catch (Exception e) {
                Questory.LOGGER.error("Failed to fetch heatmap data", (Throwable)e);
                HeatmapData staleData = this.cache.get(k);
                HeatmapData heatmapData = staleData != null ? staleData : new HeatmapData();
                return heatmapData;
            }
            finally {
                this.loadingCache.remove(k);
            }
        }));
        try {
            return (HeatmapData)future.get(15L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            Questory.LOGGER.error("Timeout fetching heatmap data, using stale or empty", (Throwable)e);
            this.loadingCache.remove(key);
            future.cancel(true);
            return data != null ? data : new HeatmapData();
        }
        catch (Exception e) {
            Questory.LOGGER.error("Failed to get heatmap data", (Throwable)e);
            this.loadingCache.remove(key);
            return data != null ? data : new HeatmapData();
        }
    }

    public void refresh(String modpackId, String modpackVersion) {
        String key = this.getCacheKey(modpackId, modpackVersion);
        this.cache.remove(key);
        this.loadingCache.remove(key);
        this.accessTimes.remove(key);
        this.getHeatmapData(modpackId, modpackVersion);
    }

    public void clearAll() {
        this.cache.clear();
        this.loadingCache.clear();
        this.accessTimes.clear();
        Questory.LOGGER.info("Cleared heatmap cache");
    }

    private void evictOldestIfNeeded() {
        if (this.cache.size() > 100) {
            String oldestKey = null;
            long oldestTime = Long.MAX_VALUE;
            for (Map.Entry<String, Long> entry : this.accessTimes.entrySet()) {
                if (entry.getValue() >= oldestTime) continue;
                oldestTime = entry.getValue();
                oldestKey = entry.getKey();
            }
            if (oldestKey != null) {
                this.cache.remove(oldestKey);
                this.accessTimes.remove(oldestKey);
                Questory.LOGGER.debug("Evicted oldest cache entry: {}", oldestKey);
            }
        }
    }

    private String getCacheKey(String modpackId, String modpackVersion) {
        return modpackId + ":" + modpackVersion;
    }

    private int getHeatmapCacheTtl() {
        try {
            return ClientConfig.getHeatmapCacheTtl();
        }
        catch (Exception e) {
            return 300;
        }
    }
}

