/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory;

import java.nio.file.Path;
import org.texboobcat.questory.config.QuestoryConfig;
import org.texboobcat.questory.manager.DailyQuestManager;
import org.texboobcat.questory.manager.QuestManager;
import org.texboobcat.questory.network.NetworkManager;

public final class Questory {
    public static final String MOD_ID = "questory";
    private static Path dataPath;
    private static Path configPath;

    public static void init() {
        System.out.println("Questory mod initializing...");
        NetworkManager.init();
    }

    public static void initQuestSystem(Path gamePath) {
        dataPath = gamePath.resolve("data").resolve(MOD_ID);
        configPath = gamePath.resolve("config");
        QuestoryConfig.load(configPath);
        QuestManager.initialize(dataPath);
        try {
            DailyQuestManager.getInstance().init(dataPath, QuestManager.getInstance());
        }
        catch (Throwable t) {
            System.err.println("[Questory] Failed to init DailyQuestManager: " + t.getMessage());
        }
        System.out.println("Questory quest system initialized");
        System.out.println("  Data path: " + String.valueOf(dataPath));
        System.out.println("  Config path: " + String.valueOf(configPath));
    }

    public static Path getDataPath() {
        return dataPath;
    }

    public static Path getConfigPath() {
        return configPath;
    }
}

