/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.api;

import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import org.texboobcat.questory.api.RequirementFactory;
import org.texboobcat.questory.quest.Requirement;

public class RequirementRegistry {
    private static final Map<String, RequirementFactory> REGISTRY = new HashMap<String, RequirementFactory>();

    public static void register(String type, RequirementFactory factory) {
        if (REGISTRY.containsKey(type)) {
            System.err.println("[Questory API] Warning: Overwriting requirement type: " + type);
        }
        REGISTRY.put(type, factory);
        System.out.println("[Questory API] Registered custom requirement type: " + type);
    }

    public static Requirement create(String type, JsonObject json) {
        RequirementFactory factory = REGISTRY.get(type);
        if (factory == null) {
            return null;
        }
        return factory.create(json);
    }

    public static boolean isRegistered(String type) {
        return REGISTRY.containsKey(type);
    }
}

