/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_310;

public class ClientConfig {
    private static final Gson GSON = new Gson();
    private static final String FILE_NAME = "questory_client.json";
    private static Set<String> pinnedGroups = new HashSet<String>();
    private static boolean chapterPanelPinned = false;
    private static Set<String> collapsedSections = new HashSet<String>();
    private static boolean loaded = false;

    private static File getConfigFile() {
        File dir = new File(class_310.method_1551().field_1697, "config");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return new File(dir, FILE_NAME);
    }

    public static void load() {
        if (loaded) {
            return;
        }
        loaded = true;
        try {
            File f = ClientConfig.getConfigFile();
            if (!f.exists()) {
                return;
            }
            String s = Files.readString(f.toPath());
            JsonObject o = (JsonObject)GSON.fromJson(s, JsonObject.class);
            pinnedGroups.clear();
            if (o.has("pinnedGroups") && o.get("pinnedGroups").isJsonArray()) {
                o.getAsJsonArray("pinnedGroups").forEach(e -> pinnedGroups.add(e.getAsString()));
            }
            if (o.has("chapterPanelPinned")) {
                chapterPanelPinned = o.get("chapterPanelPinned").getAsBoolean();
            }
            if (o.has("collapsedSections") && o.get("collapsedSections").isJsonArray()) {
                o.getAsJsonArray("collapsedSections").forEach(e -> collapsedSections.add(e.getAsString()));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void save() {
        try {
            JsonObject o = new JsonObject();
            JsonArray arr = new JsonArray();
            for (String g : pinnedGroups) {
                arr.add(g);
            }
            o.add("pinnedGroups", (JsonElement)arr);
            o.addProperty("chapterPanelPinned", Boolean.valueOf(chapterPanelPinned));
            JsonArray arr2 = new JsonArray();
            for (String s : collapsedSections) {
                arr2.add(s);
            }
            o.add("collapsedSections", (JsonElement)arr2);
            Files.writeString(ClientConfig.getConfigFile().toPath(), (CharSequence)GSON.toJson((JsonElement)o), new OpenOption[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Set<String> getPinnedGroups() {
        ClientConfig.load();
        return new HashSet<String>(pinnedGroups);
    }

    public static void togglePinned(String group) {
        ClientConfig.load();
        if (pinnedGroups.contains(group)) {
            pinnedGroups.remove(group);
        } else {
            pinnedGroups.add(group);
        }
        ClientConfig.save();
    }

    public static boolean isChapterPanelPinned() {
        ClientConfig.load();
        return chapterPanelPinned;
    }

    public static void toggleChapterPanelPinned() {
        ClientConfig.load();
        chapterPanelPinned = !chapterPanelPinned;
        ClientConfig.save();
    }

    public static Set<String> getCollapsedSections() {
        ClientConfig.load();
        return new HashSet<String>(collapsedSections);
    }

    public static void toggleSectionCollapsed(String sectionId) {
        ClientConfig.load();
        if (collapsedSections.contains(sectionId)) {
            collapsedSections.remove(sectionId);
        } else {
            collapsedSections.add(sectionId);
        }
        ClientConfig.save();
    }
}

