/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.events;

import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import org.texboobcat.questory.manager.QuestManager;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.network.ProgressSyncPacket;
import org.texboobcat.questory.quest.ItemRequirement;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;

public class QuestEvents {
    public static void onItemObtained(class_3222 player, class_1799 stack) {
        if (stack.method_7960()) {
            System.out.println("[Questory Debug] onItemObtained called with empty stack");
            return;
        }
        class_2960 itemId = class_7923.field_41178.method_10221((Object)stack.method_7909());
        System.out.println("[Questory Debug] onItemObtained: Player=" + player.method_5477().getString() + ", Item=" + String.valueOf(itemId) + ", Count=" + stack.method_7947());
        QuestManager.getInstance().trackItemProgress(player.method_5667(), itemId.toString(), stack.method_7947(), player);
    }

    public static void onItemCrafted(class_3222 player, class_1799 stack) {
        if (stack.method_7960()) {
            return;
        }
        class_2960 itemId = class_7923.field_41178.method_10221((Object)stack.method_7909());
        QuestManager.getInstance().trackCraftingProgress(player.method_5667(), itemId.toString(), stack.method_7947(), player);
        QuestEvents.onItemObtained(player, stack);
    }

    public static void onEntityKilled(class_3222 player, class_1309 entity) {
        class_2960 entityId = class_7923.field_41177.method_10221((Object)entity.method_5864());
        QuestManager.getInstance().trackEntityKillProgress(player.method_5667(), entityId.toString(), 1, player);
    }

    public static void onAdvancementEarned(class_3222 player, class_2960 advancementId) {
        QuestManager.getInstance().trackAdvancementProgress(player.method_5667(), advancementId.toString(), player);
    }

    public static void onPlayerDisconnect(class_3222 player) {
        QuestManager.getInstance().onPlayerDisconnect(player.method_5667());
    }

    public static void onPlayerJoin(class_3222 player) {
        QuestManager.getInstance().onPlayerJoin(player);
    }

    public static void onInventoryChanged(class_3222 player) {
        QuestManager manager = QuestManager.getInstance();
        QuestProgress progress = manager.getProgress(player.method_5667());
        boolean changed = false;
        for (Quest quest : manager.getAllQuests()) {
            if (progress.isQuestCompleted(quest.getId())) continue;
            for (Requirement req : quest.getRequirements()) {
                if (!(req instanceof ItemRequirement)) continue;
                ItemRequirement itemReq = (ItemRequirement)req;
                int invCount = QuestEvents.countItemInInventory(player, itemReq.getItem());
                int cap = Math.min(invCount, itemReq.getCount());
                if (!itemReq.shouldConsume()) {
                    int before = progress.getRequirementProgress(quest.getId(), req);
                    if (before == cap) continue;
                    progress.setRequirementProgress(quest.getId(), req, cap);
                    changed = true;
                    continue;
                }
                int existing = progress.getRequirementProgress(quest.getId(), req);
                if (cap <= existing) continue;
                progress.setRequirementProgress(quest.getId(), req, cap);
                changed = true;
            }
        }
        if (changed) {
            NetworkManager.sendToClient(player, new ProgressSyncPacket(progress));
        }
    }

    private static int countItemInInventory(class_3222 player, String itemIdString) {
        class_2960 itemId = new class_2960(itemIdString);
        class_1792 item = (class_1792)class_7923.field_41178.method_10223(itemId);
        if (item == null) {
            return 0;
        }
        int total = 0;
        for (class_1799 stack : player.method_31548().field_7547) {
            if (stack.method_7960() || stack.method_7909() != item) continue;
            total += stack.method_7947();
        }
        return total;
    }

    public static void onStatisticChanged(class_3222 player, String statistic, int value) {
        QuestManager.getInstance().trackStatisticProgress(player.method_5667(), statistic, value, player);
    }
}

