/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.importer;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import org.texboobcat.questory.quest.AdvancementRequirement;
import org.texboobcat.questory.quest.AdvancementReward;
import org.texboobcat.questory.quest.BiomeRequirement;
import org.texboobcat.questory.quest.ChapterData;
import org.texboobcat.questory.quest.ChapterImage;
import org.texboobcat.questory.quest.ChoiceReward;
import org.texboobcat.questory.quest.CommandRequirement;
import org.texboobcat.questory.quest.CommandReward;
import org.texboobcat.questory.quest.CraftingRequirement;
import org.texboobcat.questory.quest.CustomRequirement;
import org.texboobcat.questory.quest.DimensionRequirement;
import org.texboobcat.questory.quest.EnergyRequirement;
import org.texboobcat.questory.quest.EntityKillRequirement;
import org.texboobcat.questory.quest.FluidRequirement;
import org.texboobcat.questory.quest.GroupNode;
import org.texboobcat.questory.quest.ItemRequirement;
import org.texboobcat.questory.quest.ItemReward;
import org.texboobcat.questory.quest.LocationRequirement;
import org.texboobcat.questory.quest.LootReward;
import org.texboobcat.questory.quest.ObservationRequirement;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.quest.QuestLink;
import org.texboobcat.questory.quest.RandomReward;
import org.texboobcat.questory.quest.Requirement;
import org.texboobcat.questory.quest.Reward;
import org.texboobcat.questory.quest.StageRequirement;
import org.texboobcat.questory.quest.StageReward;
import org.texboobcat.questory.quest.StatisticRequirement;
import org.texboobcat.questory.quest.StructureRequirement;
import org.texboobcat.questory.quest.ToastReward;
import org.texboobcat.questory.quest.XpRequirement;
import org.texboobcat.questory.quest.XpReward;
import org.texboobcat.questory.storage.QuestStorage;
import org.texboobcat.questory.theme.QuestTheme;
import org.texboobcat.questory.theme.ThemeLoader;

public class FTBQuestImporter {
    private final Path ftbQuestsPath;
    private final QuestStorage questStorage;
    private final Map<String, Quest> convertedQuests;
    private final List<String> conversionLog;
    private final Map<String, String> idMapping;
    private final Map<String, List<String>> pendingDependencies;
    private String fallbackLocale = "en_us";
    private final Map<String, String> tQuestTitle = new HashMap<String, String>();
    private final Map<String, List<String>> tQuestDesc = new HashMap<String, List<String>>();
    private final Map<String, String> tChapterTitle = new HashMap<String, String>();
    private final Map<String, ChapterData> chapterDataMap = new HashMap<String, ChapterData>();

    public FTBQuestImporter(Path ftbQuestsPath, QuestStorage questStorage) {
        this.ftbQuestsPath = ftbQuestsPath;
        this.questStorage = questStorage;
        this.convertedQuests = new HashMap<String, Quest>();
        this.conversionLog = new ArrayList<String>();
        this.idMapping = new HashMap<String, String>();
        this.pendingDependencies = new HashMap<String, List<String>>();
    }

    private void importChapterGroups(Path chaptersPath) {
        try {
            Path cg = chaptersPath.resolve("chapter_groups.snbt");
            if (!Files.exists(cg, new LinkOption[0])) {
                this.log("No chapter_groups.snbt found");
                return;
            }
            String text = Files.readString(cg);
            GroupNode root = new GroupNode("root", "Root");
            class_2487 nbt = this.parseSNBT(text);
            if (!nbt.method_33133()) {
                class_2499 arr = null;
                if (nbt.method_10545("groups")) {
                    arr = nbt.method_10554("groups", 10);
                } else if (nbt.method_10545("chapter_groups")) {
                    arr = nbt.method_10554("chapter_groups", 10);
                }
                if (arr != null) {
                    for (class_2520 t : arr) {
                        class_2487 ct;
                        GroupNode child;
                        if (!(t instanceof class_2487) || (child = this.parseGroupNodeStrict(ct = (class_2487)t)) == null) continue;
                        root.getChildren().add(child);
                    }
                }
            }
            if (root.getChildren().isEmpty()) {
                this.parseGroupTreeLenient(text, root);
            }
            if (root.getChildren().isEmpty()) {
                TreeSet<String> groups = new TreeSet<String>();
                for (Quest q : this.convertedQuests.values()) {
                    if (q.getGroup() == null) continue;
                    groups.add(q.getGroup());
                }
                GroupNode all = new GroupNode("all_groups", "All Groups");
                for (String g : groups) {
                    all.getGroups().add(g);
                }
                root.getChildren().add(all);
            }
            this.questStorage.saveGroupTree(root);
            this.log("Saved chapter group tree with " + root.getChildren().size() + " top-level sections");
        }
        catch (Exception e) {
            this.log("Warning: failed to import chapter groups: " + e.getMessage());
        }
    }

    private GroupNode parseGroupNodeStrict(class_2487 ct) {
        class_2499 list;
        class_2520 tag;
        String title;
        String id;
        String string = id = ct.method_10545("id") ? ct.method_10558("id") : null;
        String string2 = ct.method_10545("title") ? ct.method_10558("title") : (title = id != null ? id : "");
        if (title.isEmpty()) {
            title = "Unnamed";
        }
        GroupNode node = new GroupNode(id == null ? FTBQuestImporter.slugify(title) : id, title);
        if (ct.method_10545("icon")) {
            node.setIcon(ct.method_10558("icon"));
        }
        if (ct.method_10545("color")) {
            node.setColor(ct.method_10558("color"));
        }
        if (ct.method_10545("order")) {
            node.setOrder(ct.method_10550("order"));
        }
        if (ct.method_10545("chapters") && (tag = ct.method_10580("chapters")) instanceof class_2499) {
            list = (class_2499)tag;
            for (class_2520 tt : list) {
                if (!(tt instanceof class_2519)) continue;
                class_2519 st = (class_2519)tt;
                node.getGroups().add(st.method_10714());
            }
        }
        if (ct.method_10545("children") && (tag = ct.method_10580("children")) instanceof class_2499) {
            list = (class_2499)tag;
            for (class_2520 tt : list) {
                class_2487 cct;
                GroupNode ch;
                if (!(tt instanceof class_2487) || (ch = this.parseGroupNodeStrict(cct = (class_2487)tt)) == null) continue;
                node.getChildren().add(ch);
            }
        }
        return node;
    }

    private void parseGroupTreeLenient(String text, GroupNode root) {
        int open;
        int i = text.indexOf(91);
        int j = text.lastIndexOf(93);
        if (i < 0 || j <= i) {
            return;
        }
        String arr = text.substring(i + 1, j);
        int pos = 0;
        int order = 0;
        while (pos < arr.length() && (open = arr.indexOf(123, pos)) >= 0) {
            String color;
            int brace = 0;
            int end = -1;
            boolean inStr = false;
            for (int p = open; p < arr.length(); ++p) {
                char c = arr.charAt(p);
                if (c == '\"') {
                    boolean bl = inStr = !inStr;
                }
                if (inStr) continue;
                if (c == '{') {
                    ++brace;
                    continue;
                }
                if (c != '}' || --brace != 0) continue;
                end = p;
                break;
            }
            if (end < 0) break;
            String obj = arr.substring(open, end + 1);
            Object title = FTBQuestImporter.matchGroup(obj, "(?i)\\btitle\\s*:\\s*\"([^\\\"]+)\"");
            if (title == null) {
                title = FTBQuestImporter.matchGroup(obj, "(?i)\\bname\\s*:\\s*\"([^\\\"]+)\"");
            }
            if (title == null) {
                title = "Section " + (order + 1);
            }
            GroupNode node = new GroupNode(FTBQuestImporter.slugify((String)title), (String)title);
            String icon = FTBQuestImporter.matchGroup(obj, "(?i)\\bicon\\s*:\\s*\"([^\\\"]+)\"");
            if (icon != null) {
                node.setIcon(icon);
            }
            if ((color = FTBQuestImporter.matchGroup(obj, "(?i)\\bcolor\\s*:\\s*(#[0-9A-Fa-f]{6,8}|0x[0-9A-Fa-f]{6,8})")) != null) {
                node.setColor(color);
            }
            node.setOrder(order++);
            String chBlock = FTBQuestImporter.matchGroup(obj, "(?is)\\bchapters\\s*:\\s*\\[(.*?)\\]");
            if (chBlock != null) {
                Matcher m = Pattern.compile("\"([^\\\"]+)\"").matcher(chBlock);
                while (m.find()) {
                    node.getGroups().add(m.group(1));
                }
            }
            root.getChildren().add(node);
            pos = end + 1;
        }
    }

    private static String slugify(String s) {
        return s == null ? "" : s.toLowerCase().replaceAll("[^a-z0-9]+", "_").replaceAll("^_|_$", "");
    }

    private void importChaptersFromSNBT(Path chaptersPath) throws IOException {
        try (Stream<Path> paths = Files.walk(chaptersPath, new FileVisitOption[0]);){
            paths.filter(p -> p.toString().endsWith(".snbt")).forEach(file -> {
                try {
                    List<ChapterImage> imgs;
                    String text = Files.readString(file);
                    class_2487 nbt = this.parseSNBT(text);
                    String chapterId = null;
                    String groupName = file.getFileName().toString().replace(".snbt", "");
                    if (!nbt.method_33133()) {
                        ChapterData cd;
                        String translated;
                        String string = chapterId = nbt.method_10545("id") ? nbt.method_10558("id") : null;
                        if (chapterId != null && (translated = (String)this.tChapterTitle.getOrDefault(chapterId, null)) != null && !translated.isBlank()) {
                            groupName = translated;
                        }
                        if ((cd = this.parseChapterData(nbt, chapterId, groupName)) != null && chapterId != null) {
                            this.chapterDataMap.merge(chapterId, cd, (a, b) -> {
                                a.getImages().addAll(b.getImages());
                                return a;
                            });
                            return;
                        }
                    }
                    if (!(imgs = this.parseImagesLenient(text)).isEmpty()) {
                        String header;
                        String cid = chapterId;
                        if (cid == null && (cid = FTBQuestImporter.matchGroup(header = text.substring(0, Math.max(0, Math.min(text.length(), 512))), "(?i)\\bid\\s*:\\s*\"([^\\\"]+)\"")) == null) {
                            cid = file.getFileName().toString().replace(".snbt", "");
                        }
                        String groupNameFinal = groupName;
                        ChapterData cd = this.chapterDataMap.computeIfAbsent(cid, k -> new ChapterData((String)k, groupNameFinal));
                        for (ChapterImage img : imgs) {
                            cd.addImage(img);
                        }
                    }
                }
                catch (Exception ex) {
                    this.log("  Warning: Failed reading chapter file " + String.valueOf(file.getFileName()) + ": " + ex.getMessage());
                }
            });
        }
    }

    private Quest convertQuestLenient(String text, String filename) {
        String depsBlock;
        String iconScale;
        String hideDependents;
        String hideDeps;
        String chapter;
        List<String> tDesc;
        String tTitle;
        String title;
        String ftbId = filename.replace(".snbt", "");
        String questoryId = "ftb_" + this.sanitizeId(ftbId);
        this.idMapping.put(ftbId, questoryId);
        if (ftbId.matches("[0-9]+")) {
            this.idMapping.put(ftbId + "L", questoryId);
        }
        if ((title = FTBQuestImporter.matchGroup(text, "(?i)\\btitle\\s*:\\s*\"([^\"]*)\"")) == null || title.isBlank()) {
            title = FTBQuestImporter.toTitle(ftbId);
        }
        String description = null;
        String descBlock = FTBQuestImporter.matchGroup(text, "(?is)\\bdescription\\s*:\\s*\\[(.*?)\\]");
        if (descBlock != null) {
            ArrayList<String> lines = new ArrayList<String>();
            Matcher m = Pattern.compile("\"([^\"]*)\"").matcher(descBlock);
            while (m.find()) {
                lines.add(m.group(1));
            }
            description = String.join((CharSequence)"\n", lines);
        }
        if (description == null) {
            description = FTBQuestImporter.matchGroup(text, "(?is)\\bdescription\\s*:\\s*\"([^\"]*)\"");
        }
        if (description == null) {
            description = "";
        }
        if ((tTitle = this.tQuestTitle.get(ftbId)) != null && !tTitle.isBlank()) {
            title = tTitle;
        }
        if ((tDesc = this.tQuestDesc.get(ftbId)) != null && !tDesc.isEmpty()) {
            description = String.join((CharSequence)"\n", tDesc);
        }
        Quest quest = new Quest(questoryId, title, description);
        String iconId = FTBQuestImporter.matchGroup(text, "(?is)\\bicon\\s*:\\s*\\{[^}]*?(?:id|item)\\s*:\\s*\"([^\"]+)\"[^}]*} ");
        if (iconId == null) {
            iconId = FTBQuestImporter.matchGroup(text, "(?i)(?:id|item)\\s*:\\s*\"([^\"]+)\"");
        }
        if (iconId != null) {
            quest.setIcon(iconId);
        }
        String xStr = FTBQuestImporter.matchGroup(text, "(?i)\\bx\\s*:\\s*([-\\d.]+)");
        String yStr = FTBQuestImporter.matchGroup(text, "(?i)\\by\\s*:\\s*([-\\d.]+)");
        if (xStr != null) {
            quest.setX((int)Math.round(Double.parseDouble(xStr)));
        }
        if (yStr != null) {
            quest.setY((int)Math.round(Double.parseDouble(yStr)));
        }
        if ((chapter = FTBQuestImporter.matchGroup(text, "(?i)\\bchapter\\s*:\\s*\"([^\"]+)\"")) != null) {
            quest.setGroup(chapter);
            quest.setChapterId(chapter);
        }
        if ((hideDeps = FTBQuestImporter.matchGroup(text, "(?i)\\bhide_dependency_lines\\s*:\\s*(true|false)")) != null) {
            quest.setHideDependencyLines(Boolean.parseBoolean(hideDeps));
        }
        if ((hideDependents = FTBQuestImporter.matchGroup(text, "(?i)\\bhide_dependent_lines\\s*:\\s*(true|false)")) != null) {
            quest.setHideDependentLines(Boolean.parseBoolean(hideDependents));
        }
        if ((iconScale = FTBQuestImporter.matchGroup(text, "(?i)\\bicon_scale\\s*:\\s*([-\\d.]+)")) != null) {
            try {
                quest.setIconScale(Double.parseDouble(iconScale));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((depsBlock = FTBQuestImporter.matchGroup(text, "(?is)\\bdependencies\\s*:\\s*\\[(.*?)\\]")) != null) {
            ArrayList<String> depIds = new ArrayList<String>();
            Matcher m = Pattern.compile("\"([^\"]+)\"").matcher(depsBlock);
            while (m.find()) {
                depIds.add(m.group(1));
            }
            if (!depIds.isEmpty()) {
                this.pendingDependencies.put(quest.getId(), depIds);
            }
        }
        return quest;
    }

    private static String matchGroup(String text, String regex) {
        Matcher m = Pattern.compile(regex).matcher(text);
        return m.find() ? m.group(1) : null;
    }

    private static String toTitle(String id) {
        String[] parts = id.replace('-', '_').split("_");
        StringBuilder sb = new StringBuilder();
        for (String p : parts) {
            if (p.isEmpty()) continue;
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(Character.toUpperCase(p.charAt(0))).append(p.substring(1).toLowerCase());
        }
        return sb.toString();
    }

    public ImportResult importFromFTBQuests() {
        this.conversionLog.clear();
        this.convertedQuests.clear();
        this.idMapping.clear();
        this.pendingDependencies.clear();
        this.log("Starting FTB Quests import from: " + String.valueOf(this.ftbQuestsPath));
        if (!Files.exists(this.ftbQuestsPath, new LinkOption[0])) {
            this.log("ERROR: FTB Quests path does not exist!");
            return new ImportResult(false, 0, this.conversionLog);
        }
        try {
            this.log("Reading FTB Quests theme lines...");
            List<String> themeLines = ThemeLoader.loadThemeLinesFromFTBQuests(this.ftbQuestsPath);
            if (themeLines == null) {
                this.log("No theme file found at standard locations; will use default theme unless a resource-pack provides one");
            } else {
                this.log("Theme lines loaded (" + themeLines.size() + ") - will apply after import with ID remapping");
            }
            Path chaptersPath = this.ftbQuestsPath.resolve("chapters");
            Path questsPath = this.ftbQuestsPath.resolve("quests");
            if (!Files.exists(chaptersPath, new LinkOption[0]) && !Files.exists(questsPath, new LinkOption[0])) {
                this.log("ERROR: No chapters or quests folder found!");
                return new ImportResult(false, 0, this.conversionLog);
            }
            if (Files.exists(questsPath, new LinkOption[0])) {
                this.importFromSNBT(questsPath);
            }
            if (Files.exists(chaptersPath, new LinkOption[0])) {
                this.importChaptersFromSNBT(chaptersPath);
                this.importChapterGroups(chaptersPath);
            }
            for (Quest quest : this.convertedQuests.values()) {
                this.questStorage.saveQuest(quest);
            }
            if (!this.chapterDataMap.isEmpty()) {
                this.questStorage.saveAllChapters(this.chapterDataMap.values());
                int chapters = this.chapterDataMap.size();
                int totalImages = this.chapterDataMap.values().stream().mapToInt(cd -> cd.getImages().size()).sum();
                this.log("Saved chapter metadata: " + chapters + " chapters, " + totalImages + " images");
            } else {
                this.log("No chapter metadata detected (images/links)");
            }
            if (themeLines != null && !themeLines.isEmpty()) {
                this.log("Applying FTB Quests theme with ID remapping...");
                HashSet<String> chapterIds = new HashSet<String>(this.chapterDataMap.keySet());
                for (Quest q : this.convertedQuests.values()) {
                    if (q.getChapterId() == null) continue;
                    chapterIds.add(q.getChapterId());
                }
                QuestTheme remappedTheme = ThemeLoader.parseTheme(themeLines, this.idMapping, chapterIds);
                this.log("Theme applied: selectors=" + remappedTheme.selectors.size());
            } else {
                QuestTheme fallback;
                this.log("No external theme to apply, attempting classpath fallback...");
                QuestTheme.instance = fallback = ThemeLoader.loadFromFTBQuests(this.ftbQuestsPath);
                this.log("Fallback theme active");
            }
            this.log("Import completed successfully!");
            this.log("Converted " + this.convertedQuests.size() + " quests");
            return new ImportResult(true, this.convertedQuests.size(), this.conversionLog);
        }
        catch (Exception e) {
            this.log("ERROR: " + e.getMessage());
            e.printStackTrace();
            return new ImportResult(false, 0, this.conversionLog);
        }
    }

    private void autoLayoutMissingPositions() {
        HashMap<String, List> byGroup = new HashMap<String, List>();
        for (Quest q2 : this.convertedQuests.values()) {
            byGroup.computeIfAbsent(q2.getGroup(), k -> new ArrayList()).add(q2);
        }
        int spacing = 45;
        int cols = 8;
        for (Map.Entry entry : byGroup.entrySet()) {
            List list = (List)entry.getValue();
            int i = 0;
            for (Quest q3 : list) {
                if (q3.getX() == 0 && q3.getY() == 0) {
                    int row = i / cols;
                    int col = i % cols;
                    q3.setX(col * spacing);
                    q3.setY(row * spacing);
                }
                ++i;
            }
        }
        this.log("Auto-laid out " + this.convertedQuests.values().stream().filter(q -> q.getX() != 0 || q.getY() != 0).count() + " quests with positions");
    }

    private void importFromSNBT(Path questsPath) throws IOException {
        this.log("Importing from SNBT files...");
        this.loadTranslations(questsPath);
        try (Stream<Path> paths = Files.walk(questsPath, new FileVisitOption[0]);){
            paths.filter(path -> path.toString().endsWith(".snbt")).forEach(this::importQuestFromSNBT);
        }
        this.resolveDependencies();
        this.autoLayoutMissingPositions();
    }

    private void importQuestFromSNBT(Path file) {
        try {
            boolean looksLikeQuest;
            this.log("Processing: " + String.valueOf(file.getFileName()));
            String content = Files.readString(file);
            String lower = content.toLowerCase();
            boolean bl = looksLikeQuest = lower.contains("quests:") || lower.contains("tasks:") || lower.contains("rewards:") || lower.contains("x:") || lower.contains("chapter:");
            if (!looksLikeQuest) {
                this.log("    Skipping non-quest file");
                return;
            }
            class_2487 nbt = this.parseSNBT(content);
            if (!nbt.method_33133() && nbt.method_10545("quests")) {
                class_2499 list;
                ChapterData chapterData;
                String chapterId = nbt.method_10545("id") ? nbt.method_10558("id") : null;
                String groupName = null;
                if (chapterId != null) {
                    groupName = this.tChapterTitle.getOrDefault(chapterId, null);
                }
                if (groupName == null || groupName.isBlank()) {
                    groupName = file.getFileName().toString().replace(".snbt", "");
                }
                if ((chapterData = this.parseChapterData(nbt, chapterId, groupName)) != null && chapterId != null) {
                    this.chapterDataMap.put(chapterId, chapterData);
                }
                if (!(list = nbt.method_10554("quests", 10)).isEmpty()) {
                    for (class_2520 tag : list) {
                        class_2487 qt;
                        Quest q;
                        if (!(tag instanceof class_2487) || (q = this.convertQuest(qt = (class_2487)tag, file.getFileName().toString())) == null) continue;
                        q.setGroup(groupName);
                        if (chapterId != null) {
                            q.setChapterId(chapterId);
                        }
                        if (chapterData != null) {
                            this.applyChapterDefaults(q, chapterData);
                        }
                        this.convertedQuests.put(q.getId(), q);
                    }
                    this.log("  Converted chapter with " + list.size() + " quests");
                    return;
                }
            }
            if (lower.contains("quests:")) {
                int converted = this.importChapterLenient(content, file.getFileName().toString());
                this.log("  Converted chapter(lenient) with " + converted + " quests");
            } else {
                Quest quest;
                if (nbt.method_33133()) {
                    quest = this.convertQuestLenient(content, file.getFileName().toString());
                    if (quest != null) {
                        this.log("    Used lenient parser for " + String.valueOf(file.getFileName()));
                    }
                } else {
                    quest = this.convertQuest(nbt, file.getFileName().toString());
                }
                if (quest != null) {
                    this.convertedQuests.put(quest.getId(), quest);
                    this.log("  Converted: " + quest.getTitle() + " (" + quest.getId() + ")");
                }
            }
        }
        catch (Exception e) {
            this.log("  ERROR processing " + String.valueOf(file.getFileName()) + ": " + e.getMessage());
        }
    }

    private int importChapterLenient(String text, String filename) {
        int open;
        Object group;
        int idx = text.toLowerCase().indexOf("quests:");
        String chapterIdHeader = null;
        if (idx > 0) {
            Object chTitle;
            String translated;
            String chId;
            String chapterHeader = text.substring(0, idx);
            chapterIdHeader = chId = FTBQuestImporter.matchGroup(chapterHeader, "(?i)\\bid\\s*:\\s*\"([^\\\"]+)\"");
            String string = translated = chId != null ? (String)this.tChapterTitle.getOrDefault(chId, null) : null;
            group = translated != null && !translated.isBlank() ? translated : ((chTitle = FTBQuestImporter.matchGroup(chapterHeader, "(?i)\\btitle\\s*:\\s*\"([^\\\"]+)\"")) != null ? (chTitle = ((String)chTitle).replaceAll("&[0-9a-fk-or]", "")) : filename.replace(".snbt", ""));
        } else {
            group = filename.replace(".snbt", "");
        }
        try {
            List<ChapterImage> images = this.parseImagesLenient(text);
            if (!images.isEmpty()) {
                String chIdForMap = chapterIdHeader != null ? chapterIdHeader : filename.replace(".snbt", "");
                ChapterData cd = new ChapterData(chIdForMap, (String)group);
                for (ChapterImage img : images) {
                    cd.addImage(img);
                }
                this.chapterDataMap.put(chIdForMap, cd);
            }
        }
        catch (Exception ex) {
            this.log("    Warning: Failed to parse chapter images leniently: " + ex.getMessage());
        }
        idx = text.toLowerCase().indexOf("quests:");
        if (idx < 0) {
            return 0;
        }
        int lb = text.indexOf(91, idx);
        if (lb < 0) {
            return 0;
        }
        int depth = 0;
        int rb = -1;
        for (int i = lb; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '[') {
                ++depth;
                continue;
            }
            if (c != ']' || --depth != 0) continue;
            rb = i;
            break;
        }
        if (rb < 0) {
            return 0;
        }
        String list = text.substring(lb + 1, rb);
        int pos = 0;
        int converted = 0;
        int questIndex = 0;
        while (pos < list.length() && (open = list.indexOf(123, pos)) >= 0) {
            String rewardsList;
            String tasksList;
            String tagsBlk;
            Matcher m;
            String depsBlk;
            String iconScale;
            String hideDependents;
            String hideDeps;
            String first;
            String tagItems;
            String iconObj;
            String iconId;
            String itemMatch;
            String subtitle;
            int brace = 0;
            int end = -1;
            boolean inStr = false;
            for (int i = open; i < list.length(); ++i) {
                char c = list.charAt(i);
                if (c == '\"') {
                    boolean bl = inStr = !inStr;
                }
                if (inStr) continue;
                if (c == '{') {
                    ++brace;
                    continue;
                }
                if (c != '}' || --brace != 0) continue;
                end = i;
                break;
            }
            if (end < 0) break;
            String block = list.substring(open, end + 1);
            String rawId = FTBQuestImporter.matchGroup(block, "(?i)\\bid\\s*:\\s*\"([^\\\"]+)\"");
            if (rawId == null) {
                rawId = FTBQuestImporter.matchGroup(block, "(?i)\\bid\\s*:\\s*([0-9]+)L?");
            }
            String questoryId = rawId != null && rawId.matches("[0-9]+") ? "ftb_" + rawId : (rawId != null ? "ftb_" + this.sanitizeId(rawId) : "ftb_" + this.sanitizeId((String)group) + "_" + questIndex);
            String title = null;
            int lastArrayClose = Math.max(block.lastIndexOf("tasks:"), block.lastIndexOf("rewards:"));
            if (lastArrayClose > 0) {
                int bracketDepth = 0;
                int searchStart = lastArrayClose;
                int arrayEnd = -1;
                for (int i = searchStart; i < block.length(); ++i) {
                    char c = block.charAt(i);
                    if (c == '[') {
                        ++bracketDepth;
                        continue;
                    }
                    if (c != ']' || --bracketDepth != 0) continue;
                    arrayEnd = i;
                    break;
                }
                if (arrayEnd > 0) {
                    String afterArrays = block.substring(arrayEnd);
                    title = FTBQuestImporter.matchGroup(afterArrays, "(?i)\\btitle\\s*:\\s*\"([^\\\"]*)\"");
                }
            }
            if (title == null || title.isBlank()) {
                title = FTBQuestImporter.matchGroup(block, "(?i)\\btitle\\s*:\\s*\"([^\\\"]*)\"");
            }
            if (title != null) {
                title = title.replaceAll("&[0-9a-fk-or]", "");
            }
            if (!(title != null && !title.isBlank() || (subtitle = FTBQuestImporter.matchGroup(block, "(?i)\\bsubtitle\\s*:\\s*\"([^\\\"]*)\"")) == null || subtitle.isBlank() || (subtitle = subtitle.replaceAll("&[0-9a-fk-or]", "")).matches("(?i).*click to read.*") || subtitle.matches("(?i).*read (the )?description.*") || subtitle.length() > 50)) {
                title = subtitle;
            }
            if ((title == null || title.isBlank()) && (itemMatch = FTBQuestImporter.matchGroup(block, "(?i)\\bitem\\s*:\\s*\"([^\\\"]+)\"")) != null) {
                String itemName = itemMatch.contains(":") ? itemMatch.split(":")[1] : itemMatch;
                title = FTBQuestImporter.toTitle(itemName);
            }
            if (title == null || title.isBlank()) {
                title = FTBQuestImporter.toTitle(questoryId);
            }
            Object description = null;
            String descBlk = FTBQuestImporter.matchGroup(block, "(?is)\\bdescription\\s*:\\s*\\[(.*?)\\]");
            if (descBlk != null) {
                ArrayList<String> lines = new ArrayList<String>();
                Matcher m2 = Pattern.compile("\"([^\\\"]*)\"").matcher(descBlk);
                while (m2.find()) {
                    lines.add(m2.group(1));
                }
                description = String.join((CharSequence)"\n", lines);
            }
            if (description == null) {
                description = FTBQuestImporter.matchGroup(block, "(?is)\\bdescription\\s*:\\s*\"([^\\\"]*)\"");
            }
            String subtitle2 = FTBQuestImporter.matchGroup(block, "(?is)\\bsubtitle\\s*:\\s*\"([^\\\"]*)\"");
            if (description == null) {
                description = subtitle2;
            } else if (subtitle2 != null && !subtitle2.isBlank()) {
                description = (String)description + "\n" + subtitle2;
            }
            if (description == null) {
                description = "";
            }
            if (rawId != null) {
                List<String> dl;
                String tt = this.tQuestTitle.get(rawId);
                if (tt != null && !tt.isBlank()) {
                    title = tt;
                }
                if ((dl = this.tQuestDesc.get(rawId)) != null && !dl.isEmpty()) {
                    description = String.join((CharSequence)"\n", dl);
                }
            }
            Quest q = new Quest(questoryId, title, (String)description);
            q.setGroup((String)group);
            if (chapterIdHeader != null) {
                q.setChapterId(chapterIdHeader);
            }
            if ((iconId = FTBQuestImporter.matchGroup(block, "(?i)\\bicon\\s*:\\s*\"([^\\\"]+)\"")) == null && (iconObj = FTBQuestImporter.matchGroup(block, "(?is)\\bicon\\s*:\\s*\\{(.*?)\\}")) != null && (iconId = FTBQuestImporter.matchGroup(iconObj, "(?i)(?:id|item)\\s*:\\s*\"([^\\\"]+)\"")) == null && (tagItems = FTBQuestImporter.matchGroup(iconObj, "(?is)\\btags?\\s*:\\s*\\{.*?items\\s*:\\s*\\[(.*?)\\]")) != null && (first = FTBQuestImporter.matchGroup(tagItems, "(?i)\\bid\\s*:\\s*\"([^\\\"]+)\"")) != null) {
                iconId = first;
            }
            if (iconId != null) {
                q.setIcon(iconId);
            }
            String xStr = FTBQuestImporter.matchGroup(block, "(?i)\\bx\\s*:\\s*([-\\d.]+)");
            String yStr = FTBQuestImporter.matchGroup(block, "(?i)\\by\\s*:\\s*([-\\d.]+)");
            if (xStr != null) {
                try {
                    double vx = Double.parseDouble(xStr);
                    q.setX((int)Math.round(vx * 45.0));
                }
                catch (Exception vx) {
                    // empty catch block
                }
            }
            if (yStr != null) {
                try {
                    double vy = Double.parseDouble(yStr);
                    q.setY((int)Math.round(vy * 45.0));
                }
                catch (Exception vy) {
                    // empty catch block
                }
            }
            if ((hideDeps = FTBQuestImporter.matchGroup(block, "(?i)\\bhide_dependency_lines\\s*:\\s*(true|false)")) != null) {
                q.setHideDependencyLines(Boolean.parseBoolean(hideDeps));
            }
            if ((hideDependents = FTBQuestImporter.matchGroup(block, "(?i)\\bhide_dependent_lines\\s*:\\s*(true|false)")) != null) {
                q.setHideDependentLines(Boolean.parseBoolean(hideDependents));
            }
            if ((iconScale = FTBQuestImporter.matchGroup(block, "(?i)\\bicon_scale\\s*:\\s*([-\\d.]+)")) != null) {
                try {
                    q.setIconScale(Double.parseDouble(iconScale));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.convertedQuests.put(q.getId(), q);
            if (rawId != null) {
                this.idMapping.put(rawId, q.getId());
                if (rawId.matches("[0-9]+")) {
                    this.idMapping.put(rawId + "L", q.getId());
                }
            }
            if ((depsBlk = FTBQuestImporter.matchGroup(block, "(?is)\\bdependencies\\s*:\\s*\\[(.*?)\\]")) != null) {
                ArrayList<String> depIds = new ArrayList<String>();
                m = Pattern.compile("\"([^\\\"]+)\"|([0-9]+)L?").matcher(depsBlk);
                while (m.find()) {
                    String s = m.group(1) != null ? m.group(1) : m.group(2);
                    depIds.add(s);
                }
                if (!depIds.isEmpty()) {
                    this.pendingDependencies.put(q.getId(), depIds);
                }
            }
            if ((tagsBlk = FTBQuestImporter.matchGroup(block, "(?is)\\btags\\s*:\\s*\\[(.*?)\\]")) != null) {
                m = Pattern.compile("\"([^\\\"]+)\"").matcher(tagsBlk);
                while (m.find()) {
                    q.addTag(m.group(1));
                }
            }
            if ((tasksList = FTBQuestImporter.matchGroup(block, "(?is)\\btasks\\s*:\\s*\\[(.*?)\\]")) != null) {
                int to;
                int tp = 0;
                while (tp < tasksList.length() && (to = tasksList.indexOf(123, tp)) >= 0) {
                    int b = 0;
                    int te = -1;
                    boolean ins = false;
                    for (int i = to; i < tasksList.length(); ++i) {
                        char c = tasksList.charAt(i);
                        if (c == '\"') {
                            boolean bl = ins = !ins;
                        }
                        if (ins) continue;
                        if (c == '{') {
                            ++b;
                            continue;
                        }
                        if (c != '}' || --b != 0) continue;
                        te = i;
                        break;
                    }
                    if (te < 0) break;
                    String task = tasksList.substring(to, te + 1);
                    String type = FTBQuestImporter.matchGroup(task, "(?i)\\btype\\s*:\\s*\"([^\\\"]+)\"");
                    if (type != null) {
                        switch (type.toLowerCase()) {
                            case "item": 
                            case "ftbquests:item": {
                                String first2;
                                String itemsArr;
                                String itemObj;
                                String itemStr = FTBQuestImporter.matchGroup(task, "(?i)\\bitem\\s*:\\s*\"([^\\\"]+)\"");
                                if (itemStr == null && (itemObj = FTBQuestImporter.matchGroup(task, "(?is)\\bitem\\s*:\\s*\\{(.*?)\\}")) != null && (itemStr = FTBQuestImporter.matchGroup(itemObj, "(?i)\\bid\\s*:\\s*\"([^\\\"]+)\"")) == null && (itemsArr = FTBQuestImporter.matchGroup(itemObj, "(?is)\\bitems\\s*:\\s*\\[(.*?)\\]")) != null && (first2 = FTBQuestImporter.matchGroup(itemsArr, "(?i)\\bid\\s*:\\s*\"([^\\\"]+)\"")) != null) {
                                    itemStr = first2;
                                }
                                if (itemStr == null) break;
                                ItemRequirement req = new ItemRequirement(itemStr, 1);
                                q.addRequirement(req);
                                break;
                            }
                            case "checkmark": 
                            case "ftbquests:checkmark": {
                                String t = FTBQuestImporter.matchGroup(task, "(?i)\\btitle\\s*:\\s*\"([^\\\"]*)\"");
                                String rid = this.sanitizeId((String)(t == null || t.isBlank() ? q.getId() + "_check" : t));
                                CommandRequirement req = new CommandRequirement(rid, t == null ? "Manual" : t);
                                q.addRequirement(req);
                                break;
                            }
                            case "advancement": 
                            case "ftbquests:advancement": {
                                String adv = FTBQuestImporter.matchGroup(task, "(?i)\\badvancement\\s*:\\s*\"([^\\\"]+)\"");
                                if (adv == null) break;
                                q.addRequirement(new AdvancementRequirement(adv));
                                break;
                            }
                            case "kill": 
                            case "ftbquests:kill": {
                                String ent = FTBQuestImporter.matchGroup(task, "(?i)\\bentity\\s*:\\s*\"([^\\\"]+)\"");
                                if (ent == null) break;
                                q.addRequirement(new EntityKillRequirement(ent, 1));
                            }
                        }
                    }
                    tp = te + 1;
                }
            }
            if ((rewardsList = FTBQuestImporter.matchGroup(block, "(?is)\\brewards\\s*:\\s*\\[(.*?)\\]")) != null) {
                int ro;
                int rp = 0;
                while (rp < rewardsList.length() && (ro = rewardsList.indexOf(123, rp)) >= 0) {
                    int b = 0;
                    int re = -1;
                    boolean ins = false;
                    for (int i = ro; i < rewardsList.length(); ++i) {
                        char c = rewardsList.charAt(i);
                        if (c == '\"') {
                            boolean bl = ins = !ins;
                        }
                        if (ins) continue;
                        if (c == '{') {
                            ++b;
                            continue;
                        }
                        if (c != '}' || --b != 0) continue;
                        re = i;
                        break;
                    }
                    if (re < 0) break;
                    String reward = rewardsList.substring(ro, re + 1);
                    String type = FTBQuestImporter.matchGroup(reward, "(?i)\\btype\\s*:\\s*\"([^\\\"]+)\"");
                    if (type != null) {
                        switch (type.toLowerCase()) {
                            case "xp": 
                            case "ftbquests:xp": {
                                String xp = FTBQuestImporter.matchGroup(reward, "(?i)\\bxp\\s*:\\s*([0-9]+)");
                                int amt = xp != null ? Integer.parseInt(xp) : 0;
                                q.addReward(new XpReward(amt, false));
                                break;
                            }
                            case "xp_levels": 
                            case "ftbquests:xp_levels": {
                                String lv = FTBQuestImporter.matchGroup(reward, "(?i)\\bxp_levels\\s*:\\s*([0-9]+)");
                                int amt = lv != null ? Integer.parseInt(lv) : 1;
                                q.addReward(new XpReward(amt, true));
                                break;
                            }
                            case "item": 
                            case "ftbquests:item": {
                                String countStr;
                                int count;
                                String itemObj;
                                String itemStr = FTBQuestImporter.matchGroup(reward, "(?i)\\bitem\\s*:\\s*\"([^\\\"]+)\"");
                                if (itemStr == null && (itemObj = FTBQuestImporter.matchGroup(reward, "(?is)\\bitem\\s*:\\s*\\{(.*?)\\}")) != null) {
                                    itemStr = FTBQuestImporter.matchGroup(itemObj, "(?i)\\bid\\s*:\\s*\"([^\\\"]+)\"");
                                }
                                int n = count = (countStr = FTBQuestImporter.matchGroup(reward, "(?i)\\bcount\\s*:\\s*([0-9]+)")) != null ? Integer.parseInt(countStr) : 1;
                                if (itemStr == null) break;
                                q.addReward(new ItemReward(itemStr, count));
                            }
                        }
                    }
                    rp = re + 1;
                }
            }
            ++questIndex;
            ++converted;
            pos = end + 1;
        }
        return converted;
    }

    private List<ChapterImage> parseImagesLenient(String text) {
        int open;
        ArrayList<ChapterImage> out = new ArrayList<ChapterImage>();
        int i = text.toLowerCase().indexOf("images:");
        if (i < 0) {
            return out;
        }
        int lb = text.indexOf(91, i);
        if (lb < 0) {
            return out;
        }
        int depth = 0;
        int rb = -1;
        boolean inStr = false;
        for (int p = lb; p < text.length(); ++p) {
            char c = text.charAt(p);
            if (c == '\"') {
                boolean bl = inStr = !inStr;
            }
            if (inStr) continue;
            if (c == '[') {
                ++depth;
                continue;
            }
            if (c != ']' || --depth != 0) continue;
            rb = p;
            break;
        }
        if (rb < 0) {
            return out;
        }
        String list = text.substring(lb + 1, rb);
        int pos = 0;
        while (pos < list.length() && (open = list.indexOf(123, pos)) >= 0) {
            int brace = 0;
            int end = -1;
            boolean inS = false;
            for (int p = open; p < list.length(); ++p) {
                char c = list.charAt(p);
                if (c == '\"') {
                    boolean bl = inS = !inS;
                }
                if (inS) continue;
                if (c == '{') {
                    ++brace;
                    continue;
                }
                if (c != '}' || --brace != 0) continue;
                end = p;
                break;
            }
            if (end < 0) break;
            String obj = list.substring(open, end + 1);
            String imageUrl = FTBQuestImporter.matchGroup(obj, "(?i)\\bimage\\s*:\\s*\"([^\\\"]+)\"");
            if (imageUrl == null) {
                imageUrl = FTBQuestImporter.matchGroup(obj, "(?i)\\bimage\\s*:\\s*'([^']+)'");
            }
            if (imageUrl == null) {
                imageUrl = FTBQuestImporter.matchGroup(obj, "(?i)\\btexture\\s*:\\s*\"([^\\\"]+)\"");
            }
            if (imageUrl == null) {
                imageUrl = FTBQuestImporter.matchGroup(obj, "(?i)\\btexture\\s*:\\s*'([^']+)'");
            }
            if (imageUrl == null) {
                imageUrl = FTBQuestImporter.matchGroup(obj, "(?i)\\burl\\s*:\\s*\"([^\\\"]+)\"");
            }
            if (imageUrl == null) {
                imageUrl = FTBQuestImporter.matchGroup(obj, "(?i)\\burl\\s*:\\s*'([^']+)'");
            }
            if (imageUrl == null) {
                imageUrl = FTBQuestImporter.matchGroup(obj, "(?i)\\bfile\\s*:\\s*\"([^\\\"]+)\"");
            }
            if (imageUrl == null) {
                imageUrl = FTBQuestImporter.matchGroup(obj, "(?i)\\bfile\\s*:\\s*'([^']+)'");
            }
            String xStr = FTBQuestImporter.matchGroup(obj, "(?i)\\bx\\s*:\\s*([+-]?(?:\\d+\\.\\d+|\\d+))");
            String yStr = FTBQuestImporter.matchGroup(obj, "(?i)\\by\\s*:\\s*([+-]?(?:\\d+\\.\\d+|\\d+))");
            String wStr = FTBQuestImporter.matchGroup(obj, "(?i)\\bwidth\\s*:\\s*([+-]?(?:\\d+\\.\\d+|\\d+))");
            String hStr = FTBQuestImporter.matchGroup(obj, "(?i)\\bheight\\s*:\\s*([+-]?(?:\\d+\\.\\d+|\\d+))");
            String rotStr = FTBQuestImporter.matchGroup(obj, "(?i)\\brotation\\s*:\\s*([+-]?(?:\\d+\\.\\d+|\\d+))");
            String colorStr = FTBQuestImporter.matchGroup(obj, "(?i)\\bcolor\\s*:\\s*(#[0-9A-Fa-f]{6,8}|0x[0-9A-Fa-f]{6,8}|[0-9]+)");
            String alphaStr = FTBQuestImporter.matchGroup(obj, "(?i)\\balpha\\s*:\\s*([0-9]{1,3})");
            String orderStr = FTBQuestImporter.matchGroup(obj, "(?i)\\border\\s*:\\s*([0-9]+)");
            String cornerStr = FTBQuestImporter.matchGroup(obj, "(?i)\\bcorner\\s*:\\s*(true|false)");
            String depStr = FTBQuestImporter.matchGroup(obj, "(?i)\\bdependency\\s*:\\s*\"([^\\\"]+)\"");
            if (depStr == null) {
                depStr = FTBQuestImporter.matchGroup(obj, "(?i)\\bdependency\\s*:\\s*'([^']+)'");
            }
            if (imageUrl != null) {
                double x = xStr != null ? Double.parseDouble(xStr) : 0.0;
                double y = yStr != null ? Double.parseDouble(yStr) : 0.0;
                double w = wStr != null ? Double.parseDouble(wStr) : 1.0;
                double h = hStr != null ? Double.parseDouble(hStr) : 1.0;
                int px = (int)Math.round(x * 45.0);
                int py = (int)Math.round(y * 45.0);
                ChapterImage img = new ChapterImage(px, py, w, h, imageUrl);
                if (rotStr != null) {
                    img.setRotation(Double.parseDouble(rotStr));
                }
                if (colorStr != null) {
                    if (colorStr.startsWith("#")) {
                        img.setColor(colorStr);
                    } else if (colorStr.startsWith("0x") || colorStr.startsWith("0X")) {
                        img.setColor("#" + colorStr.substring(2));
                    } else {
                        try {
                            int ci = Integer.parseInt(colorStr);
                            img.setColor(String.format("#%06X", ci & 0xFFFFFF));
                        }
                        catch (Exception ci) {
                            // empty catch block
                        }
                    }
                }
                if (alphaStr != null) {
                    try {
                        img.setAlpha(Integer.parseInt(alphaStr));
                    }
                    catch (Exception ci) {
                        // empty catch block
                    }
                }
                if (orderStr != null) {
                    try {
                        img.setOrder(Integer.parseInt(orderStr));
                    }
                    catch (Exception ci) {
                        // empty catch block
                    }
                }
                if (cornerStr != null) {
                    img.setAlignToCorner(Boolean.parseBoolean(cornerStr));
                }
                if (depStr != null) {
                    String mapped = this.idMapping.getOrDefault(depStr, depStr);
                    img.setDependencyQuestId(mapped);
                }
                out.add(img);
            }
            pos = end + 1;
        }
        return out;
    }

    private Quest convertQuest(class_2487 nbt, String filename) {
        List<String> tDesc;
        String tTitle;
        String ftbId = nbt.method_10545("id") ? nbt.method_10558("id") : filename.replace(".snbt", "");
        String questoryId = "ftb_" + this.sanitizeId(ftbId);
        this.idMapping.put(ftbId, questoryId);
        if (ftbId.matches("[0-9]+")) {
            this.idMapping.put(ftbId + "L", questoryId);
        }
        String title = nbt.method_10545("title") ? nbt.method_10558("title") : "Untitled Quest";
        String description = "";
        if (nbt.method_10545("description")) {
            class_2520 class_25202 = nbt.method_10580("description");
            if (class_25202 instanceof class_2499) {
                class_2499 descList = (class_2499)class_25202;
                StringBuilder sb = new StringBuilder();
                for (class_2520 tag : descList) {
                    sb.append(tag.method_10714()).append("\n");
                }
                description = sb.toString().trim();
            } else {
                description = nbt.method_10558("description");
            }
        }
        if ((tTitle = this.tQuestTitle.get(ftbId)) != null && !tTitle.isBlank()) {
            title = tTitle;
        }
        if ((tDesc = this.tQuestDesc.get(ftbId)) != null && !tDesc.isEmpty()) {
            description = String.join((CharSequence)"\n", tDesc);
        }
        Quest quest = new Quest(questoryId, title, description);
        if (nbt.method_10545("icon")) {
            String icon = this.extractIcon(nbt.method_10562("icon"));
            quest.setIcon(icon);
        }
        if (nbt.method_10545("x")) {
            double vx = nbt.method_10574("x");
            quest.setX((int)Math.round(vx * 45.0));
        }
        if (nbt.method_10545("y")) {
            double vy = nbt.method_10574("y");
            quest.setY((int)Math.round(vy * 45.0));
        }
        if (nbt.method_10545("chapter")) {
            String ch = nbt.method_10558("chapter");
            quest.setGroup(ch);
            quest.setChapterId(ch);
        }
        if (nbt.method_10545("hide_until_deps_complete") || nbt.method_10545("hide_until_deps_visible")) {
            quest.setHidden(true);
        }
        if (nbt.method_10545("hide_dependency_lines")) {
            quest.setHideDependencyLines(nbt.method_10577("hide_dependency_lines"));
        }
        if (nbt.method_10545("hide_dependent_lines")) {
            quest.setHideDependentLines(nbt.method_10577("hide_dependent_lines"));
        }
        if (nbt.method_10545("icon_scale")) {
            try {
                quest.setIconScale(nbt.method_10574("icon_scale"));
            }
            catch (Exception ch) {
                // empty catch block
            }
        }
        if (nbt.method_10545("shape")) {
            quest.setShape(nbt.method_10558("shape"));
        }
        if (nbt.method_10545("size")) {
            quest.setSize(nbt.method_10574("size"));
        }
        if (nbt.method_10545("optional")) {
            quest.setOptional(nbt.method_10577("optional"));
        }
        if (nbt.method_10545("min_width")) {
            quest.setMinWidth(nbt.method_10550("min_width"));
        }
        if (nbt.method_10545("can_repeat")) {
            quest.setCanRepeat(this.parseTristate(nbt.method_10580("can_repeat")));
        }
        if (nbt.method_10545("dependency_requirement")) {
            quest.setDependencyRequirement(nbt.method_10558("dependency_requirement"));
        }
        if (nbt.method_10545("min_required_dependencies")) {
            quest.setMinRequiredDependencies(nbt.method_10550("min_required_dependencies"));
        }
        if (nbt.method_10545("max_completable_deps")) {
            quest.setMaxCompletableDeps(nbt.method_10550("max_completable_deps"));
        }
        if (nbt.method_10545("progression_mode")) {
            quest.setProgressionMode(nbt.method_10558("progression_mode"));
        }
        if (nbt.method_10545("require_sequential_tasks")) {
            quest.setRequireSequentialTasks(this.parseTristate(nbt.method_10580("require_sequential_tasks")));
        }
        if (nbt.method_10545("invisible_until_completed")) {
            quest.setInvisibleUntilCompleted(nbt.method_10577("invisible_until_completed"));
        }
        if (nbt.method_10545("invisible_until_tasks")) {
            quest.setInvisibleUntilTasks(nbt.method_10550("invisible_until_tasks"));
        }
        if (nbt.method_10545("hide_text_until_complete")) {
            quest.setHideTextUntilComplete(this.parseTristate(nbt.method_10580("hide_text_until_complete")));
        }
        if (nbt.method_10545("hide_details_until_startable")) {
            quest.setHideDetailsUntilStartable(this.parseTristate(nbt.method_10580("hide_details_until_startable")));
        }
        if (nbt.method_10545("hide_until_deps_visible")) {
            quest.setHideUntilDepsVisible(this.parseTristate(nbt.method_10580("hide_until_deps_visible")));
        }
        if (nbt.method_10545("hide_until_deps_complete")) {
            quest.setHideUntilDepsComplete(this.parseTristate(nbt.method_10580("hide_until_deps_complete")));
        }
        if (nbt.method_10545("disable_jei")) {
            quest.setDisableJEI(this.parseTristate(nbt.method_10580("disable_jei")));
        }
        if (nbt.method_10545("hide_lock_icon")) {
            quest.setHideLockIcon(nbt.method_10577("hide_lock_icon"));
        }
        if (nbt.method_10545("guide_page")) {
            quest.setGuidePage(nbt.method_10558("guide_page"));
        }
        if (nbt.method_10545("ignore_reward_blocking")) {
            quest.setIgnoreRewardBlocking(nbt.method_10577("ignore_reward_blocking"));
        }
        if (nbt.method_10545("tags")) {
            class_2499 tagsList = nbt.method_10554("tags", 8);
            for (class_2520 tagTag : tagsList) {
                quest.addTag(tagTag.method_10714());
            }
        }
        if (nbt.method_10545("tasks")) {
            class_2499 tasks = nbt.method_10554("tasks", 10);
            for (class_2520 taskTag : tasks) {
                class_2487 taskNbt = (class_2487)taskTag;
                Requirement req = this.convertTask(taskNbt);
                if (req != null) {
                    quest.addRequirement(req);
                    continue;
                }
                this.log("    Warning: Could not convert task type: " + taskNbt.method_10558("type"));
            }
        }
        if (nbt.method_10545("rewards")) {
            class_2499 rewards = nbt.method_10554("rewards", 10);
            for (class_2520 rewardTag : rewards) {
                class_2487 rewardNbt = (class_2487)rewardTag;
                Reward reward = this.convertReward(rewardNbt);
                if (reward != null) {
                    quest.addReward(reward);
                    continue;
                }
                this.log("    Warning: Could not convert reward type: " + rewardNbt.method_10558("type"));
            }
        }
        if (nbt.method_10545("dependencies")) {
            class_2499 deps = nbt.method_10554("dependencies", 8);
            ArrayList<String> depIds = new ArrayList<String>();
            for (class_2520 depTag : deps) {
                String ftbDepId = depTag.method_10714();
                depIds.add(ftbDepId);
            }
            if (!depIds.isEmpty()) {
                this.pendingDependencies.put(quest.getId(), depIds);
            }
        }
        return quest;
    }

    private Requirement convertTask(class_2487 taskNbt) {
        String type;
        return switch (type = taskNbt.method_10558("type")) {
            case "ftbquests:item", "item" -> this.convertItemTask(taskNbt);
            case "ftbquests:craft", "craft" -> this.convertCraftTask(taskNbt);
            case "ftbquests:kill", "kill" -> this.convertKillTask(taskNbt);
            case "ftbquests:advancement", "advancement" -> this.convertAdvancementTask(taskNbt);
            case "ftbquests:checkmark", "checkmark" -> this.convertCheckmarkTask(taskNbt);
            case "ftbquests:fluid", "fluid" -> this.convertFluidTask(taskNbt);
            case "ftbquests:biome", "biome" -> this.convertBiomeTask(taskNbt);
            case "ftbquests:dimension", "dimension" -> this.convertDimensionTask(taskNbt);
            case "ftbquests:location", "location" -> this.convertLocationTask(taskNbt);
            case "ftbquests:energy", "energy" -> this.convertEnergyTask(taskNbt);
            case "ftbquests:structure", "structure" -> this.convertStructureTask(taskNbt);
            case "ftbquests:observation", "observation" -> this.convertObservationTask(taskNbt);
            case "ftbquests:xp", "xp" -> this.convertXpTask(taskNbt);
            case "ftbquests:stat", "stat" -> this.convertStatTask(taskNbt);
            case "ftbquests:stage", "stage" -> this.convertStageTask(taskNbt);
            case "ftbquests:custom", "custom" -> this.convertCustomTask(taskNbt);
            default -> null;
        };
    }

    private Requirement convertItemTask(class_2487 nbt) {
        if (!nbt.method_10545("item")) {
            return null;
        }
        class_2487 itemNbt = nbt.method_10562("item");
        String itemId = itemNbt.method_10545("id") ? itemNbt.method_10558("id") : itemNbt.method_10558("item");
        int count = nbt.method_10545("count") ? (int)nbt.method_10537("count") : 1;
        ItemRequirement req = new ItemRequirement(itemId, count);
        if (nbt.method_10545("consume_items")) {
            req.setConsume(nbt.method_10577("consume_items"));
        }
        if (itemNbt.method_10545("tag") || itemNbt.method_10545("nbt")) {
            class_2487 tag = itemNbt.method_10545("tag") ? itemNbt.method_10562("tag") : itemNbt.method_10562("nbt");
            req.setNbt(tag);
        }
        return req;
    }

    private Requirement convertCraftTask(class_2487 nbt) {
        if (!nbt.method_10545("item")) {
            return null;
        }
        class_2487 itemNbt = nbt.method_10562("item");
        String itemId = itemNbt.method_10545("id") ? itemNbt.method_10558("id") : itemNbt.method_10558("item");
        int count = nbt.method_10545("count") ? (int)nbt.method_10537("count") : 1;
        return new CraftingRequirement(itemId, count);
    }

    private Requirement convertKillTask(class_2487 nbt) {
        if (!nbt.method_10545("entity")) {
            return null;
        }
        String entityId = nbt.method_10558("entity");
        int count = nbt.method_10545("value") ? (int)nbt.method_10537("value") : 1;
        return new EntityKillRequirement(entityId, count);
    }

    private Requirement convertAdvancementTask(class_2487 nbt) {
        if (!nbt.method_10545("advancement")) {
            return null;
        }
        String advancementId = nbt.method_10558("advancement");
        return new AdvancementRequirement(advancementId);
    }

    private Requirement convertCheckmarkTask(class_2487 nbt) {
        String id = nbt.method_10545("title") ? nbt.method_10558("title") : "manual_complete";
        String desc = nbt.method_10545("title") ? nbt.method_10558("title") : "Manual Completion";
        return new CommandRequirement(this.sanitizeId(id), desc);
    }

    private Requirement convertFluidTask(class_2487 nbt) {
        if (!nbt.method_10545("fluid")) {
            return null;
        }
        class_2487 fluidNbt = nbt.method_10562("fluid");
        String fluidId = fluidNbt.method_10545("id") ? fluidNbt.method_10558("id") : fluidNbt.method_10558("fluid");
        long amount = nbt.method_10545("amount") ? nbt.method_10537("amount") : 1000L;
        FluidRequirement req = new FluidRequirement(fluidId, amount);
        if (fluidNbt.method_10545("tag") || fluidNbt.method_10545("nbt")) {
            class_2487 tag = fluidNbt.method_10545("tag") ? fluidNbt.method_10562("tag") : fluidNbt.method_10562("nbt");
            req.setNbt(tag);
        }
        return req;
    }

    private Requirement convertBiomeTask(class_2487 nbt) {
        if (!nbt.method_10545("biome")) {
            return null;
        }
        String biomeId = nbt.method_10558("biome");
        return new BiomeRequirement(biomeId);
    }

    private Requirement convertDimensionTask(class_2487 nbt) {
        if (!nbt.method_10545("dimension")) {
            return null;
        }
        String dimensionId = nbt.method_10558("dimension");
        return new DimensionRequirement(dimensionId);
    }

    private Requirement convertLocationTask(class_2487 nbt) {
        int x = nbt.method_10545("x") ? nbt.method_10550("x") : 0;
        int y = nbt.method_10545("y") ? nbt.method_10550("y") : 64;
        int z = nbt.method_10545("z") ? nbt.method_10550("z") : 0;
        int range = nbt.method_10545("range") ? nbt.method_10550("range") : 5;
        String dimension = nbt.method_10545("dimension") ? nbt.method_10558("dimension") : "minecraft:overworld";
        return new LocationRequirement(x, y, z, range, dimension);
    }

    private Requirement convertEnergyTask(class_2487 nbt) {
        long amount = nbt.method_10545("value") ? nbt.method_10537("value") : 1000L;
        return new EnergyRequirement(amount);
    }

    private Requirement convertStructureTask(class_2487 nbt) {
        if (!nbt.method_10545("structure")) {
            return null;
        }
        String structureId = nbt.method_10558("structure");
        return new StructureRequirement(structureId);
    }

    private Requirement convertObservationTask(class_2487 nbt) {
        String targetId = "";
        String observeType = "entity";
        if (nbt.method_10545("entity")) {
            targetId = nbt.method_10558("entity");
            observeType = "entity";
        } else if (nbt.method_10545("block")) {
            targetId = nbt.method_10558("block");
            observeType = "block";
        }
        int timer = nbt.method_10545("timer") ? nbt.method_10550("timer") : 100;
        return new ObservationRequirement(targetId, observeType, timer);
    }

    private Requirement convertXpTask(class_2487 nbt) {
        long amount = nbt.method_10545("value") ? nbt.method_10537("value") : 100L;
        boolean isLevels = nbt.method_10545("points") && !nbt.method_10577("points");
        return new XpRequirement(amount, isLevels);
    }

    private Requirement convertStatTask(class_2487 nbt) {
        if (!nbt.method_10545("stat")) {
            return null;
        }
        String statId = nbt.method_10558("stat");
        int value = nbt.method_10545("value") ? nbt.method_10550("value") : 1;
        return new StatisticRequirement(statId, value);
    }

    private Requirement convertStageTask(class_2487 nbt) {
        if (!nbt.method_10545("stage")) {
            return null;
        }
        String stage = nbt.method_10558("stage");
        return new StageRequirement(stage);
    }

    private Requirement convertCustomTask(class_2487 nbt) {
        String taskId = nbt.method_10545("task") ? nbt.method_10558("task") : "custom_task";
        String desc = nbt.method_10545("title") ? nbt.method_10558("title") : null;
        long maxProgress = nbt.method_10545("max_progress") ? nbt.method_10537("max_progress") : 1L;
        return new CustomRequirement(taskId, desc, maxProgress);
    }

    private Reward convertReward(class_2487 rewardNbt) {
        String type;
        return switch (type = rewardNbt.method_10558("type")) {
            case "ftbquests:item", "item" -> this.convertItemReward(rewardNbt);
            case "ftbquests:xp", "xp" -> this.convertXpReward(rewardNbt);
            case "ftbquests:xp_levels", "xp_levels" -> this.convertXpLevelsReward(rewardNbt);
            case "ftbquests:command", "command" -> this.convertCommandReward(rewardNbt);
            case "ftbquests:loot", "loot" -> this.convertLootReward(rewardNbt);
            case "ftbquests:random", "random" -> this.convertRandomReward(rewardNbt);
            case "ftbquests:choice", "choice" -> this.convertChoiceReward(rewardNbt);
            case "ftbquests:advancement", "advancement" -> this.convertAdvancementReward(rewardNbt);
            case "ftbquests:toast", "toast" -> this.convertToastReward(rewardNbt);
            case "ftbquests:stage", "stage" -> this.convertStageReward(rewardNbt);
            default -> null;
        };
    }

    private Reward convertItemReward(class_2487 nbt) {
        if (!nbt.method_10545("item")) {
            return null;
        }
        class_2487 itemNbt = nbt.method_10562("item");
        String itemId = itemNbt.method_10545("id") ? itemNbt.method_10558("id") : itemNbt.method_10558("item");
        int count = nbt.method_10545("count") ? nbt.method_10550("count") : 1;
        ItemReward reward = new ItemReward(itemId, count);
        if (itemNbt.method_10545("tag") || itemNbt.method_10545("nbt")) {
            class_2487 tag = itemNbt.method_10545("tag") ? itemNbt.method_10562("tag") : itemNbt.method_10562("nbt");
            reward.setNbt(tag);
        }
        return reward;
    }

    private Reward convertXpReward(class_2487 nbt) {
        int amount = nbt.method_10545("xp") ? nbt.method_10550("xp") : 100;
        return new XpReward(amount, false);
    }

    private Reward convertXpLevelsReward(class_2487 nbt) {
        int amount = nbt.method_10545("xp_levels") ? nbt.method_10550("xp_levels") : 1;
        return new XpReward(amount, true);
    }

    private Reward convertCommandReward(class_2487 nbt) {
        String command = nbt.method_10545("command") ? nbt.method_10558("command") : "";
        String title = nbt.method_10545("title") ? nbt.method_10558("title") : null;
        return new CommandReward(command, title);
    }

    private Reward convertLootReward(class_2487 nbt) {
        if (!nbt.method_10545("loot_table")) {
            return null;
        }
        String lootTable = nbt.method_10558("loot_table");
        return new LootReward(lootTable);
    }

    private Reward convertRandomReward(class_2487 nbt) {
        long tableId = nbt.method_10545("table_id") ? nbt.method_10537("table_id") : 0L;
        String tableIdStr = Long.toHexString(tableId);
        int count = nbt.method_10545("count") ? nbt.method_10550("count") : 1;
        return new RandomReward(tableIdStr, count);
    }

    private Reward convertChoiceReward(class_2487 nbt) {
        long tableId = nbt.method_10545("table_id") ? nbt.method_10537("table_id") : 0L;
        String tableIdStr = Long.toHexString(tableId);
        return new ChoiceReward(tableIdStr);
    }

    private Reward convertAdvancementReward(class_2487 nbt) {
        if (!nbt.method_10545("advancement")) {
            return null;
        }
        String advancementId = nbt.method_10558("advancement");
        String criterion = nbt.method_10545("criterion") ? nbt.method_10558("criterion") : null;
        return new AdvancementReward(advancementId, criterion);
    }

    private Reward convertToastReward(class_2487 nbt) {
        String title = nbt.method_10545("title") ? nbt.method_10558("title") : "Quest Reward";
        String description = nbt.method_10545("description") ? nbt.method_10558("description") : "";
        return new ToastReward(title, description);
    }

    private Reward convertStageReward(class_2487 nbt) {
        if (!nbt.method_10545("stage")) {
            return null;
        }
        String stage = nbt.method_10558("stage");
        boolean remove = nbt.method_10545("remove") && nbt.method_10577("remove");
        return new StageReward(stage, remove);
    }

    private void resolveDependencies() {
        this.log("Resolving dependencies...");
        int edges = 0;
        int pending = 0;
        for (Map.Entry<String, List<String>> e : this.pendingDependencies.entrySet()) {
            pending += e.getValue().size();
        }
        for (Map.Entry<String, List<String>> entry : this.pendingDependencies.entrySet()) {
            String questoryId = entry.getKey();
            Quest quest = this.convertedQuests.get(questoryId);
            if (quest == null) continue;
            for (String ftbDepId : entry.getValue()) {
                String fallback;
                Object mapped = this.idMapping.get(ftbDepId);
                if (mapped == null && this.convertedQuests.containsKey(fallback = "ftb_" + this.sanitizeId(ftbDepId))) {
                    mapped = fallback;
                }
                if (mapped != null && this.convertedQuests.containsKey(mapped)) {
                    quest.addDependency((String)mapped);
                    ++edges;
                    continue;
                }
                this.log("  Warning: Could not resolve dependency '" + ftbDepId + "' for quest " + questoryId);
            }
        }
        this.log("Resolved " + edges + " / " + pending + " dependency links");
    }

    private String extractIcon(class_2487 iconNbt) {
        if (iconNbt.method_10545("id")) {
            return iconNbt.method_10558("id");
        }
        if (iconNbt.method_10545("item")) {
            return iconNbt.method_10558("item");
        }
        return "minecraft:writable_book";
    }

    private String sanitizeId(String id) {
        return id.toLowerCase().replaceAll("[^a-z0-9_]", "_").replaceAll("_+", "_").replaceAll("^_|_$", "");
    }

    private ChapterData parseChapterData(class_2487 nbt, String chapterId, String groupName) {
        if (chapterId == null) {
            return null;
        }
        ChapterData chapterData = new ChapterData(chapterId, groupName);
        if (nbt.method_10545("always_invisible")) {
            chapterData.setAlwaysInvisible(nbt.method_10577("always_invisible"));
        }
        if (nbt.method_10545("default_quest_shape")) {
            chapterData.setDefaultQuestShape(nbt.method_10558("default_quest_shape"));
        }
        if (nbt.method_10545("default_quest_size")) {
            chapterData.setDefaultQuestSize(nbt.method_10574("default_quest_size"));
        }
        if (nbt.method_10545("default_hide_dependency_lines")) {
            chapterData.setDefaultHideDependencyLines(nbt.method_10577("default_hide_dependency_lines"));
        }
        if (nbt.method_10545("default_min_width")) {
            chapterData.setDefaultMinWidth(nbt.method_10550("default_min_width"));
        }
        if (nbt.method_10545("images")) {
            class_2499 imagesList = nbt.method_10554("images", 10);
            for (class_2520 imageTag : imagesList) {
                class_2487 imageNbt;
                ChapterImage image;
                if (!(imageTag instanceof class_2487) || (image = this.parseChapterImage(imageNbt = (class_2487)imageTag)) == null) continue;
                chapterData.addImage(image);
            }
        }
        if (nbt.method_10545("quest_links")) {
            class_2499 linksList = nbt.method_10554("quest_links", 10);
            for (class_2520 linkTag : linksList) {
                class_2487 linkNbt;
                QuestLink link;
                if (!(linkTag instanceof class_2487) || (link = this.parseQuestLink(linkNbt = (class_2487)linkTag)) == null) continue;
                chapterData.addQuestLink(link);
            }
        }
        return chapterData;
    }

    private ChapterImage parseChapterImage(class_2487 nbt) {
        if (!nbt.method_10545("image")) {
            return null;
        }
        double x = nbt.method_10545("x") ? nbt.method_10574("x") : 0.0;
        double y = nbt.method_10545("y") ? nbt.method_10574("y") : 0.0;
        double width = nbt.method_10545("width") ? nbt.method_10574("width") : 1.0;
        double height = nbt.method_10545("height") ? nbt.method_10574("height") : 1.0;
        String imageUrl = nbt.method_10558("image");
        int px = (int)Math.round(x * 45.0);
        int py = (int)Math.round(y * 45.0);
        ChapterImage image = new ChapterImage(px, py, width, height, imageUrl);
        if (nbt.method_10545("rotation")) {
            image.setRotation(nbt.method_10574("rotation"));
        }
        if (nbt.method_10545("color")) {
            int colorInt = nbt.method_10550("color");
            String colorHex = String.format("#%06X", colorInt & 0xFFFFFF);
            image.setColor(colorHex);
        }
        if (nbt.method_10545("alpha")) {
            image.setAlpha(nbt.method_10550("alpha"));
        }
        if (nbt.method_10545("order")) {
            image.setOrder(nbt.method_10550("order"));
        }
        if (nbt.method_10545("hover")) {
            class_2499 hoverList = nbt.method_10554("hover", 8);
            for (class_2520 hoverTag : hoverList) {
                image.addHoverText(hoverTag.method_10714());
            }
        }
        if (nbt.method_10545("click")) {
            image.setClickUrl(nbt.method_10558("click"));
        }
        if (nbt.method_10545("dev")) {
            image.setEditorsOnly(nbt.method_10577("dev"));
        }
        if (nbt.method_10545("corner")) {
            image.setAlignToCorner(nbt.method_10577("corner"));
        }
        if (nbt.method_10545("dependency")) {
            String depId = nbt.method_10558("dependency");
            String questoryDepId = this.idMapping.getOrDefault(depId, depId);
            image.setDependencyQuestId(questoryDepId);
        }
        return image;
    }

    private QuestLink parseQuestLink(class_2487 nbt) {
        if (!nbt.method_10545("linked_quest")) {
            return null;
        }
        String linkedQuestId = nbt.method_10558("linked_quest");
        double x = nbt.method_10545("x") ? nbt.method_10574("x") : 0.0;
        double y = nbt.method_10545("y") ? nbt.method_10574("y") : 0.0;
        int px = (int)Math.round(x * 45.0);
        int py = (int)Math.round(y * 45.0);
        String questoryQuestId = this.idMapping.getOrDefault(linkedQuestId, linkedQuestId);
        QuestLink link = new QuestLink(questoryQuestId, px, py);
        if (nbt.method_10545("shape")) {
            link.setShape(nbt.method_10558("shape"));
        }
        if (nbt.method_10545("size")) {
            link.setSize(nbt.method_10574("size"));
        }
        return link;
    }

    private void applyChapterDefaults(Quest quest, ChapterData chapterData) {
        if (chapterData.isDefaultHideDependencyLines() && !quest.isHideDependencyLines()) {
            quest.setHideDependencyLines(true);
        }
        if (chapterData.getDefaultQuestSize() != 1.0 && quest.getIconScale() == 1.0) {
            quest.setIconScale(chapterData.getDefaultQuestSize());
        }
    }

    private class_2487 parseSNBT(String snbt) {
        try {
            String normalized = snbt.replace("\r\n", "\n").replace("\r", "\n");
            return class_2522.method_10718((String)normalized);
        }
        catch (Exception e) {
            this.log("    Warning: Failed to parse SNBT: " + e.getMessage());
            return new class_2487();
        }
    }

    private void loadTranslations(Path questsFolder) {
        try {
            Path en;
            Path langDir;
            String loc;
            String dataText;
            class_2487 data;
            Path dataFile = questsFolder.resolve("data.snbt");
            if (Files.exists(dataFile, new LinkOption[0]) && (data = this.parseSNBT(dataText = Files.readString(dataFile))).method_10545("fallback_locale") && (loc = data.method_10558("fallback_locale")) != null && !loc.isBlank()) {
                this.fallbackLocale = loc.toLowerCase(Locale.ROOT);
            }
            if (!Files.exists(langDir = questsFolder.resolve("lang"), new LinkOption[0])) {
                this.log("No lang folder found, using ids as titles");
                return;
            }
            Path primary = langDir.resolve(this.fallbackLocale + ".snbt");
            if (Files.exists(primary, new LinkOption[0])) {
                this.readLangFile(primary);
            }
            if (!"en_us".equals(this.fallbackLocale) && Files.exists(en = langDir.resolve("en_us.snbt"), new LinkOption[0])) {
                this.readLangFile(en);
            }
        }
        catch (Exception ex) {
            this.log("    Warning: Failed loading translations: " + ex.getMessage());
        }
    }

    private void readLangFile(Path langFile) {
        try {
            String text = Files.readString(langFile);
            class_2487 tag = this.parseSNBT(text);
            if (tag.method_33133()) {
                return;
            }
            for (String key : tag.method_10541()) {
                class_2519 s;
                String sub;
                int p2;
                int p1;
                class_2520 val = tag.method_10580(key);
                if (key.startsWith("quest.")) {
                    p1 = key.indexOf(46);
                    p2 = key.indexOf(46, p1 + 1);
                    if (p1 <= 0 || p2 <= p1) continue;
                    String qid = key.substring(p1 + 1, p2);
                    sub = key.substring(p2 + 1);
                    if ("title".equals(sub) && val instanceof class_2519) {
                        s = (class_2519)val;
                        this.tQuestTitle.putIfAbsent(qid, s.method_10714());
                        continue;
                    }
                    if ("quest_desc".equals(sub) && val instanceof class_2499) {
                        class_2499 l = (class_2499)val;
                        ArrayList<String> lines = new ArrayList<String>();
                        for (class_2520 t : l) {
                            lines.add(t.method_10714());
                        }
                        if (lines.isEmpty()) continue;
                        this.tQuestDesc.putIfAbsent(qid, lines);
                        continue;
                    }
                    if (!"quest_subtitle".equals(sub) || !(val instanceof class_2519)) continue;
                    class_2519 s2 = (class_2519)val;
                    this.tQuestDesc.putIfAbsent(qid, List.of(s2.method_10714()));
                    continue;
                }
                if (!key.startsWith("chapter.")) continue;
                p1 = key.indexOf(46);
                p2 = key.indexOf(46, p1 + 1);
                if (p1 <= 0 || p2 <= p1) continue;
                String cid = key.substring(p1 + 1, p2);
                sub = key.substring(p2 + 1);
                if (!"title".equals(sub) || !(val instanceof class_2519)) continue;
                s = (class_2519)val;
                this.tChapterTitle.putIfAbsent(cid, s.method_10714());
            }
            this.log("Loaded translations from " + String.valueOf(langFile.getFileName()) + " (" + this.tQuestTitle.size() + " quest titles, " + this.tChapterTitle.size() + " chapter titles)");
        }
        catch (Exception e) {
            this.log("    Warning: Failed to read lang file " + String.valueOf(langFile) + ": " + e.getMessage());
        }
    }

    private String parseTristate(class_2520 tag) {
        if (tag instanceof class_2519) {
            class_2519 st = (class_2519)tag;
            String val = st.method_10714().toLowerCase();
            if ("true".equals(val) || "1".equals(val)) {
                return "true";
            }
            if ("false".equals(val) || "0".equals(val)) {
                return "false";
            }
            return "default";
        }
        if (tag instanceof class_2481) {
            class_2481 bt = (class_2481)tag;
            byte b = bt.method_10698();
            if (b == 1) {
                return "true";
            }
            if (b == 2) {
                return "false";
            }
            return "default";
        }
        return "default";
    }

    private void log(String message) {
        this.conversionLog.add(message);
        System.out.println("[FTB Importer] " + message);
    }

    public static class ImportResult {
        public final boolean success;
        public final int questCount;
        public final List<String> log;

        public ImportResult(boolean success, int questCount, List<String> log) {
            this.success = success;
            this.questCount = questCount;
            this.log = new ArrayList<String>(log);
        }
    }
}

