/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.manager;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_3222;
import org.texboobcat.questory.api.events.QuestCompletedEvent;
import org.texboobcat.questory.api.events.QuestEventBus;
import org.texboobcat.questory.api.events.QuestUnlockedEvent;
import org.texboobcat.questory.config.QuestoryConfig;
import org.texboobcat.questory.events.QuestNotifications;
import org.texboobcat.questory.manager.DailyQuestManager;
import org.texboobcat.questory.network.ChapterDataSyncPacket;
import org.texboobcat.questory.network.DailyDataSyncPacket;
import org.texboobcat.questory.network.GroupTreeSyncPacket;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.network.ProgressSyncPacket;
import org.texboobcat.questory.network.QuestSyncPacket;
import org.texboobcat.questory.quest.AdvancementRequirement;
import org.texboobcat.questory.quest.ChapterData;
import org.texboobcat.questory.quest.CommandRequirement;
import org.texboobcat.questory.quest.CraftingRequirement;
import org.texboobcat.questory.quest.EntityKillRequirement;
import org.texboobcat.questory.quest.GroupNode;
import org.texboobcat.questory.quest.ItemRequirement;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;
import org.texboobcat.questory.quest.Reward;
import org.texboobcat.questory.quest.StatisticRequirement;
import org.texboobcat.questory.storage.PlayerProgressStorage;
import org.texboobcat.questory.storage.QuestStorage;

public class QuestManager {
    private static QuestManager instance;
    private final Map<String, Quest> quests = new HashMap<String, Quest>();
    private final QuestStorage questStorage;
    private PlayerProgressStorage progressStorage;
    private final Map<String, List<String>> questGroups;
    private Map<String, ChapterData> chaptersByGroup;
    private GroupNode groupTree;
    private final Map<UUID, Set<String>> notifiedCompletableQuests;
    private Set<String> cachedRequiredStatistics = null;

    private QuestManager(Path dataPath) {
        this.questStorage = new QuestStorage(dataPath);
        this.progressStorage = new PlayerProgressStorage(dataPath);
        this.questGroups = new HashMap<String, List<String>>();
        this.notifiedCompletableQuests = new HashMap<UUID, Set<String>>();
        this.chaptersByGroup = new HashMap<String, ChapterData>();
        this.groupTree = null;
    }

    public static void initialize(Path dataPath) {
        if (instance == null) {
            instance = new QuestManager(dataPath);
            instance.loadAll();
        }
    }

    public static QuestManager getInstance() {
        if (instance == null) {
            throw new IllegalStateException("QuestManager not initialized!");
        }
        return instance;
    }

    public void reinitializeProgressStorage(Path worldDataPath) {
        System.out.println("[Questory] Reinitializing progress storage for world: " + String.valueOf(worldDataPath));
        if (this.progressStorage != null) {
            this.progressStorage.saveAll();
            this.progressStorage.clearCache();
        }
        this.progressStorage = new PlayerProgressStorage(worldDataPath);
        this.notifiedCompletableQuests.clear();
        System.out.println("[Questory] Progress storage reinitialized successfully");
    }

    public void loadAll() {
        this.quests.clear();
        this.questGroups.clear();
        this.cachedRequiredStatistics = null;
        Map<String, Quest> loadedQuests = this.questStorage.loadAllQuests();
        this.quests.putAll(loadedQuests);
        for (Quest quest : this.quests.values()) {
            String group = quest.getGroup();
            this.questGroups.computeIfAbsent(group, k -> new ArrayList()).add(quest.getId());
        }
        this.chaptersByGroup.clear();
        Map<String, ChapterData> loadedChapters = this.questStorage.loadAllChapters();
        this.chaptersByGroup.putAll(loadedChapters);
        try {
            GroupNode gt;
            this.groupTree = gt = this.questStorage.loadGroupTree();
            if (gt != null) {
                System.out.println("[Questory] Loaded group tree with " + gt.getChildren().size() + " top-level sections");
            }
        }
        catch (Throwable t) {
            System.err.println("[Questory] Failed to load group tree: " + t.getMessage());
        }
        if (this.quests.isEmpty()) {
            System.out.println("No quests found, creating example quest...");
            this.questStorage.createExampleQuest();
            this.loadAll();
        }
        System.out.println("Quest system loaded: " + this.quests.size() + " quests in " + this.questGroups.size() + " groups");
    }

    public Set<String> getRequiredStatistics() {
        if (this.cachedRequiredStatistics == null) {
            this.cachedRequiredStatistics = new HashSet<String>();
            for (Quest quest : this.quests.values()) {
                for (Requirement req : quest.getRequirements()) {
                    if (!(req instanceof StatisticRequirement)) continue;
                    StatisticRequirement statReq = (StatisticRequirement)req;
                    this.cachedRequiredStatistics.add(statReq.getStatistic());
                }
            }
            System.out.println("[Questory] Cached " + this.cachedRequiredStatistics.size() + " required statistics from quests");
        }
        return this.cachedRequiredStatistics;
    }

    public void saveAll() {
        this.questStorage.saveAllQuests(this.quests.values());
        this.progressStorage.saveAll();
    }

    public void reload() {
        this.saveAll();
        this.loadAll();
    }

    public Quest getQuest(String questId) {
        return this.quests.get(questId);
    }

    public Collection<Quest> getAllQuests() {
        return new ArrayList<Quest>(this.quests.values());
    }

    public void updateQuestPosition(String questId, int x, int y) {
        Quest quest = this.quests.get(questId);
        if (quest == null) {
            return;
        }
        quest.setX(x);
        quest.setY(y);
        this.questStorage.saveQuest(quest);
    }

    public List<Quest> getQuestsByGroup(String group) {
        List<String> questIds = this.questGroups.get(group);
        if (questIds == null) {
            return Collections.emptyList();
        }
        return questIds.stream().map(this.quests::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Set<String> getQuestGroups() {
        return new HashSet<String>(this.questGroups.keySet());
    }

    public void registerQuest(Quest quest) {
        this.quests.put(quest.getId(), quest);
        String group = quest.getGroup();
        this.questGroups.computeIfAbsent(group, k -> new ArrayList()).add(quest.getId());
        this.questStorage.saveQuest(quest);
    }

    public void unregisterQuest(String questId) {
        Quest quest = this.quests.remove(questId);
        if (quest != null) {
            String group = quest.getGroup();
            List<String> groupQuests = this.questGroups.get(group);
            if (groupQuests != null) {
                groupQuests.remove(questId);
            }
            this.questStorage.deleteQuest(questId);
        }
    }

    public QuestProgress getProgress(UUID playerId) {
        return this.progressStorage.getProgress(playerId);
    }

    public List<Quest> getVisibleQuests(UUID playerId) {
        QuestProgress progress = this.getProgress(playerId);
        return this.quests.values().stream().filter(q -> q.isVisible(progress)).collect(Collectors.toList());
    }

    public List<Quest> getCompletableQuests(UUID playerId) {
        QuestProgress progress = this.getProgress(playerId);
        return this.quests.values().stream().filter(q -> q.canComplete(progress) && !progress.isQuestCompleted(q.getId())).collect(Collectors.toList());
    }

    public boolean completeQuest(class_3222 player, String questId) {
        Quest quest = this.getQuest(questId);
        if (quest == null) {
            return false;
        }
        QuestProgress progress = this.getProgress(player.method_5667());
        if (progress.isQuestCompleted(questId)) {
            return false;
        }
        if (!quest.canComplete(progress)) {
            return false;
        }
        progress.completeQuest(questId);
        if (!progress.hasClaimedReward(questId)) {
            for (Reward reward : quest.getRewards()) {
                reward.grant(player);
            }
            progress.claimReward(questId);
        }
        this.clearQuestNotification(player.method_5667(), questId);
        QuestNotifications.notifyQuestClaimed(player, quest);
        QuestEventBus.post(new QuestCompletedEvent(player, quest, progress.getCompletionTime(questId)));
        this.progressStorage.saveProgress(progress);
        NetworkManager.sendToClient(player, new ProgressSyncPacket(progress));
        this.checkForNewlyUnlockedQuests(player, progress);
        try {
            DailyQuestManager.getInstance().onQuestCompleted(player, quest);
        }
        catch (Throwable t) {
            System.err.println("[Questory] DailyQuestManager onQuestCompleted error: " + t.getMessage());
        }
        return true;
    }

    private void checkForNewlyUnlockedQuests(class_3222 player, QuestProgress progress) {
        for (Quest quest : this.quests.values()) {
            Set<String> notified;
            if (progress.isQuestCompleted(quest.getId()) || !quest.isVisible(progress) || (notified = this.notifiedCompletableQuests.get(player.method_5667())) != null && notified.contains("unlocked_" + quest.getId())) continue;
            QuestNotifications.notifyQuestUnlocked(player, quest);
            QuestEventBus.post(new QuestUnlockedEvent(player, quest));
            if (notified == null) {
                notified = new HashSet<String>();
                this.notifiedCompletableQuests.put(player.method_5667(), notified);
            }
            notified.add("unlocked_" + quest.getId());
        }
    }

    public void trackItemProgress(UUID playerId, String itemId, int amount) {
        this.trackItemProgress(playerId, itemId, amount, null);
    }

    public void trackItemProgress(UUID playerId, String itemId, int amount, class_3222 player) {
        System.out.println("[Questory Debug] trackItemProgress called: playerId=" + String.valueOf(playerId) + ", itemId=" + itemId + ", amount=" + amount);
        System.out.println("[Questory Debug] Total quests loaded: " + this.quests.size());
        QuestProgress progress = this.getProgress(playerId);
        HashSet<String> updatedQuests = new HashSet<String>();
        for (Quest quest : this.quests.values()) {
            System.out.println("[Questory Debug] Checking quest: " + quest.getId() + ", completed=" + progress.isQuestCompleted(quest.getId()));
            if (progress.isQuestCompleted(quest.getId())) continue;
            for (Requirement req : quest.getRequirements()) {
                System.out.println("[Questory Debug] Checking requirement: type=" + req.getType());
                if (!(req instanceof ItemRequirement)) continue;
                ItemRequirement itemReq = (ItemRequirement)req;
                System.out.println("[Questory Debug] ItemRequirement found: item=" + itemReq.getItem() + ", looking for=" + itemId + ", match=" + itemReq.getItem().equals(itemId));
                if (!itemReq.getItem().equals(itemId)) continue;
                int oldProgress = progress.getRequirementProgress(quest.getId(), req);
                progress.addRequirementProgress(quest.getId(), req, amount);
                int newProgress = progress.getRequirementProgress(quest.getId(), req);
                System.out.println("[Questory Debug] Updated quest " + quest.getId() + " progress from " + oldProgress + " to " + newProgress);
                updatedQuests.add(quest.getId());
            }
        }
        this.progressStorage.saveProgress(progress);
        if (player != null && !updatedQuests.isEmpty()) {
            NetworkManager.sendToClient(player, new ProgressSyncPacket(progress));
        }
        if (player != null) {
            this.checkAndNotifyCompletableQuests(player, progress, updatedQuests);
        }
    }

    public void trackCraftingProgress(UUID playerId, String itemId, int amount) {
        this.trackCraftingProgress(playerId, itemId, amount, null);
    }

    public void trackCraftingProgress(UUID playerId, String itemId, int amount, class_3222 player) {
        QuestProgress progress = this.getProgress(playerId);
        HashSet<String> updatedQuests = new HashSet<String>();
        for (Quest quest : this.quests.values()) {
            if (progress.isQuestCompleted(quest.getId())) continue;
            for (Requirement req : quest.getRequirements()) {
                CraftingRequirement craftReq;
                if (!(req instanceof CraftingRequirement) || !(craftReq = (CraftingRequirement)req).getItem().equals(itemId)) continue;
                progress.addRequirementProgress(quest.getId(), req, amount);
                updatedQuests.add(quest.getId());
            }
        }
        this.progressStorage.saveProgress(progress);
        if (player != null && !updatedQuests.isEmpty()) {
            NetworkManager.sendToClient(player, new ProgressSyncPacket(progress));
        }
        if (player != null) {
            this.checkAndNotifyCompletableQuests(player, progress, updatedQuests);
        }
    }

    public void trackEntityKillProgress(UUID playerId, String entityId, int amount) {
        this.trackEntityKillProgress(playerId, entityId, amount, null);
    }

    public void trackEntityKillProgress(UUID playerId, String entityId, int amount, class_3222 player) {
        QuestProgress progress = this.getProgress(playerId);
        HashSet<String> updatedQuests = new HashSet<String>();
        for (Quest quest : this.quests.values()) {
            if (progress.isQuestCompleted(quest.getId())) continue;
            for (Requirement req : quest.getRequirements()) {
                EntityKillRequirement killReq;
                if (!(req instanceof EntityKillRequirement) || !(killReq = (EntityKillRequirement)req).getEntity().equals(entityId)) continue;
                progress.addRequirementProgress(quest.getId(), req, amount);
                updatedQuests.add(quest.getId());
            }
        }
        this.progressStorage.saveProgress(progress);
        if (player != null && !updatedQuests.isEmpty()) {
            NetworkManager.sendToClient(player, new ProgressSyncPacket(progress));
        }
        if (player != null) {
            this.checkAndNotifyCompletableQuests(player, progress, updatedQuests);
        }
    }

    public void trackAdvancementProgress(UUID playerId, String advancementId) {
        this.trackAdvancementProgress(playerId, advancementId, null);
    }

    public void trackAdvancementProgress(UUID playerId, String advancementId, class_3222 player) {
        QuestProgress progress = this.getProgress(playerId);
        HashSet<String> updatedQuests = new HashSet<String>();
        for (Quest quest : this.quests.values()) {
            if (progress.isQuestCompleted(quest.getId())) continue;
            for (Requirement req : quest.getRequirements()) {
                AdvancementRequirement advReq;
                if (!(req instanceof AdvancementRequirement) || !(advReq = (AdvancementRequirement)req).getAdvancement().equals(advancementId)) continue;
                progress.setRequirementProgress(quest.getId(), req, 1);
                updatedQuests.add(quest.getId());
            }
        }
        this.progressStorage.saveProgress(progress);
        if (player != null && !updatedQuests.isEmpty()) {
            NetworkManager.sendToClient(player, new ProgressSyncPacket(progress));
        }
        if (player != null) {
            this.checkAndNotifyCompletableQuests(player, progress, updatedQuests);
        }
    }

    public void trackCommandProgress(UUID playerId, String commandId) {
        QuestProgress progress = this.getProgress(playerId);
        for (Quest quest : this.quests.values()) {
            if (progress.isQuestCompleted(quest.getId())) continue;
            for (Requirement req : quest.getRequirements()) {
                CommandRequirement cmdReq;
                if (!(req instanceof CommandRequirement) || !(cmdReq = (CommandRequirement)req).getRequirementId().equals(commandId)) continue;
                progress.setRequirementProgress(quest.getId(), req, 1);
            }
        }
        this.progressStorage.saveProgress(progress);
    }

    public void trackStatisticProgress(UUID playerId, String statistic, int value) {
        this.trackStatisticProgress(playerId, statistic, value, null);
    }

    public void trackStatisticProgress(UUID playerId, String statistic, int value, class_3222 player) {
        QuestProgress progress = this.getProgress(playerId);
        HashSet<String> updatedQuests = new HashSet<String>();
        for (Quest quest : this.quests.values()) {
            if (progress.isQuestCompleted(quest.getId())) continue;
            for (Requirement req : quest.getRequirements()) {
                StatisticRequirement statReq;
                if (!(req instanceof StatisticRequirement) || !(statReq = (StatisticRequirement)req).getStatistic().equals(statistic)) continue;
                progress.setRequirementProgress(quest.getId(), req, value);
                updatedQuests.add(quest.getId());
            }
        }
        this.progressStorage.saveProgress(progress);
        if (player != null && !updatedQuests.isEmpty()) {
            NetworkManager.sendToClient(player, new ProgressSyncPacket(progress));
        }
        if (player != null) {
            this.checkAndNotifyCompletableQuests(player, progress, updatedQuests);
        }
    }

    private void checkAndNotifyCompletableQuests(class_3222 player, QuestProgress progress, Set<String> updatedQuests) {
        Set notified = this.notifiedCompletableQuests.computeIfAbsent(player.method_5667(), k -> new HashSet());
        for (String questId : updatedQuests) {
            Quest quest = this.getQuest(questId);
            if (quest == null || !quest.canComplete(progress) || notified.contains(questId)) continue;
            QuestNotifications.notifyQuestReady(player, quest);
            notified.add(questId);
        }
    }

    private void clearQuestNotification(UUID playerId, String questId) {
        Set<String> notified = this.notifiedCompletableQuests.get(playerId);
        if (notified != null) {
            notified.remove(questId);
        }
    }

    public void onPlayerDisconnect(UUID playerId) {
        this.progressStorage.unloadPlayer(playerId);
        this.notifiedCompletableQuests.remove(playerId);
    }

    public void onPlayerJoin(class_3222 player) {
        NetworkManager.sendToClient(player, new QuestSyncPacket(new ArrayList<Quest>(this.quests.values())));
        QuestProgress progress = this.getProgress(player.method_5667());
        NetworkManager.sendToClient(player, new ProgressSyncPacket(progress));
        if (this.chaptersByGroup != null && !this.chaptersByGroup.isEmpty()) {
            NetworkManager.sendToClient(player, new ChapterDataSyncPacket(new ArrayList<ChapterData>(this.chaptersByGroup.values())));
        }
        try {
            QuestoryConfig cfg = QuestoryConfig.getInstance();
            if (cfg.dailyEnable) {
                DailyQuestManager dm = DailyQuestManager.getInstance();
                NetworkManager.sendToClient(player, new DailyDataSyncPacket(dm.getCurrentDailyId(), dm.getCurrentTitle(), dm.getCurrentValidFrom(), dm.getCurrentValidUntil(), dm.getCurrentRolloverTz()));
            }
        }
        catch (Throwable t) {
            System.err.println("[Questory] Failed to sync daily meta: " + t.getMessage());
        }
        try {
            if (this.groupTree != null) {
                NetworkManager.sendToClient(player, new GroupTreeSyncPacket(this.groupTree));
            }
        }
        catch (Throwable t) {
            System.err.println("[Questory] Failed to sync group tree: " + t.getMessage());
        }
        System.out.println("[Questory] Synced quest data to player: " + player.method_5477().getString());
    }
}

