/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.network;

import dev.architectury.networking.NetworkChannel;
import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.Env;
import java.util.function.Supplier;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.texboobcat.questory.network.ChapterDataSyncPacket;
import org.texboobcat.questory.network.DailyDataSyncPacket;
import org.texboobcat.questory.network.GroupTreeSyncPacket;
import org.texboobcat.questory.network.OpenGuiPacket;
import org.texboobcat.questory.network.ProgressSyncPacket;
import org.texboobcat.questory.network.QuestCompleteRequestPacket;
import org.texboobcat.questory.network.QuestPositionUpdatePacket;
import org.texboobcat.questory.network.QuestSyncPacket;

public class NetworkManager {
    public static final class_2960 QUEST_SYNC_PACKET = new class_2960("questory", "quest_sync");
    public static final class_2960 PROGRESS_SYNC_PACKET = new class_2960("questory", "progress_sync");
    public static final class_2960 CHAPTER_DATA_SYNC_PACKET = new class_2960("questory", "chapter_data_sync");
    public static final class_2960 GROUP_TREE_SYNC_PACKET = new class_2960("questory", "group_tree_sync");
    public static final class_2960 DAILY_DATA_SYNC_PACKET = new class_2960("questory", "daily_data_sync");
    public static final class_2960 QUEST_COMPLETE_PACKET = new class_2960("questory", "quest_complete");
    public static final class_2960 OPEN_GUI_PACKET = new class_2960("questory", "open_gui");
    private static final NetworkChannel CHANNEL = NetworkChannel.create((class_2960)new class_2960("questory", "main"));

    public static void init() {
        CHANNEL.register(QuestSyncPacket.class, QuestSyncPacket::encode, QuestSyncPacket::decode, NetworkManager::handleQuestSync);
        CHANNEL.register(ProgressSyncPacket.class, ProgressSyncPacket::encode, ProgressSyncPacket::decode, NetworkManager::handleProgressSync);
        CHANNEL.register(ChapterDataSyncPacket.class, ChapterDataSyncPacket::encode, ChapterDataSyncPacket::decode, NetworkManager::handleChapterDataSync);
        CHANNEL.register(GroupTreeSyncPacket.class, GroupTreeSyncPacket::encode, GroupTreeSyncPacket::decode, NetworkManager::handleGroupTreeSync);
        CHANNEL.register(DailyDataSyncPacket.class, DailyDataSyncPacket::encode, DailyDataSyncPacket::decode, NetworkManager::handleDailyDataSync);
        CHANNEL.register(OpenGuiPacket.class, OpenGuiPacket::encode, OpenGuiPacket::decode, NetworkManager::handleOpenGui);
        CHANNEL.register(QuestCompleteRequestPacket.class, QuestCompleteRequestPacket::encode, QuestCompleteRequestPacket::decode, NetworkManager::handleQuestCompleteRequest);
        CHANNEL.register(QuestPositionUpdatePacket.class, QuestPositionUpdatePacket::encode, QuestPositionUpdatePacket::decode, NetworkManager::handleQuestPositionUpdate);
        System.out.println("[Questory] Network handlers registered");
    }

    private static void handleGroupTreeSync(GroupTreeSyncPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            if (context.getEnvironment() == Env.CLIENT) {
                packet.handle();
            }
        });
    }

    private static void handleChapterDataSync(ChapterDataSyncPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            if (context.getEnvironment() == Env.CLIENT) {
                packet.handle();
            }
        });
    }

    public static void sendToClient(class_3222 player, Object packet) {
        CHANNEL.sendToPlayer(player, packet);
    }

    public static void sendToServer(Object packet) {
        CHANNEL.sendToServer(packet);
    }

    private static void handleQuestSync(QuestSyncPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            if (context.getEnvironment() == Env.CLIENT) {
                packet.handle();
            }
        });
    }

    private static void handleProgressSync(ProgressSyncPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            if (context.getEnvironment() == Env.CLIENT) {
                packet.handle();
            }
        });
    }

    private static void handleOpenGui(OpenGuiPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            if (context.getEnvironment() == Env.CLIENT) {
                packet.handle();
            }
        });
    }

    private static void handleDailyDataSync(DailyDataSyncPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            if (context.getEnvironment() == Env.CLIENT) {
                packet.handle();
            }
        });
    }

    private static void handleQuestCompleteRequest(QuestCompleteRequestPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            class_1657 patt0$temp;
            if (context.getEnvironment() == Env.SERVER && (patt0$temp = context.getPlayer()) instanceof class_3222) {
                class_3222 player = (class_3222)patt0$temp;
                packet.handle(player);
            }
        });
    }

    private static void handleQuestPositionUpdate(QuestPositionUpdatePacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            class_1657 patt0$temp;
            if (context.getEnvironment() == Env.SERVER && (patt0$temp = context.getPlayer()) instanceof class_3222) {
                class_3222 player = (class_3222)patt0$temp;
                packet.handle(player);
            }
        });
    }
}

