/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;

public class LocationRequirement
extends Requirement {
    private int x;
    private int y;
    private int z;
    private int range;
    private String dimension;

    public LocationRequirement(int x, int y, int z, int range, String dimension) {
        super("location");
        this.x = x;
        this.y = y;
        this.z = z;
        this.range = range;
        this.dimension = dimension;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public int getRange() {
        return this.range;
    }

    public String getDimension() {
        return this.dimension;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public void setRange(int range) {
        this.range = range;
    }

    public void setDimension(String dimension) {
        this.dimension = dimension;
    }

    @Override
    public boolean isMet(QuestProgress progress, String questId) {
        return progress.getRequirementProgress(questId, this) > 0;
    }

    @Override
    public String getProgressDisplay(QuestProgress progress, String questId) {
        boolean visited = progress.getRequirementProgress(questId, this) > 0;
        return (visited ? "\u2713" : "\u2717") + " Reach location: " + String.format("%d, %d, %d (\u00b1%d blocks) in %s", this.x, this.y, this.z, this.range, this.dimension);
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", "location");
        json.addProperty("x", (Number)this.x);
        json.addProperty("y", (Number)this.y);
        json.addProperty("z", (Number)this.z);
        json.addProperty("range", (Number)this.range);
        json.addProperty("dimension", this.dimension);
        return json;
    }

    public static LocationRequirement fromJson(JsonObject json) {
        int x = json.get("x").getAsInt();
        int y = json.get("y").getAsInt();
        int z = json.get("z").getAsInt();
        int range = json.has("range") ? json.get("range").getAsInt() : 5;
        String dimension = json.has("dimension") ? json.get("dimension").getAsString() : "minecraft:overworld";
        return new LocationRequirement(x, y, z, range, dimension);
    }
}

