/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;

public class XpRequirement
extends Requirement {
    private long amount;
    private boolean levels;

    public XpRequirement(long amount, boolean levels) {
        super("xp");
        this.amount = amount;
        this.levels = levels;
    }

    public long getAmount() {
        return this.amount;
    }

    public boolean isLevels() {
        return this.levels;
    }

    public void setAmount(long amount) {
        this.amount = amount;
    }

    public void setLevels(boolean levels) {
        this.levels = levels;
    }

    @Override
    public boolean isMet(QuestProgress progress, String questId) {
        return (long)progress.getRequirementProgress(questId, this) >= this.amount;
    }

    @Override
    public String getProgressDisplay(QuestProgress progress, String questId) {
        long current = progress.getRequirementProgress(questId, this);
        return current + "/" + this.amount + (this.levels ? " Levels" : " XP");
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", "xp");
        json.addProperty("amount", (Number)this.amount);
        json.addProperty("levels", Boolean.valueOf(this.levels));
        return json;
    }

    public static XpRequirement fromJson(JsonObject json) {
        long amount = json.get("amount").getAsLong();
        boolean levels = json.has("levels") && json.get("levels").getAsBoolean();
        return new XpRequirement(amount, levels);
    }
}

