/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.quest.Requirement;
import org.texboobcat.questory.quest.Reward;

public class QuestValidator {
    public static ValidationResult validate(Quest quest, Map<String, Quest> allQuests) {
        ValidationResult result = new ValidationResult(quest.getId());
        QuestValidator.validateBasicProperties(quest, result);
        QuestValidator.validateDependencies(quest, allQuests, result);
        QuestValidator.validateRequirements(quest, result);
        QuestValidator.validateRewards(quest, result);
        QuestValidator.checkCircularDependencies(quest, allQuests, result);
        return result;
    }

    public static Map<String, ValidationResult> validateAll(Map<String, Quest> quests) {
        HashMap<String, ValidationResult> results = new HashMap<String, ValidationResult>();
        for (Quest quest : quests.values()) {
            ValidationResult result = QuestValidator.validate(quest, quests);
            results.put(quest.getId(), result);
        }
        return results;
    }

    private static void validateBasicProperties(Quest quest, ValidationResult result) {
        if (quest.getId() == null || quest.getId().trim().isEmpty()) {
            result.addError("Quest ID is null or empty");
        }
        if (quest.getTitle() == null || quest.getTitle().trim().isEmpty()) {
            result.addWarning("Quest title is empty");
        }
        if (quest.getDescription() == null) {
            result.addWarning("Quest description is null");
        }
        if (quest.getIcon() == null || quest.getIcon().trim().isEmpty()) {
            result.addWarning("Quest icon is not set");
        }
        if (quest.getRequirements().isEmpty()) {
            result.addWarning("Quest has no requirements (will complete immediately)");
        }
        if (quest.getRewards().isEmpty()) {
            result.addWarning("Quest has no rewards");
        }
    }

    private static void validateDependencies(Quest quest, Map<String, Quest> allQuests, ValidationResult result) {
        for (String depId : quest.getDependencies()) {
            if (allQuests.containsKey(depId)) continue;
            result.addError("Dependency quest not found: " + depId);
        }
    }

    private static void validateRequirements(Quest quest, ValidationResult result) {
        if (quest.getRequirements().size() > 50) {
            result.addWarning("Quest has many requirements (" + quest.getRequirements().size() + "), may impact performance");
        }
        for (Requirement req : quest.getRequirements()) {
            if (req != null) continue;
            result.addError("Quest has null requirement");
        }
    }

    private static void validateRewards(Quest quest, ValidationResult result) {
        if (quest.getRewards().size() > 20) {
            result.addWarning("Quest has many rewards (" + quest.getRewards().size() + "), may impact performance");
        }
        for (Reward reward : quest.getRewards()) {
            if (reward != null) continue;
            result.addError("Quest has null reward");
        }
    }

    private static void checkCircularDependencies(Quest quest, Map<String, Quest> allQuests, ValidationResult result) {
        HashSet<String> visited = new HashSet<String>();
        HashSet<String> recursionStack = new HashSet<String>();
        if (QuestValidator.hasCircularDependency(quest.getId(), allQuests, visited, recursionStack)) {
            result.addError("Quest has circular dependency");
        }
    }

    private static boolean hasCircularDependency(String questId, Map<String, Quest> allQuests, Set<String> visited, Set<String> recursionStack) {
        if (recursionStack.contains(questId)) {
            return true;
        }
        if (visited.contains(questId)) {
            return false;
        }
        visited.add(questId);
        recursionStack.add(questId);
        Quest quest = allQuests.get(questId);
        if (quest != null) {
            for (String depId : quest.getDependencies()) {
                if (!QuestValidator.hasCircularDependency(depId, allQuests, visited, recursionStack)) continue;
                return true;
            }
        }
        recursionStack.remove(questId);
        return false;
    }

    public static class ValidationResult {
        private final String questId;
        private final List<String> errors;
        private final List<String> warnings;

        public ValidationResult(String questId) {
            this.questId = questId;
            this.errors = new ArrayList<String>();
            this.warnings = new ArrayList<String>();
        }

        public void addError(String error) {
            this.errors.add(error);
        }

        public void addWarning(String warning) {
            this.warnings.add(warning);
        }

        public boolean isValid() {
            return this.errors.isEmpty();
        }

        public boolean hasWarnings() {
            return !this.warnings.isEmpty();
        }

        public String getQuestId() {
            return this.questId;
        }

        public List<String> getErrors() {
            return new ArrayList<String>(this.errors);
        }

        public List<String> getWarnings() {
            return new ArrayList<String>(this.warnings);
        }

        public String getSummary() {
            StringBuilder sb = new StringBuilder();
            sb.append("Quest: ").append(this.questId).append("\n");
            if (this.isValid() && !this.hasWarnings()) {
                sb.append("  \u2713 Valid\n");
            } else {
                if (!this.errors.isEmpty()) {
                    sb.append("  Errors:\n");
                    for (String error : this.errors) {
                        sb.append("    \u2717 ").append(error).append("\n");
                    }
                }
                if (!this.warnings.isEmpty()) {
                    sb.append("  Warnings:\n");
                    for (String warning : this.warnings) {
                        sb.append("    \u26a0 ").append(warning).append("\n");
                    }
                }
            }
            return sb.toString();
        }
    }
}

