/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.api;

import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.class_2960;
import org.texboobcat.questory.Questory;
import org.texboobcat.questory.api.RewardFactory;
import org.texboobcat.questory.api.exceptions.DuplicateRegistrationException;
import org.texboobcat.questory.api.serialization.RewardCodec;
import org.texboobcat.questory.api.serialization.SerializationContext;
import org.texboobcat.questory.quest.Reward;

public class RewardRegistry {
    private static final ConcurrentMap<String, RewardFactory> REGISTRY = new ConcurrentHashMap<String, RewardFactory>();
    private static final ConcurrentMap<String, RewardCodec<?>> CODECS = new ConcurrentHashMap();

    private static String normalize(String id) {
        if (id == null) {
            return "";
        }
        Object s = id.trim().toLowerCase(Locale.ROOT);
        if (((String)s).isEmpty()) {
            return s;
        }
        if (!((String)s).contains(":")) {
            s = "questory:" + (String)s;
        }
        return s;
    }

    public static void register(String type, RewardFactory factory) {
        String key = RewardRegistry.normalize(type);
        if (REGISTRY.containsKey(key)) {
            Questory.LOGGER.warn("[API] Overwriting reward type: {}", (Object)key);
        }
        REGISTRY.put(key, factory);
        Questory.LOGGER.info("[API] Registered custom reward type: {}", (Object)key);
    }

    public static void register(class_2960 id, RewardFactory factory) {
        RewardRegistry.register(id == null ? null : id.toString(), factory);
    }

    public static void registerOrReplace(class_2960 id, RewardFactory factory) {
        String key = RewardRegistry.normalize(id == null ? null : id.toString());
        REGISTRY.put(key, factory);
        Questory.LOGGER.info("[API] Registered (replace) reward type: {}", (Object)key);
    }

    public static void registerStrict(class_2960 id, RewardFactory factory) {
        String key = RewardRegistry.normalize(id == null ? null : id.toString());
        if (REGISTRY.containsKey(key)) {
            throw new DuplicateRegistrationException("Reward factory already registered: " + key);
        }
        REGISTRY.put(key, factory);
        Questory.LOGGER.info("[API] Registered reward type: {}", (Object)key);
    }

    public static void register(class_2960 id, RewardCodec<?> codec) {
        String key = RewardRegistry.normalize(id == null ? null : id.toString());
        RewardCodec<?> prev = CODECS.put(key, codec);
        if (prev != null) {
            Questory.LOGGER.warn("[API] Overwriting reward codec: {}", (Object)key);
        }
        Questory.LOGGER.info("[API] Registered reward codec: {}", (Object)key);
    }

    public static void registerOrReplace(class_2960 id, RewardCodec<?> codec) {
        String key = RewardRegistry.normalize(id == null ? null : id.toString());
        CODECS.put(key, codec);
        Questory.LOGGER.info("[API] Registered (replace) reward codec: {}", (Object)key);
    }

    public static void registerStrict(class_2960 id, RewardCodec<?> codec) {
        String key = RewardRegistry.normalize(id == null ? null : id.toString());
        if (CODECS.containsKey(key)) {
            throw new DuplicateRegistrationException("Reward codec already registered: " + key);
        }
        CODECS.put(key, codec);
        Questory.LOGGER.info("[API] Registered reward codec: {}", (Object)key);
    }

    public static Reward create(String type, JsonObject json) {
        String key = RewardRegistry.normalize(type);
        RewardCodec codec = (RewardCodec)CODECS.get(key);
        if (codec != null) {
            try {
                RewardCodec c = codec;
                SerializationContext ctx = new SerializationContext(Questory.getDataPath(), 1, Questory.LOGGER);
                return c.fromJson(json, ctx);
            }
            catch (Exception e) {
                Questory.LOGGER.error("[API] Reward codec decode failed for {}: {}", (Object)key, (Object)e.getMessage());
                return null;
            }
        }
        RewardFactory factory = (RewardFactory)REGISTRY.get(key);
        if (factory == null) {
            return null;
        }
        return factory.create(json);
    }

    public static Reward create(class_2960 id, JsonObject json) {
        return RewardRegistry.create(id == null ? null : id.toString(), json);
    }

    public static boolean isRegistered(String type) {
        String key = RewardRegistry.normalize(type);
        return REGISTRY.containsKey(key) || CODECS.containsKey(key);
    }

    public static boolean isRegistered(class_2960 id) {
        return RewardRegistry.isRegistered(id == null ? null : id.toString());
    }

    public static Set<String> getRegisteredTypes() {
        HashSet<String> types = new HashSet<String>();
        types.addAll(REGISTRY.keySet());
        types.addAll(CODECS.keySet());
        return types;
    }
}

