/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.texboobcat.questory.quest.ChapterData;
import org.texboobcat.questory.quest.ChapterImage;
import org.texboobcat.questory.quest.GroupNode;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.quest.QuestProgress;

public class ClientQuestManager {
    private static ClientQuestManager instance;
    private Map<String, Quest> quests = new HashMap<String, Quest>();
    private QuestProgress progress = null;
    private Map<String, List<String>> questGroups = new HashMap<String, List<String>>();
    private Map<String, List<ChapterImage>> chapterImagesByGroup = new HashMap<String, List<ChapterImage>>();
    private Map<String, ChapterData> chapterDataByTitle = new HashMap<String, ChapterData>();
    private GroupNode groupTree = null;
    private String dailyId = "";
    private String dailyTitle = "";
    private String dailyValidFrom = "";
    private String dailyValidUntil = "";
    private String dailyRolloverTz = "";
    private final Set<ProgressUpdateListener> progressListeners = new CopyOnWriteArraySet<ProgressUpdateListener>();

    public void addProgressListener(ProgressUpdateListener listener) {
        this.progressListeners.add(listener);
    }

    public void removeProgressListener(ProgressUpdateListener listener) {
        this.progressListeners.remove(listener);
    }

    private ClientQuestManager() {
        this.chapterImagesByGroup = new HashMap<String, List<ChapterImage>>();
        this.chapterDataByTitle = new HashMap<String, ChapterData>();
    }

    public void setDailyMeta(String id, String title, String validFrom, String validUntil, String tz) {
        this.dailyId = id == null ? "" : id;
        this.dailyTitle = title == null ? "" : title;
        this.dailyValidFrom = validFrom == null ? "" : validFrom;
        this.dailyValidUntil = validUntil == null ? "" : validUntil;
        this.dailyRolloverTz = tz == null ? "" : tz;
        System.out.println("[Questory Client] Synced daily meta: id=" + this.dailyId);
    }

    public String getDailyId() {
        return this.dailyId;
    }

    public String getDailyTitle() {
        return this.dailyTitle;
    }

    public String getDailyValidFrom() {
        return this.dailyValidFrom;
    }

    public String getDailyValidUntil() {
        return this.dailyValidUntil;
    }

    public String getDailyRolloverTz() {
        return this.dailyRolloverTz;
    }

    public static ClientQuestManager getInstance() {
        if (instance == null) {
            instance = new ClientQuestManager();
        }
        return instance;
    }

    public void setQuests(List<Quest> questList) {
        this.quests.clear();
        this.questGroups.clear();
        for (Quest quest : questList) {
            this.quests.put(quest.getId(), quest);
            String group = quest.getGroup();
            this.questGroups.computeIfAbsent(group, k -> new ArrayList()).add(quest.getId());
        }
        System.out.println("[Questory Client] Synced " + this.quests.size() + " quests");
    }

    public void setChapterImages(Map<String, List<ChapterImage>> map) {
        this.chapterImagesByGroup = map == null ? new HashMap<String, List<ChapterImage>>() : new HashMap<String, List<ChapterImage>>(map);
        System.out.println("[Questory Client] Synced chapter images: " + this.chapterImagesByGroup.size());
    }

    public void setChapterData(List<ChapterData> list) {
        this.chapterDataByTitle = new HashMap<String, ChapterData>();
        if (list != null) {
            for (ChapterData cd : list) {
                if (cd == null || cd.getTitle() == null) continue;
                this.chapterDataByTitle.put(cd.getTitle(), cd);
            }
        }
        System.out.println("[Questory Client] Synced chapter data entries: " + this.chapterDataByTitle.size());
    }

    public List<ChapterData> getAllChapters() {
        return new ArrayList<ChapterData>(this.chapterDataByTitle.values());
    }

    public ChapterData getChapterByTitle(String title) {
        return this.chapterDataByTitle.get(title);
    }

    public void setGroupTree(GroupNode root) {
        this.groupTree = root;
        System.out.println("[Questory Client] Synced group tree: " + (root == null ? 0 : root.getChildren().size()) + " top-level sections");
    }

    public GroupNode getGroupTree() {
        return this.groupTree;
    }

    public int getQuestCountForGroup(String group) {
        List<String> ids = this.questGroups.get(group);
        return ids == null ? 0 : ids.size();
    }

    public List<ChapterImage> getChapterImages(String group) {
        String slug;
        List<ChapterImage> list = this.chapterImagesByGroup.get(group);
        if (list != null && !list.isEmpty()) {
            return list;
        }
        String string = slug = group == null ? null : group.toLowerCase().replaceAll("[^a-z0-9]+", "_").replaceAll("^_|_$", "");
        if (slug != null && !slug.isBlank() && (list = this.chapterImagesByGroup.get(slug)) != null && !list.isEmpty()) {
            return list;
        }
        List<Quest> questsInGroup = this.getQuestsByGroup(group);
        if (questsInGroup != null) {
            for (Quest q : questsInGroup) {
                String cid = q.getChapterId();
                if (cid == null || cid.isBlank()) continue;
                list = this.chapterImagesByGroup.get(cid);
                if (list == null || list.isEmpty()) break;
                return list;
            }
        }
        return Collections.emptyList();
    }

    public void setProgress(QuestProgress progress) {
        this.progress = progress;
        System.out.println("[Questory Client] Synced progress");
        for (ProgressUpdateListener listener : this.progressListeners) {
            try {
                listener.onProgressUpdated();
            }
            catch (Throwable t) {
                System.err.println("[Questory] Error notifying progress listener: " + t.getMessage());
            }
        }
    }

    public Quest getQuest(String questId) {
        return this.quests.get(questId);
    }

    public Collection<Quest> getAllQuests() {
        return new ArrayList<Quest>(this.quests.values());
    }

    public List<Quest> getQuestsByGroup(String group) {
        List<String> questIds = this.questGroups.get(group);
        if (questIds == null) {
            return Collections.emptyList();
        }
        return questIds.stream().map(this.quests::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Set<String> getQuestGroups() {
        return new HashSet<String>(this.questGroups.keySet());
    }

    public List<Quest> getVisibleQuests() {
        if (this.progress == null) {
            return Collections.emptyList();
        }
        return this.quests.values().stream().filter(q -> q.isVisible(this.progress)).collect(Collectors.toList());
    }

    public List<Quest> getCompletedQuests() {
        if (this.progress == null) {
            return Collections.emptyList();
        }
        return this.quests.values().stream().filter(q -> this.progress.isQuestCompleted(q.getId())).collect(Collectors.toList());
    }

    public List<Quest> getCompletableQuests() {
        if (this.progress == null) {
            return Collections.emptyList();
        }
        return this.quests.values().stream().filter(q -> q.canComplete(this.progress) && !this.progress.isQuestCompleted(q.getId())).collect(Collectors.toList());
    }

    public QuestProgress getProgress() {
        return this.progress;
    }

    public boolean isQuestCompleted(String questId) {
        return this.progress != null && this.progress.isQuestCompleted(questId);
    }

    public boolean canCompleteQuest(String questId) {
        Quest quest = this.getQuest(questId);
        return quest != null && this.progress != null && quest.canComplete(this.progress);
    }

    public void clear() {
        this.quests.clear();
        this.questGroups.clear();
        this.progress = null;
    }

    public static interface ProgressUpdateListener {
        public void onProgressUpdated();
    }
}

