/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.questory.client.gui.ChapterArtEditorScreen;
import org.texboobcat.questory.client.gui.ChapterTabPanel;
import org.texboobcat.questory.client.gui.QuestLinkEditorScreen;
import org.texboobcat.questory.quest.ChapterData;
import org.texboobcat.questory.quest.QuestLink;

public class ChapterLinksTabPanel
extends ChapterTabPanel {
    private List<QuestLink> questLinks = new ArrayList<QuestLink>();
    private int selectedIndex = -1;
    private int listScroll = 0;
    private class_4185 addBtn;
    private class_4185 editBtn;
    private class_4185 removeBtn;
    private class_4185 moveUpBtn;
    private class_4185 moveDownBtn;

    public ChapterLinksTabPanel(ChapterArtEditorScreen editor, int x, int y, int w, int h) {
        super(editor, x, y, w, h);
        this.initWidgets();
    }

    private void initWidgets() {
        int btnY = this.y + this.h - 32;
        this.addBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"+ Add Link"), b -> this.openAddDialog()).method_46434(this.x + 12, btnY, 80, 20).method_46431();
        this.editBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Edit"), b -> this.openEditDialog()).method_46434(this.x + 96, btnY, 60, 20).method_46431();
        this.removeBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Remove"), b -> this.removeSelected()).method_46434(this.x + 160, btnY, 70, 20).method_46431();
        this.moveUpBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2191"), b -> this.moveUp()).method_46434(this.x + 234, btnY, 30, 20).method_46431();
        this.moveDownBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2193"), b -> this.moveDown()).method_46434(this.x + 268, btnY, 30, 20).method_46431();
    }

    private void openAddDialog() {
        QuestLink newLink = new QuestLink("quest_id", 0, 0);
        this.getMinecraft().method_1507((class_437)new QuestLinkEditorScreen(this.editor, newLink, updated -> {
            this.questLinks.add((QuestLink)updated);
            this.getMinecraft().method_1507((class_437)this.editor);
        }));
    }

    private void openEditDialog() {
        if (this.selectedIndex >= 0 && this.selectedIndex < this.questLinks.size()) {
            QuestLink link = this.questLinks.get(this.selectedIndex);
            this.getMinecraft().method_1507((class_437)new QuestLinkEditorScreen(this.editor, link, updated -> {
                this.questLinks.set(this.selectedIndex, (QuestLink)updated);
                this.getMinecraft().method_1507((class_437)this.editor);
            }));
        }
    }

    private void removeSelected() {
        if (this.selectedIndex >= 0 && this.selectedIndex < this.questLinks.size()) {
            this.questLinks.remove(this.selectedIndex);
            this.selectedIndex = -1;
        }
    }

    private void moveUp() {
        if (this.selectedIndex > 0) {
            QuestLink temp = this.questLinks.get(this.selectedIndex);
            this.questLinks.set(this.selectedIndex, this.questLinks.get(this.selectedIndex - 1));
            this.questLinks.set(this.selectedIndex - 1, temp);
            --this.selectedIndex;
        }
    }

    private void moveDown() {
        if (this.selectedIndex >= 0 && this.selectedIndex < this.questLinks.size() - 1) {
            QuestLink temp = this.questLinks.get(this.selectedIndex);
            this.questLinks.set(this.selectedIndex, this.questLinks.get(this.selectedIndex + 1));
            this.questLinks.set(this.selectedIndex + 1, temp);
            ++this.selectedIndex;
        }
    }

    @Override
    public void loadFromChapter(ChapterData chapter) {
        this.questLinks.clear();
        this.questLinks.addAll(chapter.getQuestLinks());
        this.selectedIndex = -1;
        this.listScroll = 0;
    }

    @Override
    public void saveToChapter(ChapterData chapter) {
        chapter.getQuestLinks().clear();
        chapter.getQuestLinks().addAll(this.questLinks);
    }

    @Override
    public void render(class_332 g, int mouseX, int mouseY, float partialTick) {
        int listX = this.x + 12;
        int listY = this.y + 12;
        int listW = this.w - 24;
        int listH = this.h - 60;
        g.method_25303(this.getFont(), "\u00a7lQuest Links (" + this.questLinks.size() + ")", listX, listY, -86);
        g.method_25294(listX, listY += 20, listX + listW, listY + (listH -= 20), -803200992);
        g.method_44379(listX, listY, listX + listW, listY + listH);
        int lineH = 36;
        int maxVisible = Math.max(1, listH / lineH);
        this.listScroll = Math.max(0, Math.min(this.listScroll, Math.max(0, this.questLinks.size() - maxVisible)));
        for (int i = 0; i < Math.min(maxVisible, this.questLinks.size() - this.listScroll); ++i) {
            boolean hover;
            int index = this.listScroll + i;
            QuestLink link = this.questLinks.get(index);
            int itemY = listY + 4 + i * lineH;
            boolean selected = index == this.selectedIndex;
            boolean bl = hover = mouseX >= listX && mouseX <= listX + listW && mouseY >= itemY && mouseY < itemY + lineH;
            if (selected) {
                g.method_25294(listX + 2, itemY, listX + listW - 2, itemY + lineH - 2, -12952966);
            } else if (hover) {
                g.method_25294(listX + 2, itemY, listX + listW - 2, itemY + lineH - 2, -14013910);
            }
            String summary = index + 1 + ". [LINK] \u2192 " + link.getLinkedQuestId();
            if (this.getFont().method_1727(summary) > listW - 20) {
                summary = this.getFont().method_27523(summary, listW - 30) + "...";
            }
            g.method_25303(this.getFont(), summary, listX + 8, itemY + 4, -1);
            String shape = link.getShape().isEmpty() ? "default" : link.getShape();
            String details = String.format("  \u2514\u2500 Pos: (%d, %d) | Shape: %s | Size: %.1f", link.getX(), link.getY(), shape, link.getSize());
            g.method_25303(this.getFont(), details, listX + 12, itemY + 18, -3355444);
        }
        g.method_44380();
        this.addBtn.method_25394(g, mouseX, mouseY, partialTick);
        this.editBtn.field_22763 = this.selectedIndex >= 0;
        this.editBtn.method_25394(g, mouseX, mouseY, partialTick);
        this.removeBtn.field_22763 = this.selectedIndex >= 0;
        this.removeBtn.method_25394(g, mouseX, mouseY, partialTick);
        this.moveUpBtn.field_22763 = this.selectedIndex > 0;
        this.moveUpBtn.method_25394(g, mouseX, mouseY, partialTick);
        this.moveDownBtn.field_22763 = this.selectedIndex >= 0 && this.selectedIndex < this.questLinks.size() - 1;
        this.moveDownBtn.method_25394(g, mouseX, mouseY, partialTick);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.addBtn.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.editBtn.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.removeBtn.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.moveUpBtn.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.moveDownBtn.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        int listX = this.x + 12;
        int listY = this.y + 32;
        int listW = this.w - 24;
        int listH = this.h - 80;
        if (mouseX >= (double)listX && mouseX <= (double)(listX + listW) && mouseY >= (double)listY && mouseY < (double)(listY + listH)) {
            int lineH = 36;
            int index = this.listScroll + ((int)mouseY - listY - 4) / lineH;
            if (index >= 0 && index < this.questLinks.size()) {
                this.selectedIndex = index;
            }
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        int listX = this.x + 12;
        int listY = this.y + 32;
        int listW = this.w - 24;
        int listH = this.h - 80;
        if (mouseX >= (double)listX && mouseX <= (double)(listX + listW) && mouseY >= (double)listY && mouseY < (double)(listY + listH)) {
            this.listScroll = (int)Math.max(0.0, (double)this.listScroll - Math.signum(delta));
            return true;
        }
        return false;
    }
}

