/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.texboobcat.questory.client.gui.FormattedTextWithImages;
import org.texboobcat.questory.client.gui.ImageRenderer;
import org.texboobcat.questory.client.gui.QuestEditorScreen;
import org.texboobcat.questory.client.gui.TabPanel;
import org.texboobcat.questory.client.gui.TextFormatter;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.quest.Requirement;
import org.texboobcat.questory.quest.Reward;

public class PreviewTabPanel
extends TabPanel {
    private Quest previewQuest;

    public PreviewTabPanel(QuestEditorScreen editor, int x, int y, int w, int h) {
        super(editor, x, y, w, h);
    }

    @Override
    public void loadFromQuest(Quest quest) {
        this.previewQuest = quest;
    }

    @Override
    public void saveToQuest(Quest quest) {
    }

    @Override
    public void render(class_332 g, int mouseX, int mouseY, float partialTick) {
        if (this.previewQuest == null) {
            g.method_25300(this.getFont(), "\u00a77No quest loaded", this.x + this.w / 2, this.y + this.h / 2, -1);
            return;
        }
        int contentX = this.x + 20;
        int contentY = this.y + 20;
        int contentW = this.w - 40;
        g.method_44379(this.x, this.y, this.x + this.w, this.y + this.h);
        class_5250 titleComponent = class_2561.method_43470((String)"\u00a7l\u00a76").method_10852(TextFormatter.parse(this.previewQuest.getTitle()));
        g.method_27535(this.getFont(), (class_2561)titleComponent, contentX, contentY, -1);
        g.method_25303(this.getFont(), "\u00a77ID: \u00a7f" + this.previewQuest.getId(), contentX, contentY += 20, -1);
        g.method_25303(this.getFont(), "\u00a77Group: \u00a7f" + this.previewQuest.getGroup(), contentX, contentY += 12, -1);
        g.method_25303(this.getFont(), "\u00a77Position: \u00a7f" + this.previewQuest.getX() + ", " + this.previewQuest.getY(), contentX, contentY += 12, -1);
        g.method_25303(this.getFont(), "\u00a77Hidden: \u00a7f" + (this.previewQuest.isHidden() ? "Yes" : "No"), contentX, contentY += 12, -1);
        g.method_25303(this.getFont(), "\u00a7lDescription:", contentX, contentY += 20, -86);
        contentY += 12;
        String desc = this.previewQuest.getDescription();
        if (!desc.isEmpty()) {
            FormattedTextWithImages formatted = TextFormatter.parseWithImages(desc);
            List lines = this.getFont().method_1728((class_5348)formatted.getTextComponent(), contentW - 40);
            int textStartY = contentY;
            for (class_5481 line : lines) {
                g.method_35720(this.getFont(), line, contentX + 4, contentY, -1);
                contentY += 10;
            }
            if (formatted.hasImages()) {
                int imageHeight = ImageRenderer.renderAllImages(g, formatted, contentX + 4, textStartY, contentW - 40, 10);
                contentY += imageHeight;
            }
            contentY += 2;
        } else {
            g.method_25303(this.getFont(), "\u00a77No description", contentX + 4, contentY, -3355444);
            contentY += 12;
        }
        contentY += 8;
        if (!this.previewQuest.getDependencies().isEmpty()) {
            g.method_25303(this.getFont(), "\u00a7lDependencies (" + this.previewQuest.getDependencies().size() + "):", contentX, contentY, -86);
            contentY += 12;
            for (String dep : this.previewQuest.getDependencies()) {
                g.method_25303(this.getFont(), "  \u00a77\u2192 \u00a7f" + dep, contentX + 4, contentY, -1);
                contentY += 10;
            }
            contentY += 8;
        }
        if (!this.previewQuest.getRequirements().isEmpty()) {
            g.method_25303(this.getFont(), "\u00a7lRequirements (" + this.previewQuest.getRequirements().size() + "):", contentX, contentY, -86);
            contentY += 12;
            int reqNum = 1;
            for (Requirement req : this.previewQuest.getRequirements()) {
                g.method_25303(this.getFont(), "  \u00a77" + reqNum + ". \u00a7f[" + req.getType().toUpperCase() + "]", contentX + 4, contentY, -1);
                contentY += 10;
                if (++reqNum <= 5) continue;
                g.method_25303(this.getFont(), "  \u00a77... and " + (this.previewQuest.getRequirements().size() - 5) + " more", contentX + 4, contentY, -7829368);
                contentY += 10;
                break;
            }
            contentY += 8;
        }
        if (!this.previewQuest.getRewards().isEmpty()) {
            g.method_25303(this.getFont(), "\u00a7lRewards (" + this.previewQuest.getRewards().size() + "):", contentX, contentY, -86);
            contentY += 12;
            int rwdNum = 1;
            for (Reward rwd : this.previewQuest.getRewards()) {
                g.method_25303(this.getFont(), "  \u00a77" + rwdNum + ". \u00a7f[" + rwd.getType().toUpperCase() + "]", contentX + 4, contentY, -1);
                contentY += 10;
                if (++rwdNum <= 5) continue;
                g.method_25303(this.getFont(), "  \u00a77... and " + (this.previewQuest.getRewards().size() - 5) + " more", contentX + 4, contentY, -7829368);
                contentY += 10;
                break;
            }
            contentY += 8;
        }
        g.method_25303(this.getFont(), "\u00a7lAdvanced Properties:", contentX, contentY += 4, -86);
        g.method_25303(this.getFont(), "\u00a77Shape: \u00a7f" + (this.previewQuest.getShape().isEmpty() ? "default" : this.previewQuest.getShape()), contentX + 4, contentY += 12, -1);
        g.method_25303(this.getFont(), "\u00a77Size: \u00a7f" + this.previewQuest.getSize(), contentX + 4, contentY += 10, -1);
        g.method_25303(this.getFont(), "\u00a77Optional: \u00a7f" + (this.previewQuest.isOptional() ? "Yes" : "No"), contentX + 4, contentY += 10, -1);
        g.method_25303(this.getFont(), "\u00a77Can Repeat: \u00a7f" + this.previewQuest.getCanRepeat(), contentX + 4, contentY += 10, -1);
        g.method_44380();
    }
}

