/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import dev.architectury.platform.Platform;
import java.util.UUID;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.questory.client.ClientTeamManager;
import org.texboobcat.questory.client.gui.TeamJoinScreen;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.network.TeamCreatePacket;
import org.texboobcat.questory.team.QuestTeam;

public class TeamCreationScreen
extends class_437 {
    private static final int WINDOW_WIDTH = 320;
    private int windowHeight;
    private static final int UI_MARGIN = 16;
    private static final int UI_FIELD_HEIGHT = 20;
    private final class_437 parent;
    private int leftPos;
    private int topPos;
    private class_342 teamNameBox;
    private class_342 descriptionBox;
    private class_342 colorHexBox;
    private class_4185 createButton;
    private class_4185 cancelButton;
    private class_4185 joinTeamButton;
    private String errorMessage = null;
    private boolean showFtbExtras = false;
    private int nameY;
    private int descY;
    private int colorY;

    public TeamCreationScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Create Team"));
        this.parent = parent;
    }

    private boolean isExtrasEnabled() {
        return Platform.isModLoaded((String)"ftbteams");
    }

    protected void method_25426() {
        this.showFtbExtras = this.isExtrasEnabled();
        this.windowHeight = this.showFtbExtras ? 300 : 200;
        this.leftPos = (this.field_22789 - 320) / 2;
        this.topPos = (this.field_22790 - this.windowHeight) / 2;
        int margin = 16;
        int fieldWidth = 288;
        int fieldHeight = 20;
        int gap = 32;
        int labelOffset = 20;
        this.nameY = this.topPos + 62;
        this.teamNameBox = new class_342(this.field_22793, this.leftPos + 16, this.nameY, 288, 20, (class_2561)class_2561.method_43470((String)"Team Name"));
        this.teamNameBox.method_1880(32);
        this.teamNameBox.method_47404((class_2561)class_2561.method_43470((String)"Enter team name..."));
        this.teamNameBox.method_1863(this::onNameChanged);
        this.method_25429((class_364)this.teamNameBox);
        this.method_48265((class_364)this.teamNameBox);
        if (this.showFtbExtras) {
            this.descY = this.nameY + 20 + 32;
            this.descriptionBox = new class_342(this.field_22793, this.leftPos + 16, this.descY, 288, 20, (class_2561)class_2561.method_43470((String)"Description"));
            this.descriptionBox.method_1880(120);
            this.descriptionBox.method_47404((class_2561)class_2561.method_43470((String)"Optional description..."));
            this.method_25429((class_364)this.descriptionBox);
            this.colorY = this.descY + 20 + 32;
            this.colorHexBox = new class_342(this.field_22793, this.leftPos + 16, this.colorY, 288, 20, (class_2561)class_2561.method_43470((String)"Color Hex"));
            this.colorHexBox.method_1880(7);
            this.colorHexBox.method_47404((class_2561)class_2561.method_43470((String)"Optional color, e.g. #FF8800"));
            this.method_25429((class_364)this.colorHexBox);
        } else {
            this.descriptionBox = null;
            this.colorHexBox = null;
            this.colorY = -1;
            this.descY = -1;
        }
        this.createButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Create"), btn -> this.createTeam()).method_46434(this.leftPos + 16, this.topPos + this.windowHeight - 48, 150, 22).method_46431();
        this.method_37063((class_364)this.createButton);
        this.createButton.field_22763 = false;
        this.cancelButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), btn -> this.method_25419()).method_46434(this.leftPos + 320 - 166, this.topPos + this.windowHeight - 48, 150, 22).method_46431();
        this.method_37063((class_364)this.cancelButton);
        this.joinTeamButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Join Team"), btn -> this.openJoinTeamScreen()).method_46434(this.leftPos + 16, this.topPos + this.windowHeight - 80, 288, 22).method_46431();
        this.method_37063((class_364)this.joinTeamButton);
        this.updateJoinButtonState();
    }

    private void updateJoinButtonState() {
        ClientTeamManager clientMgr = ClientTeamManager.getInstance();
        boolean hasPendingInvites = clientMgr.hasPendingInvites();
        this.joinTeamButton.field_22763 = true;
        if (hasPendingInvites) {
            int count;
            this.joinTeamButton.method_25355((class_2561)class_2561.method_43470((String)("Join Team (" + count + " invite" + ((count = clientMgr.getPendingInviteCount()) > 1 ? "s" : "") + ")")));
        }
    }

    private void openJoinTeamScreen() {
        this.field_22787.method_1507((class_437)new TeamJoinScreen(this.parent));
    }

    private void onNameChanged(String name) {
        this.errorMessage = null;
        if (name.length() < 3) {
            this.createButton.field_22763 = false;
            if (name.length() > 0) {
                this.errorMessage = "Name too short (min 3)";
            }
        } else if (name.length() > 32) {
            this.createButton.field_22763 = false;
            this.errorMessage = "Name too long (max 32)";
        } else if (!name.matches("[a-zA-Z0-9 _-]+")) {
            this.createButton.field_22763 = false;
            this.errorMessage = "Invalid characters";
        } else {
            this.createButton.field_22763 = true;
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(graphics);
        graphics.method_25294(this.leftPos, this.topPos, this.leftPos + 320, this.topPos + this.windowHeight, -872415232);
        graphics.method_25294(this.leftPos, this.topPos, this.leftPos + 320, this.topPos + 25, -14540254);
        int titleWidth = this.field_22793.method_1727("Create New Team");
        graphics.method_25303(this.field_22793, "Create New Team", this.leftPos + (320 - titleWidth) / 2, this.topPos + 8, 0xFFFFFF);
        int labelOffset = 16;
        graphics.method_25303(this.field_22793, "Team Name:", this.leftPos + 16, this.nameY - 16, 0xFFFFFF);
        if (this.showFtbExtras) {
            int headerY = this.descY - 22;
            graphics.method_25303(this.field_22793, "\u00a77Optional settings", this.leftPos + 16, headerY, 0xAAAAAA);
        }
        int lastFieldBottom = this.showFtbExtras ? this.colorY + 20 : this.nameY + 20;
        int hintY = lastFieldBottom + 22;
        if (this.errorMessage == null) {
            graphics.method_25303(this.field_22793, "\u00a77(3-32 characters)", this.leftPos + 16, hintY, 0x888888);
        } else {
            graphics.method_25303(this.field_22793, "\u00a7c" + this.errorMessage, this.leftPos + 16, hintY, 0xFF5555);
        }
        this.teamNameBox.method_25394(graphics, mouseX, mouseY, partialTick);
        if (this.showFtbExtras && this.descriptionBox != null) {
            this.descriptionBox.method_25394(graphics, mouseX, mouseY, partialTick);
        }
        if (this.showFtbExtras && this.colorHexBox != null) {
            this.colorHexBox.method_25394(graphics, mouseX, mouseY, partialTick);
        }
        super.method_25394(graphics, mouseX, mouseY, partialTick);
    }

    private void createTeam() {
        String colorStr;
        String teamName = this.teamNameBox.method_1882().trim();
        String description = this.showFtbExtras && this.descriptionBox != null ? this.descriptionBox.method_1882().trim() : "";
        String string = colorStr = this.showFtbExtras && this.colorHexBox != null ? this.colorHexBox.method_1882().trim() : "";
        if (teamName.length() >= 3 && teamName.length() <= 32) {
            Integer colorRGB = null;
            if (this.showFtbExtras && !colorStr.isEmpty()) {
                try {
                    String s;
                    String string2 = s = colorStr.startsWith("#") ? colorStr.substring(1) : colorStr;
                    if (s.length() != 6) {
                        this.errorMessage = "Invalid color (use #RRGGBB)";
                        return;
                    }
                    int rgb = Integer.parseInt(s, 16);
                    colorRGB = rgb & 0xFFFFFF;
                }
                catch (Exception ex) {
                    this.errorMessage = "Invalid color (use #RRGGBB)";
                    return;
                }
            }
            TeamCreatePacket packet = new TeamCreatePacket(teamName, description.isEmpty() ? null : description, colorRGB);
            NetworkManager.sendToServer(packet);
            ClientTeamManager clientTeamMgr = ClientTeamManager.getInstance();
            QuestTeam tempTeam = new QuestTeam(UUID.randomUUID(), teamName, class_310.method_1551().field_1724.method_5667());
            clientTeamMgr.setCurrentTeam(tempTeam);
            clientTeamMgr.setCurrentPlayerId(class_310.method_1551().field_1724.method_5667());
            this.method_25419();
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257 && this.createButton.field_22763) {
            this.createTeam();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25421() {
        return false;
    }
}

