/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.questory.manager.TriggerListenerManager;

public class TriggerPickerScreen
extends class_437 {
    private final class_437 parent;
    private final Consumer<String> onSelect;
    private final List<String> allTriggers;
    private List<String> filteredTriggers;
    private class_342 searchBox;
    private int scroll = 0;
    private boolean draggingScrollbar = false;

    public TriggerPickerScreen(class_437 parent, Consumer<String> onSelect) {
        super((class_2561)class_2561.method_43470((String)"Select Trigger"));
        this.parent = parent;
        this.onSelect = onSelect;
        this.allTriggers = TriggerListenerManager.getInstance().getKnownTriggerIds().stream().map(class_2960::toString).sorted().collect(Collectors.toList());
        this.filteredTriggers = new ArrayList<String>(this.allTriggers);
    }

    protected void method_25426() {
        super.method_25426();
        int panelW = 300;
        int panelH = 400;
        int panelX = this.field_22789 / 2 - panelW / 2;
        int panelY = this.field_22790 / 2 - panelH / 2;
        this.searchBox = new class_342(this.field_22793, panelX + 10, panelY + 30, panelW - 20, 20, (class_2561)class_2561.method_43470((String)"Search"));
        this.searchBox.method_1863(this::updateFilter);
        this.method_37063((class_364)this.searchBox);
        int btnW = 80;
        int btnX = this.field_22789 / 2 - btnW / 2;
        int btnY = panelY + panelH - 28;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), b -> this.field_22787.method_1507(this.parent)).method_46434(btnX, btnY, btnW, 20).method_46431());
    }

    private void updateFilter(String query) {
        if (query.isBlank()) {
            this.filteredTriggers = new ArrayList<String>(this.allTriggers);
        } else {
            String lower = query.toLowerCase();
            this.filteredTriggers = this.allTriggers.stream().filter(t -> t.toLowerCase().contains(lower)).collect(Collectors.toList());
        }
        this.scroll = 0;
    }

    public void method_25394(class_332 g, int mouseX, int mouseY, float partialTick) {
        this.method_25420(g);
        int panelW = 300;
        int panelH = 400;
        int panelX = this.field_22789 / 2 - panelW / 2;
        int panelY = this.field_22790 / 2 - panelH / 2;
        g.method_25294(panelX, panelY, panelX + panelW, panelY + panelH, -535818224);
        g.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, panelY + 10, -1);
        int listY = panelY + 60;
        int listH = panelH - 100;
        int lineH = 15;
        g.method_44379(panelX, listY, panelX + panelW, listY + listH);
        int maxVisible = listH / lineH;
        this.scroll = Math.max(0, Math.min(this.scroll, Math.max(0, this.filteredTriggers.size() - maxVisible)));
        for (int i = 0; i < Math.min(maxVisible, this.filteredTriggers.size() - this.scroll); ++i) {
            boolean hover;
            int index = this.scroll + i;
            String trigger = this.filteredTriggers.get(index);
            int itemY = listY + i * lineH;
            boolean bl = hover = mouseX >= panelX + 8 && mouseX <= panelX + panelW - 8 && mouseY >= itemY && mouseY < itemY + lineH;
            if (hover) {
                g.method_25294(panelX + 8, itemY, panelX + panelW - 8, itemY + lineH, -12952966);
            }
            g.method_25303(this.field_22793, trigger, panelX + 12, itemY + 4, -1);
        }
        g.method_44380();
        int total = this.filteredTriggers.size();
        if (total > maxVisible) {
            int barW = 6;
            int trackX = panelX + panelW - 8 - barW;
            int trackY = listY;
            int trackH = listH;
            g.method_25294(trackX, trackY, trackX + barW, trackY + trackH, 0x40222222);
            int thumbH = Math.max(12, (int)((float)trackH * (float)maxVisible / (float)total));
            int maxScroll = total - maxVisible;
            int thumbMax = trackH - thumbH;
            int thumbY = trackY + (maxScroll == 0 ? 0 : (int)((float)this.scroll / (float)maxScroll * (float)thumbMax));
            g.method_25294(trackX + 1, thumbY, trackX + barW - 1, thumbY + thumbH, this.draggingScrollbar ? -9787695 : -7829368);
        }
        super.method_25394(g, mouseX, mouseY, partialTick);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int total;
        int index;
        int panelW = 300;
        int panelH = 400;
        int panelX = this.field_22789 / 2 - panelW / 2;
        int panelY = this.field_22790 / 2 - panelH / 2;
        int listY = panelY + 60;
        int listH = panelH - 100;
        int lineH = 15;
        int maxVisible = listH / lineH;
        if (mouseX >= (double)(panelX + 8) && mouseX <= (double)(panelX + panelW - 8) && mouseY >= (double)listY && mouseY < (double)(listY + listH) && (index = this.scroll + ((int)mouseY - listY) / lineH) >= 0 && index < this.filteredTriggers.size()) {
            this.onSelect.accept(this.filteredTriggers.get(index));
            this.field_22787.method_1507(this.parent);
            return true;
        }
        int barW = 6;
        int trackX = panelX + panelW - 8 - barW;
        if (mouseX >= (double)trackX && mouseX <= (double)(trackX + barW) && mouseY >= (double)listY && mouseY < (double)(listY + listH) && (total = this.filteredTriggers.size()) > maxVisible) {
            int thumbH = Math.max(12, (int)((float)listH * (float)maxVisible / (float)total));
            int thumbMax = listH - thumbH;
            double rel = (mouseY - (double)listY - (double)thumbH / 2.0) / (double)Math.max(1, thumbMax);
            rel = Math.max(0.0, Math.min(1.0, rel));
            int maxScroll = total - maxVisible;
            this.scroll = (int)Math.round(rel * (double)maxScroll);
            this.draggingScrollbar = true;
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        int panelW = 300;
        int panelH = 400;
        int panelX = this.field_22789 / 2 - panelW / 2;
        int panelY = this.field_22790 / 2 - panelH / 2;
        if (mouseX >= (double)panelX && mouseX <= (double)(panelX + panelW) && mouseY >= (double)panelY && mouseY <= (double)(panelY + panelH)) {
            this.scroll = (int)Math.max(0.0, (double)this.scroll - Math.signum(delta));
            return true;
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.draggingScrollbar) {
            return super.method_25403(mouseX, mouseY, button, dragX, dragY);
        }
        int panelW = 300;
        int panelH = 400;
        int panelX = this.field_22789 / 2 - panelW / 2;
        int panelY = this.field_22790 / 2 - panelH / 2;
        int listY = panelY + 60;
        int listH = panelH - 100;
        int lineH = 15;
        int maxVisible = Math.max(1, listH / lineH);
        int total = this.filteredTriggers.size();
        if (total > maxVisible) {
            int thumbH = Math.max(12, (int)((float)listH * (float)maxVisible / (float)total));
            int thumbMax = listH - thumbH;
            double rel = (mouseY - (double)listY - (double)thumbH / 2.0) / (double)Math.max(1, thumbMax);
            rel = Math.max(0.0, Math.min(1.0, rel));
            int maxScroll = total - maxVisible;
            this.scroll = (int)Math.round(rel * (double)maxScroll);
            return true;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.draggingScrollbar) {
            this.draggingScrollbar = false;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25421() {
        return false;
    }
}

