/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui.editor;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.questory.client.gui.editor.AutoSaveManager;

public class AutoSaveHistoryScreen
extends class_437 {
    private final class_437 parent;
    private final AutoSaveManager autoSaveManager;
    private List<AutoSaveManager.AutoSaveEntry> history;
    private int scroll = 0;
    private class_4185 refreshBtn;
    private class_4185 clearBtn;
    private class_4185 closeBtn;
    private static final int ENTRY_HEIGHT = 40;
    private static final int PADDING = 10;

    public AutoSaveHistoryScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Auto-Save History"));
        this.parent = parent;
        this.autoSaveManager = AutoSaveManager.getInstance();
        this.refreshHistory();
    }

    private void refreshHistory() {
        this.history = this.autoSaveManager.getAutoSaveHistory();
        Collections.reverse(this.history);
    }

    protected void method_25426() {
        super.method_25426();
        int btnY = this.field_22790 - 35;
        int btnWidth = 80;
        int btnSpacing = 10;
        int centerX = this.field_22789 / 2;
        this.refreshBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Refresh"), b -> {
            this.refreshHistory();
            this.scroll = 0;
        }).method_46434(centerX - btnWidth - btnSpacing - btnWidth / 2, btnY, btnWidth, 20).method_46431());
        this.clearBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Clear All"), b -> {
            if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)"\u00a7eHistory is automatically pruned to 100 entries"));
            }
        }).method_46434(centerX - btnWidth / 2, btnY, btnWidth, 20).method_46431());
        this.closeBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Close"), b -> this.method_25419()).method_46434(centerX + btnWidth / 2 + btnSpacing, btnY, btnWidth, 20).method_46431());
    }

    public void method_25394(class_332 g, int mouseX, int mouseY, float partialTick) {
        this.method_25420(g);
        g.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, -1);
        String info = String.format("\u00a77Showing %d entries | Auto-Save Status: %s", this.history.size(), this.autoSaveManager.getStatusString());
        g.method_25300(this.field_22793, info, this.field_22789 / 2, 30, -1);
        int listTop = 50;
        int listBottom = this.field_22790 - 50;
        int listHeight = listBottom - listTop;
        int listWidth = Math.min(700, this.field_22789 - 40);
        int listX = this.field_22789 / 2 - listWidth / 2;
        g.method_25294(listX, listTop, listX + listWidth, listBottom, -587202560);
        g.method_44379(listX, listTop, listX + listWidth, listBottom);
        int maxVisibleEntries = listHeight / 40;
        this.scroll = Math.max(0, Math.min(this.scroll, Math.max(0, this.history.size() - maxVisibleEntries)));
        if (this.history.isEmpty()) {
            g.method_25300(this.field_22793, "\u00a77No auto-save history yet", this.field_22789 / 2, listTop + 20, -1);
        } else {
            int y = listTop + 10;
            for (int i = this.scroll; i < Math.min(this.scroll + maxVisibleEntries + 1, this.history.size()); ++i) {
                AutoSaveManager.AutoSaveEntry entry = this.history.get(i);
                this.renderEntry(g, entry, listX + 10, y, listWidth - 20, mouseX, mouseY);
                y += 40;
            }
        }
        g.method_44380();
        if (this.history.size() > maxVisibleEntries) {
            String scrollInfo = String.format("\u00a77(%d-%d of %d)", this.scroll + 1, Math.min(this.scroll + maxVisibleEntries, this.history.size()), this.history.size());
            g.method_25303(this.field_22793, scrollInfo, listX + listWidth - this.field_22793.method_1727(scrollInfo) - 5, listTop - 15, -5592406);
        }
        super.method_25394(g, mouseX, mouseY, partialTick);
    }

    private void renderEntry(class_332 g, AutoSaveManager.AutoSaveEntry entry, int x, int y, int width, int mouseX, int mouseY) {
        boolean hover = mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + 40 - 5;
        int bgColor = hover ? 0x33FFFFFF : 0x22FFFFFF;
        g.method_25294(x, y, x + width, y + 40 - 5, bgColor);
        String statusIcon = entry.isSuccess() ? "\u00a7a\u2713" : "\u00a7c\u2717";
        g.method_25303(this.field_22793, statusIcon, x + 5, y + 5, -1);
        String editorInfo = String.format("\u00a7f%s \u00a77| \u00a7f%s", entry.getEditorId(), entry.getEntityId());
        g.method_25303(this.field_22793, editorInfo, x + 20, y + 5, -1);
        SimpleDateFormat sdf = new SimpleDateFormat("MMM dd, HH:mm:ss");
        String timestamp = sdf.format(new Date(entry.getTimestamp()));
        String timeInfo = String.format("\u00a77%s (%s)", timestamp, entry.getAgeString());
        g.method_25303(this.field_22793, timeInfo, x + 20, y + 18, -1);
        if (!entry.isSuccess() && entry.getError() != null) {
            String error = "\u00a7c" + entry.getError();
            if (this.field_22793.method_1727(error) > width - 25) {
                error = this.field_22793.method_27523(error, width - 40) + "...";
            }
            g.method_25303(this.field_22793, error, x + 20, y + 28, -1);
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        int listTop = 50;
        int listBottom = this.field_22790 - 50;
        if (mouseY >= (double)listTop && mouseY <= (double)listBottom) {
            int maxVisibleEntries = (listBottom - listTop) / 40;
            int maxScroll = Math.max(0, this.history.size() - maxVisibleEntries);
            this.scroll = delta > 0.0 ? Math.max(0, this.scroll - 1) : Math.min(maxScroll, this.scroll + 1);
            return true;
        }
        return super.method_25401(mouseX, mouseY, delta);
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    public boolean method_25421() {
        return true;
    }
}

