/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui.editor;

import java.util.ArrayDeque;
import java.util.Deque;
import org.texboobcat.questory.client.gui.editor.EditorCommand;

public class EditorUndoManager {
    private static final int MAX_UNDO_SIZE = 50;
    private final Deque<EditorCommand> undoStack = new ArrayDeque<EditorCommand>();
    private final Deque<EditorCommand> redoStack = new ArrayDeque<EditorCommand>();

    public void executeCommand(EditorCommand command) {
        command.execute();
        this.undoStack.push(command);
        this.redoStack.clear();
        while (this.undoStack.size() > 50) {
            this.undoStack.removeLast();
        }
    }

    public boolean undo() {
        if (this.undoStack.isEmpty()) {
            return false;
        }
        EditorCommand command = this.undoStack.pop();
        command.undo();
        this.redoStack.push(command);
        return true;
    }

    public boolean redo() {
        if (this.redoStack.isEmpty()) {
            return false;
        }
        EditorCommand command = this.redoStack.pop();
        command.execute();
        this.undoStack.push(command);
        return true;
    }

    public boolean canUndo() {
        return !this.undoStack.isEmpty();
    }

    public boolean canRedo() {
        return !this.redoStack.isEmpty();
    }

    public String getUndoDescription() {
        return this.undoStack.isEmpty() ? "" : this.undoStack.peek().getDescription();
    }

    public String getRedoDescription() {
        return this.redoStack.isEmpty() ? "" : this.redoStack.peek().getDescription();
    }

    public void clear() {
        this.undoStack.clear();
        this.redoStack.clear();
    }
}

