/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui.editor;

import org.texboobcat.questory.client.gui.editor.AutoSaveManager;
import org.texboobcat.questory.client.gui.editor.EditorStateManager;

public interface ManagedEditor<T> {
    public EditorStateManager<T> getStateManager();

    public void saveEntity(T var1);

    default public void autoSaveEntity(T entity) {
        if (this.getStateManager().hasUnsavedChanges()) {
            this.saveEntity(entity);
        }
    }

    public String getEntityDisplayName(T var1);

    default public void onAutoSaveSuccess() {
    }

    default public void onAutoSaveFailure(Exception e) {
        System.err.println("[ManagedEditor] Auto-save failed: " + e.getMessage());
    }

    default public String getEditorId() {
        return this.getClass().getSimpleName();
    }

    default public boolean shouldAutoSave() {
        return this.getStateManager().hasUnsavedChanges();
    }

    default public boolean onEntitySwitch() {
        AutoSaveManager manager = AutoSaveManager.getInstance();
        if (manager.getConfig().saveOnEntitySwitch && this.getStateManager().hasUnsavedChanges()) {
            try {
                this.autoSaveEntity(this.getStateManager().getWorkingCopy());
                return true;
            }
            catch (Exception e) {
                this.onAutoSaveFailure(e);
                return false;
            }
        }
        return true;
    }

    default public boolean onEditorClose() {
        return !this.getStateManager().hasUnsavedChanges();
    }
}

