/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.rendering;

public class AnimationHelper {
    public static int getPulsingAlpha(int minAlpha, int maxAlpha, double speed) {
        double time = (double)System.currentTimeMillis() * speed;
        double sine = Math.sin(time);
        double normalized = (sine + 1.0) / 2.0;
        return (int)((double)minAlpha + (double)(maxAlpha - minAlpha) * normalized);
    }

    public static int getPulsingColor(int baseColor) {
        int alpha = AnimationHelper.getPulsingAlpha(140, 240, 0.003);
        return baseColor & 0xFFFFFF | alpha << 24;
    }

    public static float getWaveAnimation(double speed) {
        return (float)((Math.sin((double)System.currentTimeMillis() * speed) + 1.0) / 2.0);
    }

    public static float getScrollingOffset(double speed, float length) {
        double time = (double)System.currentTimeMillis() * speed;
        return (float)(time % (double)length / (double)length);
    }

    public static float getBounceAnimation(double speed, float amplitude) {
        return (float)(Math.abs(Math.sin((double)System.currentTimeMillis() * speed)) * (double)amplitude);
    }

    public static float getRotationAngle(double speed) {
        return (float)((double)System.currentTimeMillis() * speed % 360.0);
    }

    public static float smoothStep(float t) {
        return t * t * (3.0f - 2.0f * t);
    }

    public static float easeIn(float t) {
        return t * t;
    }

    public static float easeOut(float t) {
        return 1.0f - (1.0f - t) * (1.0f - t);
    }

    public static float elastic(float t) {
        return (float)(Math.sin(-20.420352248333657 * ((double)t + 1.0)) * Math.pow(2.0, -10.0 * (double)t) + 1.0);
    }

    public static float getTimedProgress(long startTime, long duration) {
        long elapsed = System.currentTimeMillis() - startTime;
        if (elapsed >= duration) {
            return 1.0f;
        }
        return (float)elapsed / (float)duration;
    }

    public static boolean isAnimationComplete(long startTime, long duration) {
        return System.currentTimeMillis() - startTime >= duration;
    }

    public static class Transition {
        private float startValue;
        private float targetValue;
        private float currentValue;
        private long startTime;
        private long duration;
        private boolean active;

        public Transition(float startValue, long duration) {
            this.startValue = startValue;
            this.currentValue = startValue;
            this.targetValue = startValue;
            this.duration = duration;
            this.active = false;
        }

        public void setTarget(float target) {
            if (target != this.targetValue) {
                this.startValue = this.currentValue;
                this.targetValue = target;
                this.startTime = System.currentTimeMillis();
                this.active = true;
            }
        }

        public float getValue() {
            if (!this.active) {
                return this.currentValue;
            }
            float progress = AnimationHelper.getTimedProgress(this.startTime, this.duration);
            if (progress >= 1.0f) {
                this.currentValue = this.targetValue;
                this.active = false;
                return this.currentValue;
            }
            progress = AnimationHelper.smoothStep(progress);
            this.currentValue = this.startValue + (this.targetValue - this.startValue) * progress;
            return this.currentValue;
        }

        public boolean isComplete() {
            return !this.active;
        }
    }

    public static class RewardAnimation {
        public static float getSpinAnimation() {
            return AnimationHelper.getRotationAngle(0.002);
        }

        public static int getGlowAlpha() {
            return AnimationHelper.getPulsingAlpha(100, 200, 0.004);
        }

        public static float getSparkleOffset(int index) {
            double phase = (double)index * Math.PI / 4.0;
            return (float)(Math.sin((double)System.currentTimeMillis() * 0.003 + phase) * 5.0);
        }
    }

    public static class QuestButtonAnimation {
        public static int getOutlineColor(boolean selected, boolean hovered) {
            if (selected || hovered) {
                return AnimationHelper.getPulsingColor(-1);
            }
            return -1;
        }

        public static float getHoverScale(boolean hovered, float maxScale) {
            if (!hovered) {
                return 1.0f;
            }
            float progress = AnimationHelper.getWaveAnimation(0.005);
            return 1.0f + (maxScale - 1.0f) * progress * 0.5f;
        }

        public static float getNotificationBounce() {
            return AnimationHelper.getBounceAnimation(0.004, 3.0f);
        }
    }

    public static class DependencyLineAnimation {
        private static final double DEFAULT_SPEED = 0.001;

        public static float getLineOffset(boolean selected, double customSpeed) {
            double speed;
            double d = speed = customSpeed > 0.0 ? customSpeed : 0.001;
            if (!selected) {
                speed *= 0.5;
            }
            return (float)((double)System.currentTimeMillis() * speed % 16.0);
        }

        public static int getLineAlpha(boolean completed, boolean selected) {
            if (completed) {
                return 255;
            }
            if (selected) {
                return AnimationHelper.getPulsingAlpha(180, 255, 0.002);
            }
            return 150;
        }

        public static int getAnimatedLineColor(int baseColor, boolean completed, boolean selected) {
            int alpha = DependencyLineAnimation.getLineAlpha(completed, selected);
            return baseColor & 0xFFFFFF | alpha << 24;
        }
    }

    public static class AnimationState {
        private long startTime;
        private long duration;
        private boolean running;
        private boolean loop;

        public AnimationState(long duration, boolean loop) {
            this.duration = duration;
            this.loop = loop;
            this.running = false;
        }

        public void start() {
            this.startTime = System.currentTimeMillis();
            this.running = true;
        }

        public void stop() {
            this.running = false;
        }

        public void reset() {
            this.startTime = System.currentTimeMillis();
        }

        public float getProgress() {
            if (!this.running) {
                return 0.0f;
            }
            long elapsed = System.currentTimeMillis() - this.startTime;
            if (elapsed >= this.duration) {
                if (this.loop) {
                    this.startTime = System.currentTimeMillis() - (elapsed - this.duration);
                    elapsed %= this.duration;
                } else {
                    this.running = false;
                    return 1.0f;
                }
            }
            return (float)elapsed / (float)this.duration;
        }

        public boolean isRunning() {
            return this.running;
        }

        public boolean isComplete() {
            return !this.running && !this.loop;
        }
    }
}

