/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.rendering.heatmap;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import org.texboobcat.questory.telemetry.HeatmapData;

public class HeatmapRenderer {
    private static final Map<Double, Integer> colorCache = new HashMap<Double, Integer>();

    public static int getColorForQuest(String questId, HeatmapData heatmapData) {
        if (heatmapData == null || !heatmapData.hasQuestData(questId)) {
            return -1;
        }
        double intensity = heatmapData.getIntensity(questId);
        return HeatmapRenderer.getColorFromIntensity(intensity);
    }

    public static int getColorFromIntensity(double intensity) {
        double key = (double)Math.round(intensity * 100.0) / 100.0;
        return colorCache.computeIfAbsent(key, HeatmapRenderer::calculateColor);
    }

    private static int calculateColor(double intensity) {
        intensity = Math.max(0.0, Math.min(1.0, intensity));
        double t = Math.log1p(intensity * 9.0) / Math.log(10.0);
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        if (t < 0.2) {
            float local = (float)(t / 0.2);
            r = 0.1f * local;
            g = 0.1f * local;
            b = 0.5f + 0.5f * local;
        } else if (t < 0.4) {
            float local = (float)((t - 0.2) / 0.2);
            r = 0.1f;
            g = 0.1f + 0.9f * local;
            b = 1.0f;
        } else if (t < 0.6) {
            float local = (float)((t - 0.4) / 0.2);
            r = 0.1f;
            g = 1.0f;
            b = 1.0f - 1.0f * local;
        } else if (t < 0.8) {
            float local = (float)((t - 0.6) / 0.2);
            r = 0.1f + 0.9f * local;
            g = 1.0f;
            b = 0.0f;
        } else {
            float local = (float)((t - 0.8) / 0.2);
            r = 1.0f;
            g = 1.0f - 1.0f * local;
            b = 0.0f;
        }
        return 0xFF000000 | (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f);
    }

    public static String formatTooltip(String questId, HeatmapData heatmapData) {
        if (heatmapData == null || !heatmapData.hasQuestData(questId)) {
            return "\u00a77No analytics data available";
        }
        int completions = heatmapData.getCompletionCount(questId);
        int uniquePlayers = heatmapData.getUniquePlayers(questId);
        double avgTimestampSeconds = heatmapData.getAvgCompletionTime(questId);
        StringBuilder tooltip = new StringBuilder();
        tooltip.append("\u00a76\u00a7lQuest Analytics\n");
        tooltip.append("\u00a77Completions: \u00a7f").append(completions).append("\n");
        tooltip.append("\u00a77Unique Players: \u00a7f").append(uniquePlayers).append("\n");
        if (avgTimestampSeconds > 0.0) {
            tooltip.append("\u00a77Avg Date: \u00a7f").append(HeatmapRenderer.formatDate((long)avgTimestampSeconds));
        }
        return tooltip.toString();
    }

    private static String formatDate(long epochSeconds) {
        try {
            Instant instant = Instant.ofEpochSecond(epochSeconds);
            ZonedDateTime zdt = instant.atZone(ZoneId.systemDefault());
            return DateTimeFormatter.ofPattern("yyyy-MM-dd").format(zdt);
        }
        catch (Exception e) {
            return "Unknown";
        }
    }

    public static void clearCache() {
        colorCache.clear();
    }
}

