/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.fabric.integration;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import org.texboobcat.questory.Questory;
import org.texboobcat.questory.events.QuestEvents;
import org.texboobcat.questory.integration.GameStagesHelper;

public class GameStagesIntegrationFabric
extends GameStagesHelper {
    private final boolean loaded;
    private Class<?> gameStageHelperClass;
    private Method hasStageMethod;
    private Method addStageMethod;
    private Method removeStageMethod;
    private Method getStagesMethod;
    private final Map<UUID, Set<String>> lastKnownStages = new HashMap<UUID, Set<String>>();
    private int tickCounter = 0;

    public GameStagesIntegrationFabric() {
        this.loaded = FabricLoader.getInstance().isModLoaded("gamestages");
        if (this.loaded) {
            try {
                this.initializeReflection();
                this.registerStageChangeDetection();
                Questory.LOGGER.info("[Questory] GameStages integration enabled (Fabric)");
            }
            catch (Throwable e) {
                Questory.LOGGER.error("[Questory] Failed to initialize GameStages integration: {}", (Object)e.getMessage(), (Object)e);
            }
        } else {
            Questory.LOGGER.info("[Questory] GameStages not found - stage features disabled");
        }
    }

    private void registerStageChangeDetection() {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            if (!this.isGameStagesLoaded()) {
                return;
            }
            if (++this.tickCounter >= 20) {
                this.tickCounter = 0;
                for (class_3222 player : server.method_3760().method_14571()) {
                    this.checkStageChanges(player);
                }
            }
        });
    }

    private void checkStageChanges(class_3222 player) {
        try {
            UUID playerId = player.method_5667();
            Collection<String> currentStages = this.getStages(player);
            HashSet<String> currentStageSet = new HashSet<String>(currentStages);
            Set previousStages = this.lastKnownStages.getOrDefault(playerId, new HashSet());
            for (String stage : currentStageSet) {
                if (previousStages.contains(stage)) continue;
                this.onStageAdded(player, stage);
            }
            for (String stage : previousStages) {
                if (currentStageSet.contains(stage)) continue;
                this.onStageRemoved(player, stage);
            }
            this.lastKnownStages.put(playerId, currentStageSet);
        }
        catch (Throwable e) {
            Questory.LOGGER.error("[Questory] Error in stage change detection: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void onStageAdded(class_3222 player, String stage) {
        try {
            QuestEvents.onStageChanged(player, stage, true);
        }
        catch (Throwable e) {
            Questory.LOGGER.error("[Questory] Error handling stage added: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void onStageRemoved(class_3222 player, String stage) {
        try {
            QuestEvents.onStageChanged(player, stage, false);
        }
        catch (Throwable e) {
            Questory.LOGGER.error("[Questory] Error handling stage removed: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void initializeReflection() throws Exception {
        this.gameStageHelperClass = Class.forName("net.darkhax.gamestages.GameStageHelper");
        this.hasStageMethod = this.gameStageHelperClass.getMethod("hasStage", class_1657.class, String.class);
        this.addStageMethod = this.gameStageHelperClass.getMethod("addStage", class_1657.class, String.class);
        this.removeStageMethod = this.gameStageHelperClass.getMethod("removeStage", class_1657.class, String.class);
        this.getStagesMethod = this.gameStageHelperClass.getMethod("getStages", class_1657.class);
    }

    @Override
    public boolean isGameStagesLoaded() {
        return this.loaded && this.gameStageHelperClass != null;
    }

    @Override
    public boolean hasStage(class_3222 player, String stage) {
        if (!this.isGameStagesLoaded()) {
            return false;
        }
        try {
            return (Boolean)this.hasStageMethod.invoke(null, player, stage);
        }
        catch (Throwable e) {
            Questory.LOGGER.error("[Questory] Error checking stage '{}': {}", (Object)stage, (Object)e.getMessage(), (Object)e);
            return false;
        }
    }

    @Override
    public void addStage(class_3222 player, String stage) {
        if (!this.isGameStagesLoaded()) {
            return;
        }
        try {
            this.addStageMethod.invoke(null, player, stage);
        }
        catch (Throwable e) {
            Questory.LOGGER.error("[Questory] Error adding stage '{}': {}", (Object)stage, (Object)e.getMessage(), (Object)e);
        }
    }

    @Override
    public void removeStage(class_3222 player, String stage) {
        if (!this.isGameStagesLoaded()) {
            return;
        }
        try {
            this.removeStageMethod.invoke(null, player, stage);
        }
        catch (Throwable e) {
            Questory.LOGGER.error("[Questory] Error removing stage '{}': {}", (Object)stage, (Object)e.getMessage(), (Object)e);
        }
    }

    @Override
    public Collection<String> getStages(class_3222 player) {
        if (!this.isGameStagesLoaded()) {
            return Collections.emptyList();
        }
        try {
            return (Collection)this.getStagesMethod.invoke(null, player);
        }
        catch (Throwable e) {
            Questory.LOGGER.error("[Questory] Error getting stages: {}", (Object)e.getMessage(), (Object)e);
            return Collections.emptyList();
        }
    }
}

