/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.integration;

import com.mojang.authlib.GameProfile;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3312;
import net.minecraft.server.MinecraftServer;

public class OPACClaimHelper {
    private static Boolean opacAvailable = null;

    public static boolean isAvailable() {
        if (opacAvailable == null) {
            try {
                Class.forName("xaero.pac.common.server.api.OpenPACServerAPI");
                opacAvailable = true;
            }
            catch (Throwable t) {
                opacAvailable = false;
            }
        }
        return opacAvailable;
    }

    public static void resetCache() {
        opacAvailable = null;
    }

    private static Object getAPI(MinecraftServer server) {
        if (!OPACClaimHelper.isAvailable() || server == null) {
            return null;
        }
        try {
            Class<?> apiClass = Class.forName("xaero.pac.common.server.api.OpenPACServerAPI");
            return apiClass.getMethod("get", MinecraftServer.class).invoke(null, server);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static Object getClaimsManager(Object api) {
        if (api == null) {
            return null;
        }
        try {
            return api.getClass().getMethod("getServerClaimsManager", new Class[0]).invoke(api, new Object[0]);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static Object getPartiesManager(Object api) {
        if (api == null) {
            return null;
        }
        try {
            return api.getClass().getMethod("getServerPartiesManager", new Class[0]).invoke(api, new Object[0]);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static Object getClaim(Object claimsManager, class_2960 dimension, int chunkX, int chunkZ) {
        if (claimsManager == null || dimension == null) {
            return null;
        }
        try {
            return claimsManager.getClass().getMethod("get", class_2960.class, Integer.TYPE, Integer.TYPE).invoke(claimsManager, dimension, chunkX, chunkZ);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static boolean isClaimed(class_3218 level, class_2338 pos) {
        if (!OPACClaimHelper.isAvailable() || level == null || pos == null) {
            return false;
        }
        try {
            Object api = OPACClaimHelper.getAPI(level.method_8503());
            Object claimsManager = OPACClaimHelper.getClaimsManager(api);
            if (claimsManager == null) {
                return false;
            }
            int chunkX = pos.method_10263() >> 4;
            int chunkZ = pos.method_10260() >> 4;
            class_2960 dimension = level.method_27983().method_29177();
            Object claim = OPACClaimHelper.getClaim(claimsManager, dimension, chunkX, chunkZ);
            return claim != null;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean isClaimedBy(class_3218 level, class_2338 pos, UUID ownerId) {
        if (!OPACClaimHelper.isAvailable() || level == null || pos == null || ownerId == null) {
            return false;
        }
        try {
            Object api = OPACClaimHelper.getAPI(level.method_8503());
            Object claimsManager = OPACClaimHelper.getClaimsManager(api);
            if (claimsManager == null) {
                return false;
            }
            int chunkX = pos.method_10263() >> 4;
            int chunkZ = pos.method_10260() >> 4;
            class_2960 dimension = level.method_27983().method_29177();
            Object claim = OPACClaimHelper.getClaim(claimsManager, dimension, chunkX, chunkZ);
            if (claim == null) {
                return false;
            }
            Object claimPlayerId = claim.getClass().getMethod("getPlayerId", new Class[0]).invoke(claim, new Object[0]);
            return ownerId.equals(claimPlayerId);
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean isForceloaded(class_3218 level, class_2338 pos) {
        if (!OPACClaimHelper.isAvailable() || level == null || pos == null) {
            return false;
        }
        try {
            Object api = OPACClaimHelper.getAPI(level.method_8503());
            Object claimsManager = OPACClaimHelper.getClaimsManager(api);
            if (claimsManager == null) {
                return false;
            }
            int chunkX = pos.method_10263() >> 4;
            int chunkZ = pos.method_10260() >> 4;
            class_2960 dimension = level.method_27983().method_29177();
            Object claim = OPACClaimHelper.getClaim(claimsManager, dimension, chunkX, chunkZ);
            if (claim == null) {
                return false;
            }
            try {
                Object result = claim.getClass().getMethod("isForceloadable", new Class[0]).invoke(claim, new Object[0]);
                if (result instanceof Boolean) {
                    return (Boolean)result;
                }
            }
            catch (NoSuchMethodException e) {
                try {
                    Object result = claim.getClass().getMethod("isForceloaded", new Class[0]).invoke(claim, new Object[0]);
                    if (result instanceof Boolean) {
                        return (Boolean)result;
                    }
                }
                catch (NoSuchMethodException e2) {
                    try {
                        Object result = claim.getClass().getMethod("getForceload", new Class[0]).invoke(claim, new Object[0]);
                        if (result instanceof Boolean) {
                            return (Boolean)result;
                        }
                    }
                    catch (NoSuchMethodException e3) {
                        return false;
                    }
                }
            }
            return false;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static UUID getClaimOwner(class_3218 level, class_2338 pos) {
        if (!OPACClaimHelper.isAvailable() || level == null || pos == null) {
            return null;
        }
        try {
            Object api = OPACClaimHelper.getAPI(level.method_8503());
            Object claimsManager = OPACClaimHelper.getClaimsManager(api);
            if (claimsManager == null) {
                return null;
            }
            int chunkX = pos.method_10263() >> 4;
            int chunkZ = pos.method_10260() >> 4;
            class_2960 dimension = level.method_27983().method_29177();
            Object claim = OPACClaimHelper.getClaim(claimsManager, dimension, chunkX, chunkZ);
            if (claim == null) {
                return null;
            }
            Object playerId = claim.getClass().getMethod("getPlayerId", new Class[0]).invoke(claim, new Object[0]);
            return playerId instanceof UUID ? (UUID)playerId : null;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static String getClaimOwnerName(class_3218 level, class_2338 pos) {
        if (!OPACClaimHelper.isAvailable() || level == null || pos == null) {
            return null;
        }
        try {
            UUID ownerId = OPACClaimHelper.getClaimOwner(level, pos);
            if (ownerId == null) {
                return null;
            }
            MinecraftServer server = level.method_8503();
            if (server != null) {
                class_3222 player = server.method_3760().method_14602(ownerId);
                if (player != null) {
                    return player.method_5477().getString();
                }
                try {
                    Optional optionalProfile;
                    class_3312 profile = server.method_3793();
                    if (profile != null && (optionalProfile = profile.method_14512(ownerId)).isPresent()) {
                        return ((GameProfile)optionalProfile.get()).getName();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return ownerId.toString().substring(0, 8);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static int getClaimCount(class_3222 player) {
        if (!OPACClaimHelper.isAvailable() || player == null) {
            return 0;
        }
        try {
            Object api = OPACClaimHelper.getAPI(player.method_5682());
            Object claimsManager = OPACClaimHelper.getClaimsManager(api);
            if (claimsManager == null) {
                return 0;
            }
            Object playerInfo = claimsManager.getClass().getMethod("getPlayerInfo", UUID.class).invoke(claimsManager, player.method_5667());
            if (playerInfo == null) {
                return 0;
            }
            Object count = playerInfo.getClass().getMethod("getClaimCount", new Class[0]).invoke(playerInfo, new Object[0]);
            return count instanceof Number ? ((Number)count).intValue() : 0;
        }
        catch (Throwable t) {
            return 0;
        }
    }

    public static int getForceloadCount(class_3222 player) {
        if (!OPACClaimHelper.isAvailable() || player == null) {
            return 0;
        }
        try {
            Object api = OPACClaimHelper.getAPI(player.method_5682());
            Object claimsManager = OPACClaimHelper.getClaimsManager(api);
            if (claimsManager == null) {
                return 0;
            }
            Object playerInfo = claimsManager.getClass().getMethod("getPlayerInfo", UUID.class).invoke(claimsManager, player.method_5667());
            if (playerInfo == null) {
                return 0;
            }
            Object count = playerInfo.getClass().getMethod("getForceloadCount", new Class[0]).invoke(playerInfo, new Object[0]);
            return count instanceof Number ? ((Number)count).intValue() : 0;
        }
        catch (Throwable t) {
            return 0;
        }
    }

    public static boolean isInPartyClaim(class_3222 player) {
        if (!OPACClaimHelper.isAvailable() || player == null) {
            return false;
        }
        try {
            Object api = OPACClaimHelper.getAPI(player.method_5682());
            if (api == null) {
                return false;
            }
            Object claimsManager = OPACClaimHelper.getClaimsManager(api);
            Object partiesManager = OPACClaimHelper.getPartiesManager(api);
            if (claimsManager == null || partiesManager == null) {
                return false;
            }
            Object party = partiesManager.getClass().getMethod("getPartyByMember", UUID.class).invoke(partiesManager, player.method_5667());
            if (party == null) {
                return false;
            }
            Object partyId = party.getClass().getMethod("getId", new Class[0]).invoke(party, new Object[0]);
            if (!(partyId instanceof UUID)) {
                return false;
            }
            class_3218 level = player.method_51469();
            int chunkX = player.method_31477() >> 4;
            int chunkZ = player.method_31479() >> 4;
            class_2960 dimension = level.method_27983().method_29177();
            Object claim = OPACClaimHelper.getClaim(claimsManager, dimension, chunkX, chunkZ);
            if (claim == null) {
                return false;
            }
            Object claimOwnerId = claim.getClass().getMethod("getPlayerId", new Class[0]).invoke(claim, new Object[0]);
            if (!(claimOwnerId instanceof UUID)) {
                return false;
            }
            Object ownerParty = partiesManager.getClass().getMethod("getPartyByMember", UUID.class).invoke(partiesManager, claimOwnerId);
            if (ownerParty == null) {
                return false;
            }
            Object ownerPartyId = ownerParty.getClass().getMethod("getId", new Class[0]).invoke(ownerParty, new Object[0]);
            return partyId.equals(ownerPartyId);
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static UUID getClaimPartyId(class_3218 level, class_2338 pos) {
        if (!OPACClaimHelper.isAvailable() || level == null || pos == null) {
            return null;
        }
        try {
            Object api = OPACClaimHelper.getAPI(level.method_8503());
            if (api == null) {
                return null;
            }
            Object claimsManager = OPACClaimHelper.getClaimsManager(api);
            Object partiesManager = OPACClaimHelper.getPartiesManager(api);
            if (claimsManager == null || partiesManager == null) {
                return null;
            }
            int chunkX = pos.method_10263() >> 4;
            int chunkZ = pos.method_10260() >> 4;
            class_2960 dimension = level.method_27983().method_29177();
            Object claim = OPACClaimHelper.getClaim(claimsManager, dimension, chunkX, chunkZ);
            if (claim == null) {
                return null;
            }
            Object claimOwnerId = claim.getClass().getMethod("getPlayerId", new Class[0]).invoke(claim, new Object[0]);
            if (!(claimOwnerId instanceof UUID)) {
                return null;
            }
            Object ownerParty = partiesManager.getClass().getMethod("getPartyByMember", UUID.class).invoke(partiesManager, claimOwnerId);
            if (ownerParty == null) {
                return null;
            }
            Object partyId = ownerParty.getClass().getMethod("getId", new Class[0]).invoke(ownerParty, new Object[0]);
            return partyId instanceof UUID ? (UUID)partyId : null;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static boolean canPlayerAccess(class_3222 player, class_3218 level, class_2338 pos) {
        if (!OPACClaimHelper.isAvailable() || player == null || level == null || pos == null) {
            return true;
        }
        try {
            if (!OPACClaimHelper.isClaimed(level, pos)) {
                return true;
            }
            if (OPACClaimHelper.isClaimedBy(level, pos, player.method_5667())) {
                return true;
            }
            return OPACClaimHelper.isInPartyClaim(player);
        }
        catch (Throwable t) {
            return true;
        }
    }

    public static int getClaimLimit(class_3222 player) {
        if (!OPACClaimHelper.isAvailable() || player == null) {
            return -1;
        }
        try {
            Object api = OPACClaimHelper.getAPI(player.method_5682());
            Object claimsManager = OPACClaimHelper.getClaimsManager(api);
            if (claimsManager == null) {
                return -1;
            }
            Object playerInfo = claimsManager.getClass().getMethod("getPlayerInfo", UUID.class).invoke(claimsManager, player.method_5667());
            if (playerInfo == null) {
                return -1;
            }
            try {
                Object limit = playerInfo.getClass().getMethod("getClaimsLimit", new Class[0]).invoke(playerInfo, new Object[0]);
                return limit instanceof Number ? ((Number)limit).intValue() : -1;
            }
            catch (NoSuchMethodException e) {
                return -1;
            }
        }
        catch (Throwable t) {
            return -1;
        }
    }

    public static int getForceloadLimit(class_3222 player) {
        if (!OPACClaimHelper.isAvailable() || player == null) {
            return -1;
        }
        try {
            Object api = OPACClaimHelper.getAPI(player.method_5682());
            Object claimsManager = OPACClaimHelper.getClaimsManager(api);
            if (claimsManager == null) {
                return -1;
            }
            Object playerInfo = claimsManager.getClass().getMethod("getPlayerInfo", UUID.class).invoke(claimsManager, player.method_5667());
            if (playerInfo == null) {
                return -1;
            }
            try {
                Object limit = playerInfo.getClass().getMethod("getForceloadLimit", new Class[0]).invoke(playerInfo, new Object[0]);
                return limit instanceof Number ? ((Number)limit).intValue() : -1;
            }
            catch (NoSuchMethodException e) {
                return -1;
            }
        }
        catch (Throwable t) {
            return -1;
        }
    }
}

