/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.integration;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.texboobcat.questory.Questory;
import org.texboobcat.questory.integration.OPACClaimHelper;

public class OPACProtectionHelper {
    public static boolean isAvailable() {
        return OPACClaimHelper.isAvailable();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean canBreakBlock(class_3222 player, class_3218 level, class_2338 pos) {
        if (!OPACProtectionHelper.isAvailable() || player == null || level == null || pos == null) {
            return true;
        }
        try {
            Object api = OPACProtectionHelper.getOPACAPI(level.method_8503());
            if (api == null) {
                return true;
            }
            Object chunkProtection = api.getClass().getMethod("getChunkProtection", new Class[0]).invoke(api, new Object[0]);
            if (chunkProtection == null) {
                return true;
            }
            Object result = chunkProtection.getClass().getMethod("hasChunkAccess", Class.forName("net.minecraft.server.level.ServerPlayer"), Class.forName("net.minecraft.core.BlockPos")).invoke(chunkProtection, player, pos);
            if (!(result instanceof Boolean)) return true;
            return (Boolean)result;
        }
        catch (NoSuchMethodException e) {}
        finally {
            return OPACProtectionHelper.checkAccessViaClaimOwnership(player, level, pos);
        }
    }

    public static boolean canPlaceBlock(class_3222 player, class_3218 level, class_2338 pos) {
        return OPACProtectionHelper.canBreakBlock(player, level, pos);
    }

    public static boolean canInteractWithEntity(class_3222 player, class_1297 entity) {
        if (!OPACProtectionHelper.isAvailable() || player == null || entity == null) {
            return true;
        }
        try {
            class_3218 level = player.method_51469();
            class_2338 entityPos = entity.method_24515();
            return OPACProtectionHelper.checkAccessViaClaimOwnership(player, level, entityPos);
        }
        catch (Throwable t) {
            return true;
        }
    }

    public static boolean canDamageEntityAt(class_3222 player, class_3218 level, class_2338 entityPos) {
        if (!OPACProtectionHelper.isAvailable() || player == null || level == null || entityPos == null) {
            return true;
        }
        try {
            Object api = OPACProtectionHelper.getOPACAPI(level.method_8503());
            if (api == null) {
                return true;
            }
            Object chunkProtection = api.getClass().getMethod("getChunkProtection", new Class[0]).invoke(api, new Object[0]);
            if (chunkProtection == null) {
                return true;
            }
            return OPACProtectionHelper.checkAccessViaClaimOwnership(player, level, entityPos);
        }
        catch (Throwable t) {
            return true;
        }
    }

    public static boolean canAccessContainer(class_3222 player, class_3218 level, class_2338 pos) {
        if (!OPACProtectionHelper.isAvailable() || player == null || level == null || pos == null) {
            return true;
        }
        try {
            return OPACProtectionHelper.checkAccessViaClaimOwnership(player, level, pos);
        }
        catch (Throwable t) {
            return true;
        }
    }

    private static boolean checkAccessViaClaimOwnership(class_3222 player, class_3218 level, class_2338 pos) {
        if (!OPACClaimHelper.isClaimed(level, pos)) {
            return true;
        }
        if (OPACClaimHelper.isClaimedBy(level, pos, player.method_5667())) {
            return true;
        }
        return OPACClaimHelper.isInPartyClaim(player);
    }

    public static boolean isProtected(class_3218 level, class_2338 pos) {
        return OPACClaimHelper.isClaimed(level, pos);
    }

    public static String getProtectionStatus(class_3218 level, class_2338 pos) {
        if (!OPACProtectionHelper.isAvailable()) {
            return "No protection (OPAC not installed)";
        }
        if (!OPACClaimHelper.isClaimed(level, pos)) {
            return "Unprotected (wilderness)";
        }
        String ownerName = OPACClaimHelper.getClaimOwnerName(level, pos);
        boolean isForceloaded = OPACClaimHelper.isForceloaded(level, pos);
        StringBuilder sb = new StringBuilder("Protected by ");
        sb.append(ownerName != null ? ownerName : "unknown");
        if (isForceloaded) {
            sb.append(" [Forceloaded]");
        }
        return sb.toString();
    }

    public static boolean isInteractionAllowed(class_3222 player, class_3218 level, class_2338 pos, InteractionType interactionType) {
        if (!OPACProtectionHelper.isAvailable() || player == null || level == null || pos == null) {
            return true;
        }
        return switch (interactionType.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> OPACProtectionHelper.canBreakBlock(player, level, pos);
            case 1, 4 -> OPACProtectionHelper.canDamageEntityAt(player, level, pos);
            case 3 -> OPACProtectionHelper.canAccessContainer(player, level, pos);
            case 2 -> OPACProtectionHelper.checkAccessViaClaimOwnership(player, level, pos);
        };
    }

    public static void registerQuestStructure(class_3218 level, class_2338 pos, String questId) {
        try {
            Questory.LOGGER.debug("Registered quest structure at {} for quest {}", (Object)pos, (Object)questId);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static Object getOPACAPI(MinecraftServer server) {
        if (server == null) {
            return null;
        }
        try {
            Class<?> apiClass = Class.forName("xaero.pac.common.server.api.OpenPACServerAPI");
            return apiClass.getMethod("get", MinecraftServer.class).invoke(null, server);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static boolean hasClaimException(class_3222 player, class_3218 level, class_2338 pos, String exceptionType) {
        if (!OPACProtectionHelper.isAvailable() || player == null || level == null || pos == null) {
            return false;
        }
        try {
            Object api = OPACProtectionHelper.getOPACAPI(level.method_8503());
            if (api == null) {
                return false;
            }
            Object claimsManager = api.getClass().getMethod("getServerClaimsManager", new Class[0]).invoke(api, new Object[0]);
            if (claimsManager == null) {
                return false;
            }
            int chunkX = pos.method_10263() >> 4;
            int chunkZ = pos.method_10260() >> 4;
            class_2960 dimension = level.method_27983().method_29177();
            Object claim = claimsManager.getClass().getMethod("get", class_2960.class, Integer.TYPE, Integer.TYPE).invoke(claimsManager, dimension, chunkX, chunkZ);
            if (claim == null) {
                return false;
            }
            Object playerId = claim.getClass().getMethod("getPlayerId", new Class[0]).invoke(claim, new Object[0]);
            return player.method_5667().equals(playerId);
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static Map<String, Object> getClaimInfo(class_3218 level, class_2338 pos) {
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("protected", false);
        info.put("owner", null);
        info.put("ownerName", null);
        info.put("forceloaded", false);
        info.put("partyOwned", false);
        if (!OPACProtectionHelper.isAvailable() || level == null || pos == null) {
            return info;
        }
        try {
            boolean isClaimed = OPACClaimHelper.isClaimed(level, pos);
            info.put("protected", isClaimed);
            if (isClaimed) {
                UUID owner = OPACClaimHelper.getClaimOwner(level, pos);
                info.put("owner", owner);
                info.put("ownerName", OPACClaimHelper.getClaimOwnerName(level, pos));
                info.put("forceloaded", OPACClaimHelper.isForceloaded(level, pos));
                UUID partyId = OPACClaimHelper.getClaimPartyId(level, pos);
                info.put("partyOwned", partyId != null);
                info.put("partyId", partyId);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return info;
    }

    public static enum InteractionType {
        BLOCK_INTERACTION,
        ENTITY_INTERACTION,
        ITEM_USE,
        CONTAINER_ACCESS,
        ENTITY_DAMAGE;

    }
}

