/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;

public class BiomeRequirement
extends Requirement {
    private String biomeId;
    private boolean isTag;

    public BiomeRequirement(String biomeId) {
        super("biome");
        this.isTag = biomeId.startsWith("#");
        this.biomeId = biomeId;
    }

    public String getBiomeId() {
        return this.biomeId;
    }

    public void setBiomeId(String biomeId) {
        this.biomeId = biomeId;
        this.isTag = biomeId.startsWith("#");
    }

    public boolean isTag() {
        return this.isTag;
    }

    @Override
    public boolean isMet(QuestProgress progress, String questId) {
        return progress.getRequirementProgress(questId, this) > 0;
    }

    @Override
    public String getProgressDisplay(QuestProgress progress, String questId) {
        boolean visited = progress.getRequirementProgress(questId, this) > 0;
        return (visited ? "\u2713" : "\u2717") + " Visit biome: " + (this.isTag ? this.biomeId.substring(1) : this.biomeId);
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        json.addProperty("biome", this.biomeId);
        return json;
    }

    public static BiomeRequirement fromJson(JsonObject json) {
        String biomeId = json.get("biome").getAsString();
        return new BiomeRequirement(biomeId);
    }
}

