/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;
import net.minecraft.class_3222;
import org.texboobcat.questory.integration.OPACClaimHelper;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;

public class ClaimCountRequirement
extends Requirement {
    private int requiredCount;
    private CountMode countMode;
    private String dimension;
    private String displayText;

    public ClaimCountRequirement(int requiredCount) {
        super("claim_count");
        this.requiredCount = Math.max(1, requiredCount);
        this.countMode = CountMode.CLAIMED;
        this.dimension = null;
        this.displayText = null;
    }

    public ClaimCountRequirement(int requiredCount, CountMode countMode) {
        super("claim_count");
        this.requiredCount = Math.max(1, requiredCount);
        this.countMode = countMode;
        this.dimension = null;
        this.displayText = null;
    }

    public int getRequiredCount() {
        return this.requiredCount;
    }

    public void setRequiredCount(int requiredCount) {
        this.requiredCount = Math.max(1, requiredCount);
    }

    public CountMode getCountMode() {
        return this.countMode;
    }

    public void setCountMode(CountMode countMode) {
        this.countMode = countMode;
    }

    public String getDimension() {
        return this.dimension;
    }

    public void setDimension(String dimension) {
        this.dimension = dimension;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public void setDisplayText(String displayText) {
        this.displayText = displayText;
    }

    public boolean isCountForceloaded() {
        return this.countMode == CountMode.FORCELOADED;
    }

    @Override
    public boolean isMet(QuestProgress progress, String questId) {
        return progress.getRequirementProgress(questId, this) >= this.requiredCount;
    }

    @Override
    public String getProgressDisplay(QuestProgress progress, String questId) {
        int current = progress.getRequirementProgress(questId, this);
        if (this.displayText != null && !this.displayText.isEmpty()) {
            return String.format("%d/%d %s", current, this.requiredCount, this.displayText);
        }
        String chunkType = this.countMode == CountMode.FORCELOADED ? "forceloaded chunks" : "claimed chunks";
        Object desc = String.format("%d/%d %s", current, this.requiredCount, chunkType);
        if (this.dimension != null && !this.dimension.isEmpty()) {
            String dimName = this.dimension.contains(":") ? this.dimension.substring(this.dimension.indexOf(58) + 1) : this.dimension;
            desc = (String)desc + " in " + dimName;
        }
        if (!OPACClaimHelper.isAvailable()) {
            desc = (String)desc + " \u00a77(requires OPAC mod)";
        }
        return desc;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        json.addProperty("required_count", (Number)this.requiredCount);
        json.addProperty("count_mode", this.countMode.name());
        if (this.dimension != null && !this.dimension.isEmpty()) {
            json.addProperty("dimension", this.dimension);
        }
        if (this.displayText != null && !this.displayText.isEmpty()) {
            json.addProperty("display_text", this.displayText);
        }
        return json;
    }

    public static ClaimCountRequirement fromJson(JsonObject json) {
        int count = json.has("required_count") ? json.get("required_count").getAsInt() : 1;
        CountMode mode = CountMode.CLAIMED;
        if (json.has("count_mode")) {
            try {
                mode = CountMode.valueOf(json.get("count_mode").getAsString());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (json.has("count_forceloaded") && json.get("count_forceloaded").getAsBoolean()) {
            mode = CountMode.FORCELOADED;
        }
        ClaimCountRequirement req = new ClaimCountRequirement(count, mode);
        if (json.has("dimension")) {
            req.setDimension(json.get("dimension").getAsString());
        }
        if (json.has("display_text")) {
            req.setDisplayText(json.get("display_text").getAsString());
        }
        return req;
    }

    public int getCurrentCount(class_3222 player) {
        if (player == null || !OPACClaimHelper.isAvailable()) {
            return 0;
        }
        return this.countMode == CountMode.FORCELOADED ? OPACClaimHelper.getForceloadCount(player) : OPACClaimHelper.getClaimCount(player);
    }

    public static ClaimCountRequirement claimed(int count) {
        return new ClaimCountRequirement(count, CountMode.CLAIMED);
    }

    public static ClaimCountRequirement forceloaded(int count) {
        return new ClaimCountRequirement(count, CountMode.FORCELOADED);
    }

    public static enum CountMode {
        CLAIMED,
        FORCELOADED;

    }
}

