/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;
import net.minecraft.class_1297;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import org.texboobcat.questory.config.QuestoryConfig;
import org.texboobcat.questory.integration.OPACPlaceholders;
import org.texboobcat.questory.quest.Reward;

public class CommandReward
extends Reward {
    private String command;
    private String displayName;

    public CommandReward(String command, String displayName) {
        super("command");
        this.command = command;
        this.displayName = displayName;
    }

    public String getCommand() {
        return this.command;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void grant(class_3222 player) {
        String processedCommand = this.command.replace("{player}", player.method_7334().getName()).replace("{uuid}", player.method_5845()).replace("{x}", String.valueOf((int)player.method_23317())).replace("{y}", String.valueOf((int)player.method_23318())).replace("{z}", String.valueOf((int)player.method_23321()));
        try {
            QuestoryConfig cfg = QuestoryConfig.getInstance();
            if (cfg.opacIntegrationEnabled && cfg.opacEnablePlaceholders) {
                processedCommand = OPACPlaceholders.process(processedCommand, player);
            }
        }
        catch (Throwable cfg) {
            // empty catch block
        }
        class_2168 source = new class_2168((class_2165)player, player.method_19538(), player.method_5802(), player.method_51469(), 4, player.method_5477().getString(), player.method_5476(), player.field_13995, (class_1297)player);
        try {
            player.field_13995.method_3734().method_44252(source, processedCommand);
        }
        catch (Exception e) {
            System.err.println("Failed to execute reward command: " + processedCommand);
            e.printStackTrace();
        }
    }

    @Override
    public String getDisplayString() {
        return this.displayName != null ? this.displayName : "Execute Command";
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.type);
        json.addProperty("command", this.command);
        if (this.displayName != null) {
            json.addProperty("displayName", this.displayName);
        }
        return json;
    }

    public static CommandReward fromJson(JsonObject json) {
        String command = json.get("command").getAsString();
        String displayName = json.has("displayName") ? json.get("displayName").getAsString() : null;
        return new CommandReward(command, displayName);
    }
}

