/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.class_3222;
import org.texboobcat.questory.manager.TriggerListenerManager;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;

public class GenericTriggerRequirement
extends Requirement {
    private final String triggerId;
    private final JsonObject conditions;

    public GenericTriggerRequirement(String triggerId, JsonObject conditions) {
        super("generic_trigger");
        this.triggerId = triggerId;
        this.conditions = conditions;
    }

    public GenericTriggerRequirement(String triggerId) {
        this(triggerId, new JsonObject());
    }

    public String getTriggerId() {
        return this.triggerId;
    }

    public JsonObject getConditions() {
        return this.conditions;
    }

    @Override
    public boolean isMet(QuestProgress progress, String questId) {
        return progress.getRequirementProgress(questId, this) > 0;
    }

    @Override
    public String getProgressDisplay(QuestProgress progress, String questId) {
        boolean met = this.isMet(progress, questId);
        return (met ? "\u2713" : "\u25cb") + " Trigger: " + this.triggerId;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        json.addProperty("trigger", this.triggerId);
        json.add("conditions", (JsonElement)this.conditions);
        return json;
    }

    public static GenericTriggerRequirement fromJson(JsonObject json) {
        String trigger = json.get("trigger").getAsString();
        JsonObject conditions = json.has("conditions") ? json.getAsJsonObject("conditions") : new JsonObject();
        return new GenericTriggerRequirement(trigger, conditions);
    }

    public void startListening(class_3222 player, String questId) {
        TriggerListenerManager.getInstance().registerListener(player, questId, this);
    }

    public void stopListening(class_3222 player) {
        TriggerListenerManager.getInstance().unregisterListener(player, this);
    }
}

