/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;

public class GroupNode {
    private String id;
    private String title;
    private String icon;
    private String color;
    private int order;
    private final List<GroupNode> children = new ArrayList<GroupNode>();
    private final List<String> groups = new ArrayList<String>();

    public GroupNode(String id, String title) {
        this.id = id;
        this.title = title;
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getColor() {
        return this.color;
    }

    public int getOrder() {
        return this.order;
    }

    public List<GroupNode> getChildren() {
        return this.children;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public JsonObject toJson() {
        JsonObject o = new JsonObject();
        o.addProperty("id", this.id);
        o.addProperty("title", this.title);
        if (this.icon != null) {
            o.addProperty("icon", this.icon);
        }
        if (this.color != null) {
            o.addProperty("color", this.color);
        }
        o.addProperty("order", (Number)this.order);
        JsonArray arrGroups = new JsonArray();
        for (String g : this.groups) {
            arrGroups.add(g);
        }
        o.add("groups", (JsonElement)arrGroups);
        JsonArray arrChildren = new JsonArray();
        for (GroupNode c : this.children) {
            arrChildren.add((JsonElement)c.toJson());
        }
        o.add("children", (JsonElement)arrChildren);
        return o;
    }

    public static GroupNode fromJson(JsonObject o) {
        String id = o.has("id") ? o.get("id").getAsString() : "";
        String title = o.has("title") ? o.get("title").getAsString() : id;
        GroupNode n = new GroupNode(id, title);
        if (o.has("icon")) {
            n.setIcon(o.get("icon").getAsString());
        }
        if (o.has("color")) {
            n.setColor(o.get("color").getAsString());
        }
        if (o.has("order")) {
            n.setOrder(o.get("order").getAsInt());
        }
        if (o.has("groups")) {
            o.getAsJsonArray("groups").forEach(e -> n.groups.add(e.getAsString()));
        }
        if (o.has("children")) {
            o.getAsJsonArray("children").forEach(e -> n.children.add(GroupNode.fromJson(e.getAsJsonObject())));
        }
        return n;
    }
}

