/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;

public class QuestLink {
    private String linkedQuestId;
    private int x;
    private int y;
    private String shape;
    private double size;

    public QuestLink(String linkedQuestId, int x, int y) {
        this.linkedQuestId = linkedQuestId;
        this.x = x;
        this.y = y;
        this.shape = "";
        this.size = 1.0;
    }

    public String getLinkedQuestId() {
        return this.linkedQuestId;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public String getShape() {
        return this.shape;
    }

    public double getSize() {
        return this.size;
    }

    public void setLinkedQuestId(String linkedQuestId) {
        this.linkedQuestId = linkedQuestId;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setShape(String shape) {
        this.shape = shape;
    }

    public void setSize(double size) {
        this.size = size;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("linked_quest", this.linkedQuestId);
        json.addProperty("x", (Number)this.x);
        json.addProperty("y", (Number)this.y);
        if (!this.shape.isEmpty()) {
            json.addProperty("shape", this.shape);
        }
        if (this.size != 1.0) {
            json.addProperty("size", (Number)this.size);
        }
        return json;
    }

    public static QuestLink fromJson(JsonObject json) {
        String linkedQuestId = json.get("linked_quest").getAsString();
        int x = json.get("x").getAsInt();
        int y = json.get("y").getAsInt();
        QuestLink link = new QuestLink(linkedQuestId, x, y);
        if (json.has("shape")) {
            link.setShape(json.get("shape").getAsString());
        }
        if (json.has("size")) {
            link.setSize(json.get("size").getAsDouble());
        }
        return link;
    }
}

