/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.texboobcat.questory.Questory;
import org.texboobcat.questory.config.QuestoryConfig;
import org.texboobcat.questory.quest.Requirement;

public class QuestProgress {
    private UUID playerId;
    private final Map<String, Map<String, Integer>> questRequirementProgress;
    private final Set<String> completedQuests;
    private final Map<String, Long> questCompletionTimes;
    private final Set<String> claimedRewards;
    private String lastCompletedDailyId = "";
    private final Map<String, Long> dailyHistory;

    public QuestProgress(UUID playerId) {
        this.playerId = playerId;
        this.questRequirementProgress = Collections.synchronizedMap(new HashMap());
        this.completedQuests = Collections.synchronizedSet(new HashSet());
        this.questCompletionTimes = Collections.synchronizedMap(new HashMap());
        this.claimedRewards = Collections.synchronizedSet(new HashSet());
        this.dailyHistory = Collections.synchronizedMap(new HashMap());
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public boolean isQuestCompleted(String questId) {
        return this.completedQuests.contains(questId);
    }

    public synchronized void completeQuest(String questId) {
        this.completedQuests.add(questId);
        this.questCompletionTimes.put(questId, System.currentTimeMillis());
    }

    public synchronized void resetQuest(String questId) {
        this.completedQuests.remove(questId);
        this.questCompletionTimes.remove(questId);
        this.questRequirementProgress.remove(questId);
        this.claimedRewards.removeIf(id -> id.startsWith(questId + "_"));
    }

    public Set<String> getCompletedQuests() {
        return new HashSet<String>(this.completedQuests);
    }

    public long getCompletionTime(String questId) {
        return this.questCompletionTimes.getOrDefault(questId, 0L);
    }

    public synchronized int getRequirementProgress(String questId, Requirement requirement) {
        String key = this.getRequirementKey(requirement);
        return this.questRequirementProgress.getOrDefault(questId, Collections.emptyMap()).getOrDefault(key, 0);
    }

    public synchronized void setRequirementProgress(String questId, Requirement requirement, int progress) {
        String key = this.getRequirementKey(requirement);
        if (QuestoryConfig.getInstance().debugMode) {
            Questory.LOGGER.debug("[Progress] Setting requirement progress: quest={}, reqId={}, reqType={}, progress={}", (Object)questId, (Object)key, (Object)requirement.getType(), (Object)progress);
        }
        this.questRequirementProgress.computeIfAbsent(questId, k -> Collections.synchronizedMap(new HashMap())).put(key, progress);
    }

    public synchronized void addRequirementProgress(String questId, Requirement requirement, int amount) {
        int current = this.getRequirementProgress(questId, requirement);
        this.setRequirementProgress(questId, requirement, current + amount);
    }

    private String getRequirementKey(Requirement requirement) {
        String id = requirement.getId();
        if (id == null || id.isEmpty()) {
            Questory.LOGGER.error("[Progress] Requirement has null/empty ID! Type={}", (Object)requirement.getType());
            return "ERROR_NO_ID_" + requirement.getType();
        }
        return id;
    }

    public synchronized void claimReward(String questId, String rewardId) {
        this.claimedRewards.add(questId + "_" + rewardId);
    }

    public synchronized boolean isRewardClaimed(String questId, String rewardId) {
        return this.claimedRewards.contains(questId + "_" + rewardId);
    }

    public boolean hasCompletedDaily(String dailyId) {
        if (dailyId == null || dailyId.isBlank()) {
            return false;
        }
        return dailyId.equals(this.lastCompletedDailyId) || this.dailyHistory.containsKey(dailyId);
    }

    public synchronized void markDailyCompleted(String dailyId) {
        if (dailyId == null || dailyId.isBlank()) {
            return;
        }
        this.lastCompletedDailyId = dailyId;
        this.dailyHistory.putIfAbsent(dailyId, System.currentTimeMillis());
    }

    public String getLastCompletedDailyId() {
        return this.lastCompletedDailyId;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("playerId", this.playerId.toString());
        JsonArray completedArray = new JsonArray();
        for (String string : this.completedQuests) {
            completedArray.add(string);
        }
        json.add("completed", (JsonElement)completedArray);
        JsonObject timesObj = new JsonObject();
        for (Map.Entry<String, Long> entry : this.questCompletionTimes.entrySet()) {
            timesObj.addProperty(entry.getKey(), (Number)entry.getValue());
        }
        json.add("completionTimes", (JsonElement)timesObj);
        JsonObject jsonObject = new JsonObject();
        for (Map.Entry<String, Map<String, Integer>> entry : this.questRequirementProgress.entrySet()) {
            JsonObject questProgressObj = new JsonObject();
            for (Map.Entry<String, Integer> reqEntry : entry.getValue().entrySet()) {
                questProgressObj.addProperty(reqEntry.getKey(), (Number)reqEntry.getValue());
            }
            jsonObject.add(entry.getKey(), (JsonElement)questProgressObj);
        }
        json.add("progress", (JsonElement)jsonObject);
        JsonArray jsonArray = new JsonArray();
        for (String questId : this.claimedRewards) {
            jsonArray.add(questId);
        }
        json.add("claimedRewards", (JsonElement)jsonArray);
        if (this.lastCompletedDailyId != null && !this.lastCompletedDailyId.isBlank()) {
            json.addProperty("lastCompletedDailyId", this.lastCompletedDailyId);
        }
        if (this.dailyHistory != null && !this.dailyHistory.isEmpty()) {
            JsonObject jsonObject2 = new JsonObject();
            for (Map.Entry<String, Long> e : this.dailyHistory.entrySet()) {
                jsonObject2.addProperty(e.getKey(), (Number)e.getValue());
            }
            json.add("dailyHistory", (JsonElement)jsonObject2);
        }
        return json;
    }

    public static QuestProgress fromJson(JsonObject json) {
        UUID playerId = UUID.fromString(json.get("playerId").getAsString());
        QuestProgress progress = new QuestProgress(playerId);
        if (json.has("completed")) {
            JsonArray completedArray = json.getAsJsonArray("completed");
            for (JsonElement element : completedArray) {
                progress.completedQuests.add(element.getAsString());
            }
        }
        if (json.has("completionTimes")) {
            JsonObject timesObj = json.getAsJsonObject("completionTimes");
            for (Map.Entry entry : timesObj.entrySet()) {
                progress.questCompletionTimes.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsLong());
            }
        }
        if (json.has("progress")) {
            JsonObject progressObj = json.getAsJsonObject("progress");
            for (Map.Entry questEntry : progressObj.entrySet()) {
                String questId = (String)questEntry.getKey();
                JsonObject questProgressObj = ((JsonElement)questEntry.getValue()).getAsJsonObject();
                HashMap<String, Integer> questProgress = new HashMap<String, Integer>();
                for (Map.Entry reqEntry : questProgressObj.entrySet()) {
                    questProgress.put((String)reqEntry.getKey(), ((JsonElement)reqEntry.getValue()).getAsInt());
                }
                progress.questRequirementProgress.put(questId, questProgress);
            }
        }
        if (json.has("claimedRewards")) {
            JsonArray claimedArray = json.getAsJsonArray("claimedRewards");
            for (JsonElement element : claimedArray) {
                progress.claimedRewards.add(element.getAsString());
            }
        }
        if (json.has("lastCompletedDailyId")) {
            progress.lastCompletedDailyId = json.get("lastCompletedDailyId").getAsString();
        }
        if (json.has("dailyHistory")) {
            JsonObject hist = json.getAsJsonObject("dailyHistory");
            for (Map.Entry entry : hist.entrySet()) {
                progress.dailyHistory.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsLong());
            }
        }
        return progress;
    }
}

