/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;
import net.minecraft.class_3222;
import org.texboobcat.questory.quest.Reward;

public class XpReward
extends Reward {
    private int amount;
    private boolean levels;

    public XpReward(int amount, boolean levels) {
        super("xp");
        this.amount = amount;
        this.levels = levels;
    }

    public XpReward(int amount) {
        this(amount, false);
    }

    public int getAmount() {
        return this.amount;
    }

    public boolean isLevels() {
        return this.levels;
    }

    @Override
    public void grant(class_3222 player) {
        if (this.levels) {
            player.method_7316(this.amount);
        } else {
            player.method_7255(this.amount);
        }
    }

    @Override
    public String getDisplayString() {
        if (this.levels) {
            return this.amount + " XP Levels";
        }
        return this.amount + " XP Points";
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.type);
        json.addProperty("amount", (Number)this.amount);
        json.addProperty("levels", Boolean.valueOf(this.levels));
        return json;
    }

    public static XpReward fromJson(JsonObject json) {
        int amount = json.get("amount").getAsInt();
        boolean levels = json.has("levels") && json.get("levels").getAsBoolean();
        return new XpReward(amount, levels);
    }
}

