/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.storage;

import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.texboobcat.questory.storage.backend.ITeamStorageBackend;
import org.texboobcat.questory.team.QuestTeam;

public class TeamStorage {
    private final ITeamStorageBackend backend;

    public TeamStorage(ITeamStorageBackend backend) {
        this.backend = backend;
    }

    public Map<UUID, QuestTeam> loadAllTeams() {
        return this.backend.loadAllTeams();
    }

    public QuestTeam loadTeam(UUID teamId) {
        return this.backend.loadTeam(teamId);
    }

    public void saveTeam(QuestTeam team) {
        this.backend.saveTeam(team);
    }

    public void saveAllTeams(Collection<QuestTeam> teams) {
        this.backend.saveAllTeams(teams);
    }

    public void deleteTeam(UUID teamId) {
        this.backend.deleteTeam(teamId);
    }

    public String getBackendType() {
        return this.backend.getBackendType();
    }

    public boolean healthCheck() {
        return this.backend.healthCheck();
    }

    public void disconnect() {
        this.backend.disconnect();
    }
}

