/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.storage.backend.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.texboobcat.questory.storage.backend.ITeamStorageBackend;
import org.texboobcat.questory.team.QuestTeam;

public class JsonTeamStorageBackend
implements ITeamStorageBackend {
    private final Path teamsPath;
    private final Gson gson;
    private boolean connected = false;

    public JsonTeamStorageBackend(Path dataPath) {
        this.teamsPath = dataPath.resolve("teams");
        this.gson = new GsonBuilder().setPrettyPrinting().create();
    }

    @Override
    public boolean connect() {
        try {
            Files.createDirectories(this.teamsPath, new FileAttribute[0]);
            this.connected = true;
            System.out.println("[Questory] JSON team storage backend connected: " + String.valueOf(this.teamsPath));
            return true;
        }
        catch (IOException e) {
            System.err.println("[Questory] Failed to create teams directory: " + e.getMessage());
            this.connected = false;
            return false;
        }
    }

    @Override
    public void disconnect() {
        this.connected = false;
        System.out.println("[Questory] JSON team storage backend disconnected");
    }

    @Override
    public boolean isConnected() {
        return this.connected && Files.exists(this.teamsPath, new LinkOption[0]);
    }

    @Override
    public boolean healthCheck() {
        return this.isConnected() && Files.isWritable(this.teamsPath);
    }

    @Override
    public String getBackendType() {
        return "JSON";
    }

    @Override
    public QuestTeam loadTeam(UUID teamId) {
        QuestTeam questTeam;
        block9: {
            Path teamPath = this.teamsPath.resolve(String.valueOf(teamId) + ".json");
            if (!Files.exists(teamPath, new LinkOption[0])) {
                return null;
            }
            BufferedReader reader = Files.newBufferedReader(teamPath);
            try {
                JsonObject json = (JsonObject)this.gson.fromJson((Reader)reader, JsonObject.class);
                questTeam = QuestTeam.fromJson(json);
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    System.err.println("[Questory] Failed to load team " + String.valueOf(teamId) + ": " + e.getMessage());
                    return null;
                }
            }
            ((Reader)reader).close();
        }
        return questTeam;
    }

    @Override
    public boolean saveTeam(QuestTeam team) {
        boolean bl;
        block8: {
            Path teamPath = this.teamsPath.resolve(String.valueOf(team.getTeamId()) + ".json");
            BufferedWriter writer = Files.newBufferedWriter(teamPath, new OpenOption[0]);
            try {
                this.gson.toJson((JsonElement)team.toJson(), (Appendable)writer);
                bl = true;
                if (writer == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (writer != null) {
                        try {
                            ((Writer)writer).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    System.err.println("[Questory] Failed to save team " + team.getTeamName() + ": " + e.getMessage());
                    return false;
                }
            }
            ((Writer)writer).close();
        }
        return bl;
    }

    @Override
    public boolean deleteTeam(UUID teamId) {
        Path teamPath = this.teamsPath.resolve(String.valueOf(teamId) + ".json");
        try {
            return Files.deleteIfExists(teamPath);
        }
        catch (IOException e) {
            System.err.println("[Questory] Failed to delete team " + String.valueOf(teamId) + ": " + e.getMessage());
            return false;
        }
    }

    @Override
    public Map<UUID, QuestTeam> loadAllTeams() {
        HashMap<UUID, QuestTeam> teams = new HashMap<UUID, QuestTeam>();
        try {
            if (!Files.exists(this.teamsPath, new LinkOption[0])) {
                return teams;
            }
            Files.list(this.teamsPath).filter(path -> path.toString().endsWith(".json")).forEach(path -> {
                try {
                    QuestTeam team = this.loadTeam((Path)path);
                    if (team != null) {
                        teams.put(team.getTeamId(), team);
                    }
                }
                catch (Exception e) {
                    System.err.println("[Questory] Failed to load team from " + String.valueOf(path) + ": " + e.getMessage());
                }
            });
        }
        catch (IOException e) {
            System.err.println("[Questory] Failed to list teams directory: " + e.getMessage());
        }
        return teams;
    }

    private QuestTeam loadTeam(Path path) {
        QuestTeam questTeam;
        block8: {
            BufferedReader reader = Files.newBufferedReader(path);
            try {
                JsonObject json = (JsonObject)this.gson.fromJson((Reader)reader, JsonObject.class);
                questTeam = QuestTeam.fromJson(json);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    System.err.println("[Questory] Failed to load team from path: " + e.getMessage());
                    return null;
                }
            }
            ((Reader)reader).close();
        }
        return questTeam;
    }
}

