/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.storage.backend.mysql;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.texboobcat.questory.config.QuestoryConfig;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.storage.backend.IPlayerProgressBackend;
import org.texboobcat.questory.storage.backend.mysql.HikariConnectionManager;

public class MysqlPlayerProgressBackend
implements IPlayerProgressBackend {
    private static final Gson GSON = new GsonBuilder().create();
    private final QuestoryConfig config;
    private final HikariConnectionManager connectionManager;
    private final String tablePrefix;

    public MysqlPlayerProgressBackend(QuestoryConfig config) {
        this.config = config;
        this.connectionManager = new HikariConnectionManager(config);
        this.tablePrefix = config.mysqlTablePrefix;
    }

    @Override
    public boolean connect() {
        if (!this.connectionManager.initialize()) {
            return false;
        }
        try {
            this.createTables();
            System.out.println("[Questory] MySQL player progress backend connected");
            return true;
        }
        catch (SQLException e) {
            System.err.println("[Questory] Failed to create MySQL tables: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private void createTables() throws SQLException {
        String createPlayerMetadata = String.format("    CREATE TABLE IF NOT EXISTS %splayer_metadata (\n        player_id VARCHAR(36) PRIMARY KEY,\n        completed_quests TEXT,\n        claimed_rewards TEXT,\n        daily_history TEXT,\n        last_daily_id VARCHAR(255),\n        last_updated TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,\n        INDEX idx_player (player_id)\n    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4\n", this.tablePrefix);
        String createPlayerProgress = String.format("    CREATE TABLE IF NOT EXISTS %splayer_progress (\n        player_id VARCHAR(36) NOT NULL,\n        quest_id VARCHAR(255) NOT NULL,\n        requirement_key VARCHAR(255) NOT NULL,\n        progress INT DEFAULT 0,\n        last_updated TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,\n        PRIMARY KEY (player_id, quest_id, requirement_key),\n        INDEX idx_player (player_id),\n        INDEX idx_quest (quest_id)\n    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4\n", this.tablePrefix);
        try (Connection conn = this.connectionManager.getConnection();
             Statement stmt = conn.createStatement();){
            stmt.execute(createPlayerMetadata);
            stmt.execute(createPlayerProgress);
        }
    }

    @Override
    public void disconnect() {
        this.connectionManager.shutdown();
        System.out.println("[Questory] MySQL player progress backend disconnected");
    }

    @Override
    public boolean isConnected() {
        return this.connectionManager.isRunning();
    }

    @Override
    public boolean healthCheck() {
        return this.connectionManager.healthCheck();
    }

    @Override
    public String getBackendType() {
        return "MySQL";
    }

    @Override
    public QuestProgress loadProgress(UUID playerId) {
        QuestProgress questProgress;
        block20: {
            Connection conn = this.connectionManager.getConnection();
            try {
                QuestProgress progress = new QuestProgress(playerId);
                String metadataQuery = String.format("SELECT * FROM %splayer_metadata WHERE player_id = ?", this.tablePrefix);
                try (PreparedStatement stmt = conn.prepareStatement(metadataQuery);){
                    stmt.setString(1, playerId.toString());
                    ResultSet rs = stmt.executeQuery();
                    if (rs.next()) {
                        String lastDailyId;
                        String dailyHistoryJson;
                        String claimedJson;
                        JsonObject json = new JsonObject();
                        json.addProperty("playerId", playerId.toString());
                        String completedJson = rs.getString("completed_quests");
                        if (completedJson != null && !completedJson.isEmpty()) {
                            json.add("completed", JsonParser.parseString((String)completedJson));
                        }
                        if ((claimedJson = rs.getString("claimed_rewards")) != null && !claimedJson.isEmpty()) {
                            json.add("claimedRewards", JsonParser.parseString((String)claimedJson));
                        }
                        if ((dailyHistoryJson = rs.getString("daily_history")) != null && !dailyHistoryJson.isEmpty()) {
                            json.add("dailyHistory", JsonParser.parseString((String)dailyHistoryJson));
                        }
                        if ((lastDailyId = rs.getString("last_daily_id")) != null && !lastDailyId.isEmpty()) {
                            json.addProperty("lastCompletedDailyId", lastDailyId);
                        }
                        json.add("progress", (JsonElement)this.loadProgressData(conn, playerId));
                        json.add("completionTimes", (JsonElement)new JsonObject());
                        progress = QuestProgress.fromJson(json);
                    }
                }
                questProgress = progress;
                if (conn == null) break block20;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    System.err.println("[Questory] Failed to load progress for player " + String.valueOf(playerId) + ": " + e.getMessage());
                    e.printStackTrace();
                    return null;
                }
            }
            conn.close();
        }
        return questProgress;
    }

    private JsonObject loadProgressData(Connection conn, UUID playerId) throws SQLException {
        JsonObject progressObj = new JsonObject();
        String query = String.format("SELECT quest_id, requirement_key, progress FROM %splayer_progress WHERE player_id = ?", this.tablePrefix);
        try (PreparedStatement stmt = conn.prepareStatement(query);){
            stmt.setString(1, playerId.toString());
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                String questId = rs.getString("quest_id");
                String reqKey = rs.getString("requirement_key");
                int progress = rs.getInt("progress");
                if (!progressObj.has(questId)) {
                    progressObj.add(questId, (JsonElement)new JsonObject());
                }
                progressObj.getAsJsonObject(questId).addProperty(reqKey, (Number)progress);
            }
        }
        return progressObj;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean saveProgress(QuestProgress progress) {
        try (Connection conn = this.connectionManager.getConnection();){
            conn.setAutoCommit(false);
            try {
                String metadataUpsert = String.format("    INSERT INTO %splayer_metadata\n    (player_id, completed_quests, claimed_rewards, daily_history, last_daily_id)\n    VALUES (?, ?, ?, ?, ?)\n    ON DUPLICATE KEY UPDATE\n    completed_quests = VALUES(completed_quests),\n    claimed_rewards = VALUES(claimed_rewards),\n    daily_history = VALUES(daily_history),\n    last_daily_id = VALUES(last_daily_id)\n", this.tablePrefix);
                JsonObject json = progress.toJson();
                try (PreparedStatement stmt = conn.prepareStatement(metadataUpsert);){
                    stmt.setString(1, progress.getPlayerId().toString());
                    stmt.setString(2, json.has("completed") ? json.get("completed").toString() : "[]");
                    stmt.setString(3, json.has("claimedRewards") ? json.get("claimedRewards").toString() : "[]");
                    stmt.setString(4, json.has("dailyHistory") ? json.get("dailyHistory").toString() : "{}");
                    stmt.setString(5, json.has("lastCompletedDailyId") ? json.get("lastCompletedDailyId").getAsString() : "");
                    stmt.executeUpdate();
                }
                if (json.has("progress")) {
                    JsonObject progressObj = json.getAsJsonObject("progress");
                    String progressUpsert = String.format("    INSERT INTO %splayer_progress (player_id, quest_id, requirement_key, progress)\n    VALUES (?, ?, ?, ?)\n    ON DUPLICATE KEY UPDATE progress = VALUES(progress)\n", this.tablePrefix);
                    try (PreparedStatement stmt = conn.prepareStatement(progressUpsert);){
                        for (String questId : progressObj.keySet()) {
                            JsonObject questProgress = progressObj.getAsJsonObject(questId);
                            for (String reqKey : questProgress.keySet()) {
                                stmt.setString(1, progress.getPlayerId().toString());
                                stmt.setString(2, questId);
                                stmt.setString(3, reqKey);
                                stmt.setInt(4, questProgress.get(reqKey).getAsInt());
                                stmt.addBatch();
                            }
                        }
                        stmt.executeBatch();
                    }
                }
                conn.commit();
                boolean bl = true;
                return bl;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
            finally {
                conn.setAutoCommit(true);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        catch (SQLException e) {
            System.err.println("[Questory] Failed to save progress for player " + String.valueOf(progress.getPlayerId()) + ": " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean deleteProgress(UUID playerId) {
        boolean bl;
        block21: {
            Connection conn = this.connectionManager.getConnection();
            try {
                String deleteMetadata = String.format("DELETE FROM %splayer_metadata WHERE player_id = ?", this.tablePrefix);
                String deleteProgress = String.format("DELETE FROM %splayer_progress WHERE player_id = ?", this.tablePrefix);
                try (PreparedStatement stmt1 = conn.prepareStatement(deleteMetadata);
                     PreparedStatement stmt2 = conn.prepareStatement(deleteProgress);){
                    stmt1.setString(1, playerId.toString());
                    stmt2.setString(1, playerId.toString());
                    stmt1.executeUpdate();
                    stmt2.executeUpdate();
                }
                bl = true;
                if (conn == null) break block21;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    System.err.println("[Questory] Failed to delete progress for player " + String.valueOf(playerId) + ": " + e.getMessage());
                    return false;
                }
            }
            conn.close();
        }
        return bl;
    }

    @Override
    public List<UUID> getAllPlayerIds() {
        ArrayList<UUID> playerIds = new ArrayList<UUID>();
        try (Connection conn = this.connectionManager.getConnection();){
            String query = String.format("SELECT DISTINCT player_id FROM %splayer_metadata", this.tablePrefix);
            try (Statement stmt = conn.createStatement();
                 ResultSet rs = stmt.executeQuery(query);){
                while (rs.next()) {
                    try {
                        playerIds.add(UUID.fromString(rs.getString("player_id")));
                    }
                    catch (IllegalArgumentException e) {
                        System.err.println("[Questory] Invalid UUID in database: " + rs.getString("player_id"));
                    }
                }
            }
        }
        catch (SQLException e) {
            System.err.println("[Questory] Failed to get all player IDs: " + e.getMessage());
        }
        return playerIds;
    }
}

